/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.terracotta.management.model.call.Parameter;
import org.terracotta.management.model.capabilities.context.CapabilityContext;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.stats.Statistic;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.management.registry.action.ExposedObject;
import org.terracotta.management.registry.action.Named;
import org.terracotta.management.registry.action.RequiredContext;

public abstract class AbstractManagementProvider<T>
implements ManagementProvider<T> {
    protected final Queue<ExposedObject<T>> managedObjects = new ConcurrentLinkedQueue<ExposedObject<T>>();
    private final String capabilityName;
    private final Class<? extends T> managedType;
    private final CapabilityContext capabilityContext;

    public AbstractManagementProvider(Class<? extends T> managedType) {
        this.managedType = managedType;
        this.capabilityName = this.buildCapabilityName();
        this.capabilityContext = this.buildCapabilityContext();
    }

    @Override
    public final Class<? extends T> getManagedType() {
        return this.managedType;
    }

    @Override
    public final String getCapabilityName() {
        return this.capabilityName;
    }

    @Override
    public final CapabilityContext getCapabilityContext() {
        return this.capabilityContext;
    }

    @Override
    public final void register(T managedObject) {
        this.managedObjects.add(this.wrap(managedObject));
    }

    @Override
    public final void unregister(T managedObject) {
        for (ExposedObject exposedObject : this.managedObjects) {
            if (exposedObject.getTarget() != managedObject || !this.managedObjects.remove(exposedObject)) continue;
            this.dispose(exposedObject);
        }
    }

    @Override
    public final void close() {
        while (!this.managedObjects.isEmpty()) {
            this.dispose(this.managedObjects.poll());
        }
    }

    @Override
    public final boolean supports(Context context) {
        return this.findExposedObject(context) != null;
    }

    @Override
    public Map<String, Statistic<?, ?>> collectStatistics(Context context, Collection<String> statisticNames, long since) {
        throw new UnsupportedOperationException("Not a statistics provider : " + this.getCapabilityName());
    }

    @Override
    public final void callAction(Context context, String methodName, Parameter ... parameters) {
        this.callAction(context, methodName, Object.class, parameters);
    }

    @Override
    public <V> V callAction(Context context, String methodName, Class<V> returnType, Parameter ... parameters) {
        throw new UnsupportedOperationException("Not an action provider : " + this.getCapabilityName());
    }

    @Override
    public Collection<Descriptor> getDescriptors() {
        return Collections.emptyList();
    }

    protected String buildCapabilityName() {
        Named named = this.getClass().getAnnotation(Named.class);
        return named == null ? this.getClass().getSimpleName() : named.value();
    }

    protected CapabilityContext buildCapabilityContext() {
        ArrayList<CapabilityContext.Attribute> attrs = new ArrayList<CapabilityContext.Attribute>();
        RequiredContext requiredContext = this.getManagedType().getAnnotation(RequiredContext.class);
        if (requiredContext == null) {
            requiredContext = this.getClass().getAnnotation(RequiredContext.class);
        }
        if (requiredContext == null) {
            throw new IllegalStateException("@RequiredContext not found on " + this.getManagedType().getName() + " or " + this.getClass().getName());
        }
        for (Named n : requiredContext.value()) {
            attrs.add(new CapabilityContext.Attribute(n.value(), true));
        }
        return new CapabilityContext(attrs);
    }

    protected void dispose(ExposedObject<T> exposedObject) {
    }

    protected abstract ExposedObject<T> wrap(T var1);

    protected final ExposedObject<T> findExposedObject(Context context) {
        if (!this.contextValid(context)) {
            return null;
        }
        for (ExposedObject exposedObject : this.managedObjects) {
            if (!exposedObject.matches(context)) continue;
            return exposedObject;
        }
        return null;
    }

    private boolean contextValid(Context context) {
        if (context == null) {
            return false;
        }
        for (CapabilityContext.Attribute attribute : this.getCapabilityContext().getAttributes()) {
            if (context.get(attribute.getName()) != null) continue;
            return false;
        }
        return true;
    }
}

