/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.registry;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.terracotta.management.model.call.ContextualReturn;
import org.terracotta.management.model.call.Parameter;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.registry.CallQuery;
import org.terracotta.management.registry.CapabilityManagementSupport;
import org.terracotta.management.registry.DefaultResultSet;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.management.registry.ResultSet;

public class DefaultCallQuery<T extends Serializable>
implements CallQuery<T> {
    private final CapabilityManagementSupport capabilityManagement;
    private final String capabilityName;
    private final String methodName;
    private final Parameter[] parameters;
    private final Collection<Context> contexts;
    private final Class<T> returnType;

    public DefaultCallQuery(CapabilityManagementSupport capabilityManagement, String capabilityName, String methodName, Class<T> returnType, Parameter[] parameters, Collection<Context> contexts) {
        this.capabilityManagement = capabilityManagement;
        this.capabilityName = capabilityName;
        this.methodName = methodName;
        this.parameters = parameters;
        this.contexts = Collections.unmodifiableCollection(new ArrayList<Context>(contexts));
        this.returnType = returnType;
    }

    @Override
    public Class<T> getReturnType() {
        return this.returnType;
    }

    @Override
    public String getCapabilityName() {
        return this.capabilityName;
    }

    @Override
    public Collection<Context> getContexts() {
        return this.contexts;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public Parameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public ResultSet<ContextualReturn<T>> execute() {
        LinkedHashMap contextualResults = new LinkedHashMap(this.contexts.size());
        Collection<ManagementProvider<?>> managementProviders = this.capabilityManagement.getManagementProvidersByCapability(this.capabilityName);
        if (managementProviders.isEmpty()) {
            throw new IllegalArgumentException("Bad capability: " + this.capabilityName);
        }
        for (Context context : this.contexts) {
            ContextualReturn<Object> result = ContextualReturn.empty(this.capabilityName, context, this.methodName);
            for (ManagementProvider<?> managementProvider : managementProviders) {
                if (!managementProvider.supports(context)) continue;
                result = ContextualReturn.of(this.capabilityName, context, this.methodName, (Serializable)managementProvider.callAction(context, this.methodName, this.returnType, this.parameters));
                break;
            }
            contextualResults.put(context, result);
        }
        return new DefaultResultSet<ContextualReturn<T>>(contextualResults);
    }
}

