/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.registry;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.terracotta.management.model.call.Parameter;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.registry.CallQuery;
import org.terracotta.management.registry.CapabilityManagementSupport;
import org.terracotta.management.registry.DefaultCallQuery;

public class DefaultCallQueryBuilder<T extends Serializable>
implements CallQuery.Builder<T> {
    private final CapabilityManagementSupport capabilityManagement;
    private final String capabilityName;
    private final String methodName;
    private final Parameter[] parameters;
    private final Collection<Context> contexts;
    private final Class<T> returnType;

    public DefaultCallQueryBuilder(CapabilityManagementSupport capabilityManagement, String capabilityName, String methodName, Class<T> returnType, Parameter ... parameters) {
        this(capabilityManagement, capabilityName, methodName, returnType, parameters, Collections.emptyList());
    }

    private DefaultCallQueryBuilder(CapabilityManagementSupport capabilityManagement, String capabilityName, String methodName, Class<T> returnType, Parameter[] parameters, Collection<Context> contexts) {
        this.capabilityManagement = capabilityManagement;
        this.capabilityName = capabilityName;
        this.methodName = methodName;
        this.parameters = parameters;
        this.contexts = contexts;
        this.returnType = returnType;
    }

    @Override
    public CallQuery<T> build() {
        return new DefaultCallQuery<T>(this.capabilityManagement, this.capabilityName, this.methodName, this.returnType, this.parameters, this.contexts);
    }

    @Override
    public CallQuery.Builder<T> on(Context context) {
        if (!this.contexts.contains(context)) {
            ArrayList<Context> contexts = new ArrayList<Context>(this.contexts);
            contexts.add(context);
            return new DefaultCallQueryBuilder<T>(this.capabilityManagement, this.capabilityName, this.methodName, this.returnType, this.parameters, contexts);
        }
        return this;
    }

    @Override
    public CallQuery.Builder<T> on(Collection<? extends Context> contexts) {
        CallQuery.Builder<T> newBuilder = this;
        for (Context context : contexts) {
            newBuilder = (CallQuery.Builder)newBuilder.on(context);
        }
        return newBuilder;
    }
}

