/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.registry.action;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.terracotta.management.model.call.Parameter;
import org.terracotta.management.model.capabilities.ActionsCapability;
import org.terracotta.management.model.capabilities.Capability;
import org.terracotta.management.model.capabilities.descriptors.CallDescriptor;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.registry.AbstractManagementProvider;
import org.terracotta.management.registry.action.Exposed;
import org.terracotta.management.registry.action.ExposedObject;
import org.terracotta.management.registry.action.Named;

public abstract class AbstractActionManagementProvider<T>
extends AbstractManagementProvider<T> {
    private static final Map<String, Class<?>> PRIMITIVE_MAP = new HashMap();

    public AbstractActionManagementProvider(Class<? extends T> managedType) {
        super(managedType);
    }

    @Override
    public final Capability getCapability() {
        return new ActionsCapability(this.getCapabilityName(), this.getCapabilityContext(), this.getDescriptors());
    }

    @Override
    public final Collection<Descriptor> getDescriptors() {
        HashSet<Descriptor> descriptors = new HashSet<Descriptor>();
        for (ExposedObject o : this.managedObjects) {
            for (Method method : o.getClass().getMethods()) {
                if (!method.isAnnotationPresent(Exposed.class)) continue;
                ArrayList<CallDescriptor.Parameter> parameters = new ArrayList<CallDescriptor.Parameter>();
                for (MethodParameter parameter : AbstractActionManagementProvider.getParameters(method)) {
                    parameters.add(new CallDescriptor.Parameter(parameter.getName(), parameter.getType().getName()));
                }
                descriptors.add(new CallDescriptor(method.getName(), method.getReturnType().getName(), parameters));
            }
        }
        return descriptors;
    }

    @Override
    public final <V> V callAction(Context context, String methodName, Class<V> returnType, Parameter ... parameters) {
        ExposedObject managedObject = this.findExposedObject(context);
        if (managedObject == null) {
            throw new IllegalArgumentException("No such managed object for context : " + context);
        }
        Object[] argClassNames = new String[parameters.length];
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            argClassNames[i] = parameters[i].getClassName();
            args[i] = parameters[i].getValue();
        }
        try {
            Method method = managedObject.getClass().getMethod(methodName, AbstractActionManagementProvider.toClasses(managedObject.getClassLoader(), (String[])argClassNames));
            if (!method.isAnnotationPresent(Exposed.class)) {
                throw new IllegalArgumentException("Method not @Exposed : " + methodName + " with arg(s) " + Arrays.toString(argClassNames));
            }
            return (V)(returnType.isPrimitive() ? method.invoke(managedObject, args) : returnType.cast(method.invoke(managedObject, args)));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No such method : " + methodName + " with arg(s) " + Arrays.toString(argClassNames), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?>[] toClasses(ClassLoader classLoader, String[] classNames) {
        Class[] classes = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            String argClassName = classNames[i];
            classes[i] = PRIMITIVE_MAP.get(argClassName);
            if (classes[i] != null) continue;
            try {
                classes[i] = Class.forName(argClassName, true, classLoader);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("No such class name : " + argClassName, e);
            }
        }
        return classes;
    }

    private static Collection<MethodParameter> getParameters(Method m) {
        Class<?>[] types = m.getParameterTypes();
        ArrayList<MethodParameter> parameters = new ArrayList<MethodParameter>(types.length);
        for (int i = 0; i < types.length; ++i) {
            parameters.add(new MethodParameter(m, i));
        }
        return parameters;
    }

    static {
        for (Class c : new Class[]{Void.TYPE, Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Double.TYPE, Long.TYPE}) {
            PRIMITIVE_MAP.put(c.getName(), c);
        }
    }

    private static class MethodParameter {
        private Method m;
        private int idx;

        public MethodParameter(Method m, int idx) {
            this.m = m;
            this.idx = idx;
        }

        String getName() {
            for (Annotation annotation : this.m.getParameterAnnotations()[this.idx]) {
                if (Named.class != annotation.annotationType()) continue;
                return ((Named)Named.class.cast(annotation)).value();
            }
            return "arg" + this.idx;
        }

        Class<?> getType() {
            return this.m.getParameterTypes()[this.idx];
        }
    }
}

