/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.registry.collect;

import java.util.Collection;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.registry.action.AbstractActionManagementProvider;
import org.terracotta.management.registry.action.Exposed;
import org.terracotta.management.registry.action.ExposedObject;
import org.terracotta.management.registry.action.Named;
import org.terracotta.management.registry.collect.StatisticCollector;

@Named(value="StatisticCollectorCapability")
public class StatisticCollectorProvider<T extends StatisticCollector>
extends AbstractActionManagementProvider<T> {
    private final Context context;

    public StatisticCollectorProvider(Class<? extends T> type, Context context) {
        super(type);
        this.context = context;
    }

    @Override
    protected ExposedObject<T> wrap(T managedObject) {
        return new ExposedStatisticCollector<T>(managedObject, this.context);
    }

    public static class ExposedStatisticCollector<T extends StatisticCollector>
    implements ExposedObject<T> {
        private final T collectorService;
        private final Context context;

        public ExposedStatisticCollector(T collectorService, Context context) {
            this.collectorService = collectorService;
            this.context = context;
        }

        @Exposed
        public void updateCollectedStatistics(@Named(value="capabilityName") String capabilityName, @Named(value="statisticNames") Collection<String> statisticNames) {
            this.collectorService.updateCollectedStatistics(capabilityName, statisticNames);
        }

        @Exposed
        public void stopStatisticCollector() {
            this.collectorService.stopStatisticCollector();
        }

        @Exposed
        public void startStatisticCollector() {
            this.collectorService.startStatisticCollector();
        }

        @Override
        public T getTarget() {
            return this.collectorService;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.collectorService.getClass().getClassLoader();
        }

        @Override
        public boolean matches(Context context) {
            return context.contains(this.context);
        }
    }
}

