/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.terracotta.connection.entity.Entity;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.voltron.proxy.Codec;
import org.terracotta.voltron.proxy.CommonProxyFactory;
import org.terracotta.voltron.proxy.SerializationCodec;
import org.terracotta.voltron.proxy.client.VoltronProxyInvocationHandler;
import org.terracotta.voltron.proxy.client.messages.ServerMessageAware;

public class ClientProxyFactory {
    public static <T extends Entity & ServerMessageAware<?>> T createEntityProxy(Class<T> clientType, Class<? super T> type, EntityClientEndpoint entityClientEndpoint, Class<?> ... messageTypes) {
        return (T)((Entity)ClientProxyFactory.createProxy(clientType, type, entityClientEndpoint, new SerializationCodec(), messageTypes));
    }

    public static <T extends Entity & ServerMessageAware<?>> T createEntityProxy(Class<T> clientType, Class<? super T> type, EntityClientEndpoint entityClientEndpoint, Codec codec, Class<?> messageType, Class<?> ... messageTypes) {
        return (T)((Entity)ClientProxyFactory.createProxy(clientType, type, entityClientEndpoint, codec, ClientProxyFactory.sum(messageType, messageTypes)));
    }

    public static <T extends Entity> T createEntityProxy(Class<T> clientType, Class<? super T> type, EntityClientEndpoint entityClientEndpoint) {
        return (T)((Entity)ClientProxyFactory.createProxy(clientType, type, entityClientEndpoint));
    }

    public static <T extends Entity> T createEntityProxy(Class<T> clientType, Class<? super T> type, EntityClientEndpoint entityClientEndpoint, Codec codec) {
        return (T)((Entity)ClientProxyFactory.createProxy(clientType, type, entityClientEndpoint, codec, new Class[0]));
    }

    public static <T> T createProxy(Class<T> clientType, Class<? super T> type, EntityClientEndpoint entityClientEndpoint) {
        return ClientProxyFactory.createProxy(clientType, type, entityClientEndpoint, new SerializationCodec(), new Class[0]);
    }

    public static <T> T createProxy(Class<T> clientType, Class<? super T> type, EntityClientEndpoint entityClientEndpoint, Codec codec, Class ... messageTypes) {
        if (entityClientEndpoint == null) {
            throw new NullPointerException("EntityClientEndpoint has to be provided!");
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException("We only proxy interfaces!");
        }
        Class[] interfaces = messageTypes.length == 0 ? new Class[]{clientType, Entity.class} : new Class[]{clientType, Entity.class, ServerMessageAware.class};
        return clientType.cast(Proxy.newProxyInstance(Entity.class.getClassLoader(), interfaces, (InvocationHandler)new VoltronProxyInvocationHandler(CommonProxyFactory.invert(CommonProxyFactory.createMethodMappings(type)), entityClientEndpoint, codec, CommonProxyFactory.invert(CommonProxyFactory.createResponseTypeMappings(type, messageTypes)))));
    }

    private static Class<?>[] sum(Class<?> one, Class<?>[] others) {
        Class[] result = new Class[others.length + 1];
        result[0] = one;
        System.arraycopy(others, 0, result, 1, others.length);
        return result;
    }
}

