/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy.client;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.terracotta.entity.EndpointDelegate;
import org.terracotta.voltron.proxy.Codec;
import org.terracotta.voltron.proxy.client.messages.MessageListener;

class ProxyEndpointDelegate
implements EndpointDelegate {
    private final Codec codec;
    private final ConcurrentMap<Class<?>, CopyOnWriteArrayList<MessageListener>> listeners;
    private final Map<Byte, Class<?>> eventMappings;

    public ProxyEndpointDelegate(Codec codec, ConcurrentMap<Class<?>, CopyOnWriteArrayList<MessageListener>> listeners, Map<Byte, Class<?>> eventMappings) {
        this.codec = codec;
        this.listeners = listeners;
        this.eventMappings = eventMappings;
    }

    public void handleMessage(byte[] bytes) {
        Object message = this.codec.decode(Arrays.copyOfRange(bytes, 1, bytes.length), this.eventMappings.get(bytes[0]));
        Class<?> aClass = message.getClass();
        for (MessageListener messageListener : (CopyOnWriteArrayList)this.listeners.get(aClass)) {
            messageListener.onMessage(message);
        }
    }

    public byte[] createExtendedReconnectData() {
        return new byte[0];
    }

    public void didDisconnectUnexpectedly() {
    }
}

