/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy.server.messages;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.terracotta.voltron.proxy.client.messages.MessageListener;

public abstract class MessageFiring {
    private static final MessageListener FAKE = new MessageListener(){

        public void onMessage(Object message) {
        }
    };
    private final ConcurrentMap<Class<?>, MessageListener> listeners = new ConcurrentHashMap();

    public MessageFiring(Class<?> ... messageTypes) {
        for (Class<?> messageType : messageTypes) {
            this.listeners.put(messageType, FAKE);
        }
    }

    protected void fire(Object message) {
        ((MessageListener)this.listeners.get(message.getClass())).onMessage(message);
    }

    public <T> void registerListener(Class<T> messageType, MessageListener<T> listener) {
        if (!this.listeners.replace(messageType, FAKE, listener)) {
            throw new IllegalStateException();
        }
    }
}

