/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.terracotta.voltron.proxy.Async;

public final class MethodDescriptor {
    private final boolean async;
    private final Class<?> messageType;
    private final Method method;
    private final Async.Ack ack;

    private MethodDescriptor(Method method) {
        this.method = method;
        Async asyncAnnot = method.getAnnotation(Async.class);
        boolean bl = this.async = asyncAnnot != null;
        if (this.async) {
            if (method.getReturnType() != Future.class) {
                throw new IllegalStateException("@Async requires a Future as a return type on method: " + method);
            }
            this.ack = asyncAnnot.value();
            Type returnType = method.getGenericReturnType();
            this.messageType = returnType instanceof Class ? Object.class : MethodDescriptor.determineRawType(((ParameterizedType)returnType).getActualTypeArguments()[0]);
        } else {
            this.ack = Async.Ack.NONE;
            this.messageType = method.getReturnType();
        }
    }

    public Async.Ack getAck() {
        return this.ack;
    }

    public boolean isAsync() {
        return this.async;
    }

    public Class<?> getMessageType() {
        return this.messageType;
    }

    public static MethodDescriptor of(Method method) {
        return new MethodDescriptor(method);
    }

    public String toGenericString() {
        return this.method.toGenericString();
    }

    public String toString() {
        return this.toGenericString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodDescriptor that = (MethodDescriptor)o;
        return this.method.equals(that.method);
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public Class<?>[] getParameterTypes() {
        return this.method.getParameterTypes();
    }

    public Annotation[][] getParameterAnnotations() {
        return this.method.getParameterAnnotations();
    }

    public Object invoke(Object target, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object ret = this.method.invoke(target, args);
        if (this.async) {
            try {
                ret = ((Future)ret).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InvocationTargetException(e);
            }
            catch (ExecutionException e) {
                throw new InvocationTargetException(e.getCause());
            }
        }
        return ret;
    }

    public Method getMethod() {
        return this.method;
    }

    private static Class<?> determineRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return MethodDescriptor.determineRawType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            return MethodDescriptor.determineRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            Class<?> rawComponentType = MethodDescriptor.determineRawType(((GenericArrayType)type).getGenericComponentType());
            return Array.newInstance(rawComponentType, 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return MethodDescriptor.determineRawType(((TypeVariable)type).getBounds()[0]);
        }
        throw new IllegalStateException("Unsupported type: " + type);
    }
}

