/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Map;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.voltron.proxy.ClientId;
import org.terracotta.voltron.proxy.Codec;
import org.terracotta.voltron.proxy.CommonProxyFactory;
import org.terracotta.voltron.proxy.MethodDescriptor;
import org.terracotta.voltron.proxy.server.messages.ProxyEntityMessage;
import org.terracotta.voltron.proxy.server.messages.ProxyEntityResponse;

public class ProxyMessageCodec
implements MessageCodec<ProxyEntityMessage, ProxyEntityResponse> {
    private final Codec codec;
    private final Map<Byte, MethodDescriptor> methodMappings;
    private final Map<MethodDescriptor, Byte> reverseMethodMappings;
    private final Map<Class<?>, Byte> responseMappings;
    private final Map<Byte, Class<?>> reverseResponseMappings;

    public ProxyMessageCodec(Codec codec, Class<?> proxyType, Class<?> ... eventTypes) {
        this.codec = codec;
        this.methodMappings = CommonProxyFactory.createMethodMappings(proxyType);
        this.reverseMethodMappings = CommonProxyFactory.invert(this.methodMappings);
        this.responseMappings = CommonProxyFactory.createResponseTypeMappings(proxyType, eventTypes);
        this.reverseResponseMappings = CommonProxyFactory.invert(this.responseMappings);
    }

    public byte[] encodeResponse(ProxyEntityResponse r) {
        Byte messageTypeIdentifier = this.responseMappings.get(r.getResponseType());
        if (messageTypeIdentifier == null) {
            throw new AssertionError((Object)("WAT, no mapping for " + r.getResponseType().getName()));
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(byteOut);
        try {
            output.writeByte(messageTypeIdentifier.byteValue());
            output.write(this.codec.encode(r.getResponseType(), r.getResponse()));
            output.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteOut.toByteArray();
    }

    public ProxyEntityResponse decodeResponse(byte[] binary) throws MessageCodecException {
        byte messageTypeIdentifier = binary[0];
        Class<?> responseType = this.reverseResponseMappings.get(messageTypeIdentifier);
        if (responseType == null) {
            throw new AssertionError((Object)("WAT, no mapping for " + messageTypeIdentifier));
        }
        return ProxyEntityResponse.response(responseType, this.codec.decode(Arrays.copyOfRange(binary, 1, binary.length), responseType));
    }

    public byte[] encodeMessage(ProxyEntityMessage message) throws MessageCodecException {
        try {
            MethodDescriptor method = message.getMethod();
            Object[] args = message.getArguments();
            Byte methodIdentifier = this.reverseMethodMappings.get(method);
            if (methodIdentifier == null) {
                throw new AssertionError((Object)("WAT, no mapping for " + method.toGenericString()));
            }
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteOut);
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            int parameterAnnotationsLength = parameterAnnotations.length;
            for (int i = 0; i < parameterAnnotationsLength; ++i) {
                Annotation[] parameterAnnotation;
                for (Annotation annotation : parameterAnnotation = parameterAnnotations[i]) {
                    if (annotation.annotationType() != ClientId.class) continue;
                    args[i] = null;
                }
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            output.writeByte(methodIdentifier.byteValue());
            output.write(this.codec.encode(parameterTypes, args));
            output.close();
            return byteOut.toByteArray();
        }
        catch (IOException ex) {
            throw new MessageCodecException("Error encoding ProxyEntityMessage", (Throwable)ex);
        }
    }

    public ProxyEntityMessage decodeMessage(byte[] bytes) {
        MethodDescriptor method = this.decodeMethod(bytes[0]);
        return new ProxyEntityMessage(method, this.decodeArgs(bytes, method.getParameterTypes()));
    }

    public byte[] serializeForSync(int concurrencyKey, ProxyEntityResponse payload) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ProxyEntityMessage deserializeForSync(int i, byte[] bytes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private MethodDescriptor decodeMethod(byte b) {
        MethodDescriptor method = this.methodMappings.get(b);
        if (method == null) {
            throw new AssertionError();
        }
        return method;
    }

    private Object[] decodeArgs(byte[] arg, Class<?>[] parameterTypes) {
        return this.codec.decode(Arrays.copyOfRange(arg, 1, arg.length), parameterTypes);
    }
}

