/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy.client;

import org.terracotta.connection.entity.Entity;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityClientService;
import org.terracotta.entity.MessageCodec;
import org.terracotta.voltron.proxy.Codec;
import org.terracotta.voltron.proxy.ProxyMessageCodec;
import org.terracotta.voltron.proxy.SerializationCodec;
import org.terracotta.voltron.proxy.client.ClientProxyFactory;
import org.terracotta.voltron.proxy.server.messages.ProxyEntityMessage;
import org.terracotta.voltron.proxy.server.messages.ProxyEntityResponse;

public abstract class ProxyEntityClientService<T extends Entity, C>
implements EntityClientService<T, C, ProxyEntityMessage, ProxyEntityResponse> {
    private final Class<T> clientType;
    private final Class<? super T> type;
    private final Codec codec;
    private final Class<?>[] messageTypes;
    private final Class<C> configType;

    public ProxyEntityClientService(Class<T> clientType, Class<? super T> type, Class<C> configType, Class<?> ... messageTypes) {
        this(clientType, type, configType, new SerializationCodec(), messageTypes);
    }

    public ProxyEntityClientService(Class<T> clientType, Class<? super T> type, Class<C> configType) {
        this(clientType, type, configType, new SerializationCodec(), new Class[0]);
    }

    public ProxyEntityClientService(Class<T> clientType, Class<? super T> type, Class<C> configType, Codec codec, Class<?> ... messageTypes) {
        this.clientType = clientType;
        this.type = type;
        this.configType = configType;
        this.codec = codec;
        this.messageTypes = messageTypes;
    }

    public boolean handlesEntityType(Class<T> aClass) {
        return aClass == this.clientType;
    }

    public T create(EntityClientEndpoint<ProxyEntityMessage, ProxyEntityResponse> endpoint) {
        return ClientProxyFactory.createEntityProxy(this.clientType, this.type, endpoint, this.messageTypes);
    }

    public MessageCodec<ProxyEntityMessage, ProxyEntityResponse> getMessageCodec() {
        return new ProxyMessageCodec(this.codec, this.type, this.messageTypes);
    }

    public C deserializeConfiguration(byte[] configuration) {
        if (this.configType == Void.TYPE) {
            return null;
        }
        return this.configType.cast(this.codec.decode(configuration, this.configType));
    }

    public byte[] serializeConfiguration(C configuration) {
        if (this.configType == Void.TYPE) {
            return new byte[0];
        }
        return this.codec.encode(this.configType, configuration);
    }

    private static Class<?>[] sum(Class<?> one, Class<?>[] others) {
        Class[] result = new Class[others.length + 1];
        result[0] = one;
        System.arraycopy(others, 0, result, 1, others.length);
        return result;
    }
}

