/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.terracotta.connection.entity.Entity;
import org.terracotta.entity.EndpointDelegate;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.InvocationBuilder;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.exception.EntityException;
import org.terracotta.voltron.proxy.MethodDescriptor;
import org.terracotta.voltron.proxy.client.ProxyEndpointDelegate;
import org.terracotta.voltron.proxy.client.messages.MessageListener;
import org.terracotta.voltron.proxy.client.messages.ServerMessageAware;
import org.terracotta.voltron.proxy.server.messages.ProxyEntityMessage;
import org.terracotta.voltron.proxy.server.messages.ProxyEntityResponse;

class VoltronProxyInvocationHandler
implements InvocationHandler {
    private static final Method close;
    private static final Method registerListener;
    private final EntityClientEndpoint<ProxyEntityMessage, ProxyEntityResponse> entityClientEndpoint;
    private final ConcurrentMap<Class<?>, CopyOnWriteArrayList<MessageListener>> listeners;

    public VoltronProxyInvocationHandler(EntityClientEndpoint<ProxyEntityMessage, ProxyEntityResponse> entityClientEndpoint, Collection<Class<?>> events) {
        this.entityClientEndpoint = entityClientEndpoint;
        this.listeners = new ConcurrentHashMap();
        if (events.size() > 0) {
            for (Class<?> aClass : events) {
                this.listeners.put(aClass, new CopyOnWriteArrayList());
            }
            entityClientEndpoint.setDelegate((EndpointDelegate)new ProxyEndpointDelegate(this.listeners));
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (close.equals(method)) {
            this.entityClientEndpoint.close();
            return null;
        }
        if (registerListener.equals(method)) {
            MessageListener arg = (MessageListener)args[0];
            Class<?> eventType = VoltronProxyInvocationHandler.getMessageListenerEventType(arg);
            CopyOnWriteArrayList messageListeners = (CopyOnWriteArrayList)this.listeners.get(eventType);
            if (messageListeners == null) {
                throw new IllegalArgumentException("Event type '" + eventType + "' isn't supported");
            }
            messageListeners.add(arg);
            return null;
        }
        MethodDescriptor methodDescriptor = MethodDescriptor.of(method);
        InvocationBuilder builder = this.entityClientEndpoint.beginInvoke().message((EntityMessage)new ProxyEntityMessage(methodDescriptor, args));
        if (methodDescriptor.isAsync()) {
            switch (methodDescriptor.getAck()) {
                case NONE: {
                    break;
                }
                case RECEIVED: {
                    builder.ackReceived();
                    break;
                }
                default: {
                    throw new IllegalStateException(methodDescriptor.getAck().name());
                }
            }
            return new ProxiedInvokeFuture((InvokeFuture<ProxyEntityResponse>)builder.invoke());
        }
        return ((ProxyEntityResponse)builder.invoke().get()).getResponse();
    }

    private static Class<?> getMessageListenerEventType(MessageListener from) {
        for (Method m : from.getClass().getMethods()) {
            Class<?>[] params;
            if (!m.getName().equals("onMessage") || m.isBridge() || (params = m.getParameterTypes()).length != 1 || m.getParameterTypes()[0].isPrimitive()) continue;
            return m.getParameterTypes()[0];
        }
        throw new AssertionError();
    }

    static {
        try {
            close = Entity.class.getDeclaredMethod("close", new Class[0]);
            registerListener = ServerMessageAware.class.getDeclaredMethod("registerListener", MessageListener.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)"Someone changed some method signature here!!!");
        }
    }

    private static class ProxiedInvokeFuture
    implements Future {
        private final InvokeFuture<ProxyEntityResponse> future;
        private final AtomicBoolean cancelled = new AtomicBoolean(false);

        public ProxiedInvokeFuture(InvokeFuture<ProxyEntityResponse> future) {
            this.future = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.cancelled.compareAndSet(false, true)) {
                this.future.interrupt();
                return true;
            }
            return false;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled.get();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        public Object get() throws InterruptedException, ExecutionException {
            try {
                return ((ProxyEntityResponse)this.future.get()).getResponse();
            }
            catch (EntityException e) {
                throw new ExecutionException(e);
            }
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return ((ProxyEntityResponse)this.future.getWithTimeout(timeout, unit)).getResponse();
            }
            catch (EntityException e) {
                throw new ExecutionException(e);
            }
        }
    }
}

