/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy.server;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.terracotta.entity.ClientCommunicator;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.voltron.proxy.client.messages.MessageListener;
import org.terracotta.voltron.proxy.server.messages.MessageFiring;
import org.terracotta.voltron.proxy.server.messages.ProxyEntityMessage;
import org.terracotta.voltron.proxy.server.messages.ProxyEntityResponse;

public class ProxyInvoker<T> {
    private final T target;
    private final Set<Class<?>> messageTypes;
    private final ClientCommunicator clientCommunicator;
    private final Set<ClientDescriptor> clients = Collections.synchronizedSet(new HashSet());
    private final ThreadLocal<InvocationContext> invocationContext = new ThreadLocal();

    public ProxyInvoker(T target) {
        this(target, null, new Class[0]);
    }

    public ProxyInvoker(T target, ClientCommunicator clientCommunicator, Class<?> ... messageTypes) {
        this.target = target;
        this.messageTypes = new HashSet();
        for (Class<?> eventType : messageTypes) {
            this.messageTypes.add(eventType);
            if (!(target instanceof MessageFiring)) continue;
            ((MessageFiring)target).registerListener(eventType, new MessageListener(){

                public void onMessage(Object message) {
                    ProxyInvoker.this.fireMessage(message);
                }
            });
        }
        if (messageTypes.length != 0 && clientCommunicator == null) {
            throw new IllegalArgumentException("Messages cannot be sent using a null ClientCommunicator");
        }
        this.clientCommunicator = clientCommunicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyEntityResponse invoke(ClientDescriptor clientDescriptor, ProxyEntityMessage message) {
        try {
            this.invocationContext.set(new InvocationContext(clientDescriptor));
            ProxyEntityResponse proxyEntityResponse = ProxyEntityResponse.response(message.messageType(), message.invoke(this.target, clientDescriptor));
            this.invocationContext.remove();
            return proxyEntityResponse;
        }
        catch (Throwable throwable) {
            try {
                this.invocationContext.remove();
                throw throwable;
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    public void fireMessage(Object message) {
        Class<?> type = message.getClass();
        if (!this.messageTypes.contains(type)) {
            throw new IllegalArgumentException("Event type '" + type + "' isn't supported");
        }
        HashSet<Future> futures = new HashSet<Future>();
        InvocationContext invocationContext = this.invocationContext.get();
        ClientDescriptor caller = invocationContext == null ? null : invocationContext.caller;
        for (ClientDescriptor client : this.clients) {
            if (client.equals(caller)) continue;
            try {
                futures.add(this.clientCommunicator.send(client, (EntityResponse)ProxyEntityResponse.response(type, message)));
            }
            catch (MessageCodecException ex) {
                throw new RuntimeException(ex);
            }
        }
        boolean interrupted = false;
        while (!futures.isEmpty()) {
            Iterator iterator = futures.iterator();
            while (iterator.hasNext()) {
                Future future = (Future)iterator.next();
                try {
                    future.get();
                    iterator.remove();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                catch (ExecutionException e) {
                    iterator.remove();
                    e.printStackTrace();
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void fireAndForgetMessage(Object message, ClientDescriptor ... clients) {
        Class<?> type = message.getClass();
        if (!this.messageTypes.contains(type)) {
            throw new IllegalArgumentException("Event type '" + type + "' isn't supported");
        }
        for (ClientDescriptor client : clients) {
            try {
                this.clientCommunicator.sendNoResponse(client, (EntityResponse)ProxyEntityResponse.response(type, message));
            }
            catch (MessageCodecException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void addClient(ClientDescriptor descriptor) {
        this.clients.add(descriptor);
    }

    public void removeClient(ClientDescriptor descriptor) {
        this.clients.remove(descriptor);
    }

    private final class InvocationContext {
        private final ClientDescriptor caller;

        public InvocationContext(ClientDescriptor caller) {
            this.caller = caller;
        }
    }
}

