/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy.server.messages;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.EntityMessage;
import org.terracotta.voltron.proxy.ClientId;
import org.terracotta.voltron.proxy.MethodDescriptor;

public class ProxyEntityMessage
implements EntityMessage {
    private final MethodDescriptor method;
    private final Object[] args;
    private final AtomicBoolean consumed = new AtomicBoolean(false);

    public ProxyEntityMessage(MethodDescriptor method, Object[] args) {
        this.method = method;
        this.args = args;
    }

    public MethodDescriptor getMethod() {
        return this.method;
    }

    public Object[] getArguments() {
        return this.args;
    }

    public Object invoke(Object target, ClientDescriptor clientDescriptor) throws InvocationTargetException, IllegalAccessException {
        if (!this.consumed.compareAndSet(false, true)) {
            throw new IllegalStateException("Message was consumed already!");
        }
        if (clientDescriptor != null) {
            Annotation[][] allAnnotations = this.method.getParameterAnnotations();
            block0: for (int i = 0; i < allAnnotations.length; ++i) {
                for (Annotation parameterAnnotation : allAnnotations[i]) {
                    if (parameterAnnotation.annotationType() != ClientId.class) continue;
                    this.args[i] = clientDescriptor;
                    continue block0;
                }
            }
        }
        return this.method.invoke(target, this.args);
    }

    public Class<?> messageType() {
        return this.method.getMessageType();
    }
}

