/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.entity.helloworld.client;

import org.terracotta.connection.Connection;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.management.entity.helloworld.client.HelloWorldEntity;

public class HelloWorldEntityFactory {
    private final Connection connection;

    public HelloWorldEntityFactory(Connection connection) {
        this.connection = connection;
    }

    public HelloWorldEntity retrieveOrCreate(String entityName) {
        try {
            return this.retrieve(entityName);
        }
        catch (EntityNotFoundException e) {
            try {
                return this.create(entityName);
            }
            catch (EntityAlreadyExistsException f) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public HelloWorldEntity retrieve(String entityName) throws EntityNotFoundException {
        try {
            return (HelloWorldEntity)this.getEntityRef(entityName).fetchEntity();
        }
        catch (EntityVersionMismatchException e) {
            throw new AssertionError((Object)e);
        }
    }

    public HelloWorldEntity create(String identifier) throws EntityAlreadyExistsException {
        EntityRef<HelloWorldEntity, Void> ref = this.getEntityRef(identifier);
        try {
            ref.create(null);
            return (HelloWorldEntity)ref.fetchEntity();
        }
        catch (EntityNotFoundException | EntityNotProvidedException | EntityVersionMismatchException e) {
            throw new AssertionError((Object)e);
        }
    }

    private EntityRef<HelloWorldEntity, Void> getEntityRef(String entityName) {
        try {
            return this.connection.getEntityRef(HelloWorldEntity.class, 1L, entityName);
        }
        catch (EntityNotProvidedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

