/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.entity.monitoringconsumer.client;

import org.terracotta.connection.Connection;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.management.entity.monitoringconsumer.client.MonitoringConsumerEntity;

public class MonitoringConsumerEntityFactory {
    private final Connection connection;

    public MonitoringConsumerEntityFactory(Connection connection) {
        this.connection = connection;
    }

    public MonitoringConsumerEntity retrieveOrCreate(String entityName) {
        try {
            return this.retrieve(entityName);
        }
        catch (EntityNotFoundException e) {
            try {
                return this.create(entityName);
            }
            catch (EntityAlreadyExistsException f) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public MonitoringConsumerEntity retrieve(String entityName) throws EntityNotFoundException {
        try {
            return (MonitoringConsumerEntity)this.getEntityRef(entityName).fetchEntity();
        }
        catch (EntityVersionMismatchException e) {
            throw new AssertionError((Object)e);
        }
    }

    public MonitoringConsumerEntity create(String identifier) throws EntityAlreadyExistsException {
        EntityRef<MonitoringConsumerEntity, Void> ref = this.getEntityRef(identifier);
        try {
            ref.create(null);
            return (MonitoringConsumerEntity)ref.fetchEntity();
        }
        catch (EntityNotFoundException | EntityNotProvidedException | EntityVersionMismatchException e) {
            throw new AssertionError((Object)e);
        }
    }

    private EntityRef<MonitoringConsumerEntity, Void> getEntityRef(String entityName) {
        try {
            return this.connection.getEntityRef(MonitoringConsumerEntity.class, 1L, entityName);
        }
        catch (EntityNotProvidedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

