/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapstore.disk.storage;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.offheapstore.disk.paging.MappedPageSource;
import org.terracotta.offheapstore.disk.persistent.Persistent;
import org.terracotta.offheapstore.disk.persistent.PersistentStorageEngine;
import org.terracotta.offheapstore.disk.storage.AATreeFileAllocator;
import org.terracotta.offheapstore.storage.PortabilityBasedStorageEngine;
import org.terracotta.offheapstore.storage.StorageEngine;
import org.terracotta.offheapstore.storage.portability.Portability;
import org.terracotta.offheapstore.storage.portability.WriteContext;
import org.terracotta.offheapstore.util.Factory;

public class FileBackedStorageEngine<K, V>
extends PortabilityBasedStorageEngine<K, V>
implements PersistentStorageEngine<K, V> {
    private static final int MAGIC = 1095582789;
    private static final int MAGIC_CHUNK = 1313753427;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBackedStorageEngine.class);
    private static final int KEY_HASH_OFFSET = 0;
    private static final int KEY_LENGTH_OFFSET = 4;
    private static final int VALUE_LENGTH_OFFSET = 8;
    private static final int KEY_DATA_OFFSET = 12;
    private final ConcurrentHashMap<Long, FileWriteTask> pendingWrites = new ConcurrentHashMap();
    private final ExecutorService writeExecutor;
    private final MappedPageSource source;
    private final FileChannel writeChannel;
    private final AtomicReference<FileChannel> readChannelReference;
    private final long initialSize;
    private final int chunkIndexOffset;
    private final List<FileChunk> chunks = new CopyOnWriteArrayList<FileChunk>();
    private volatile StorageEngine.Owner owner;

    public static <K, V> Factory<FileBackedStorageEngine<K, V>> createFactory(MappedPageSource source, int initialSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        return FileBackedStorageEngine.createFactory(source, initialSize, keyPortability, valuePortability, true);
    }

    public static <K, V> Factory<FileBackedStorageEngine<K, V>> createFactory(MappedPageSource source, int initialSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean bootstrap) {
        Factory<ThreadPoolExecutor> executorFactory = new Factory<ThreadPoolExecutor>(){

            @Override
            public ThreadPoolExecutor newInstance() {
                return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            }
        };
        return FileBackedStorageEngine.createFactory(source, initialSize, keyPortability, valuePortability, executorFactory, bootstrap);
    }

    public static <K, V> Factory<FileBackedStorageEngine<K, V>> createFactory(final MappedPageSource source, final int initialSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final Factory<ThreadPoolExecutor> executorFactory, final boolean bootstrap) {
        return new Factory<FileBackedStorageEngine<K, V>>(){

            @Override
            public FileBackedStorageEngine<K, V> newInstance() {
                return new FileBackedStorageEngine(source, keyPortability, valuePortability, initialSize, (ThreadPoolExecutor)executorFactory.newInstance(), bootstrap);
            }
        };
    }

    public FileBackedStorageEngine(MappedPageSource source, Portability<? super K> keyPortability, Portability<? super V> valuePortability, int initialSize) {
        this(source, keyPortability, valuePortability, initialSize, true);
    }

    public FileBackedStorageEngine(MappedPageSource source, Portability<? super K> keyPortability, Portability<? super V> valuePortability, int initialSize, ThreadPoolExecutor writer) {
        this(source, keyPortability, valuePortability, initialSize, writer, true);
    }

    public FileBackedStorageEngine(MappedPageSource source, Portability<? super K> keyPortability, Portability<? super V> valuePortability, int initialSize, boolean bootstrap) {
        this(source, keyPortability, valuePortability, initialSize, new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()), bootstrap);
    }

    public FileBackedStorageEngine(MappedPageSource source, Portability<? super K> keyPortability, Portability<? super V> valuePortability, int initialSize, ThreadPoolExecutor writer, boolean bootstrap) {
        super(keyPortability, valuePortability);
        if (writer.getMaximumPoolSize() > 1) {
            throw new AssertionError();
        }
        this.writeExecutor = writer;
        this.writeChannel = source.getWritableChannel();
        this.readChannelReference = new AtomicReference<FileChannel>(source.getReadableChannel());
        this.source = source;
        this.initialSize = initialSize;
        this.chunkIndexOffset = 32 - Integer.numberOfLeadingZeros(initialSize);
        if (bootstrap) {
            this.chunks.add(new FileChunk(initialSize, 0L));
        }
    }

    @Override
    protected void clearInternal() {
        for (FileChunk c : this.chunks) {
            c.clear();
            if (!this.chunks.remove(c)) {
                throw new AssertionError((Object)"Concurrent modification while clearing!");
            }
        }
        if (!this.chunks.isEmpty()) {
            throw new AssertionError((Object)"Concurrent modification while clearing!");
        }
        this.chunks.add(new FileChunk(this.initialSize, 0L));
    }

    @Override
    public void destroy() {
        try {
            this.close();
        }
        catch (IOException e) {
            LOGGER.warn("Exception while trying to close file backed storage engine", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Future<Void> flush = this.writeExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                FileBackedStorageEngine.this.writeChannel.force(true);
                return null;
            }
        });
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    flush.get();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new RuntimeException(cause);
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.writeExecutor.shutdownNow();
            if (this.writeExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                LOGGER.debug("FileBackedStorageEngine for " + this.source.getFile().getName() + " terminated successfully");
            } else {
                LOGGER.warn("FileBackedStorageEngine for " + this.source.getFile().getName() + " timed-out during termination");
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("FileBackedStorageEngine for " + this.source.getFile().getName() + " interrupted during termination");
            Thread.currentThread().interrupt();
        }
        finally {
            try {
                this.writeChannel.close();
            }
            finally {
                ((FileChannel)this.readChannelReference.getAndSet(null)).close();
            }
        }
    }

    @Override
    public void persist(ObjectOutput output) throws IOException {
        output.writeInt(1095582789);
        ((Persistent)((Object)this.keyPortability)).persist(output);
        ((Persistent)((Object)this.valuePortability)).persist(output);
        output.writeInt(this.chunks.size());
        for (FileChunk c : this.chunks) {
            c.persist(output);
        }
    }

    @Override
    public void bootstrap(ObjectInput input) throws IOException {
        if (!this.chunks.isEmpty()) {
            throw new IllegalStateException();
        }
        if (input.readInt() != 1095582789) {
            throw new IOException("Wrong magic number");
        }
        ((Persistent)((Object)this.keyPortability)).bootstrap(input);
        ((Persistent)((Object)this.valuePortability)).bootstrap(input);
        int n = input.readInt();
        for (int i = 0; i < n; ++i) {
            this.chunks.add(new FileChunk(input));
        }
        if (this.hasRecoveryListeners()) {
            for (Long encoding : this.owner.encodingSet()) {
                ByteBuffer binaryKey = this.readBinaryKey(encoding);
                ByteBuffer binaryValue = this.readBinaryValue(encoding);
                int hash = this.readKeyHash(encoding);
                final ByteBuffer binaryKeyForDecode = binaryKey.duplicate();
                final ByteBuffer binaryValueForDecode = binaryValue.duplicate();
                final Thread caller = Thread.currentThread();
                this.fireRecovered(new Callable<K>(){

                    @Override
                    public K call() throws Exception {
                        if (caller == Thread.currentThread()) {
                            return FileBackedStorageEngine.this.keyPortability.decode(binaryKeyForDecode.duplicate());
                        }
                        throw new IllegalStateException();
                    }
                }, new Callable<V>(){

                    @Override
                    public V call() throws Exception {
                        if (caller == Thread.currentThread()) {
                            return FileBackedStorageEngine.this.valuePortability.decode(binaryValueForDecode.duplicate());
                        }
                        throw new IllegalStateException();
                    }
                }, binaryKey, binaryValue, hash, 0, encoding);
            }
        }
    }

    @Override
    protected void free(long address) {
        FileChunk chunk = this.findChunk(address);
        chunk.free(address - chunk.baseAddress());
    }

    @Override
    protected ByteBuffer readKeyBuffer(long address) {
        FileChunk chunk = this.findChunk(address);
        return chunk.readKeyBuffer(address - chunk.baseAddress());
    }

    @Override
    protected WriteContext getKeyWriteContext(long address) {
        FileChunk chunk = this.findChunk(address);
        return chunk.getKeyWriteContext(address - chunk.baseAddress());
    }

    @Override
    protected ByteBuffer readValueBuffer(long address) {
        FileChunk chunk = this.findChunk(address);
        return chunk.readValueBuffer(address - chunk.baseAddress());
    }

    @Override
    protected WriteContext getValueWriteContext(long address) {
        FileChunk chunk = this.findChunk(address);
        return chunk.getValueWriteContext(address - chunk.baseAddress());
    }

    @Override
    protected Long writeMappingBuffers(ByteBuffer keyBuffer, ByteBuffer valueBuffer, int hash) {
        FileChunk c;
        Long address;
        for (FileChunk c2 : this.chunks) {
            Long address2 = c2.writeMappingBuffers(keyBuffer, valueBuffer, hash);
            if (address2 == null) continue;
            return address2 + c2.baseAddress();
        }
        do {
            FileChunk last = this.chunks.get(this.chunks.size() - 1);
            long nextChunkSize = last.capacity() << 1;
            long nextChunkBaseAddress = last.baseAddress() + last.capacity();
            if (nextChunkSize < 0L) {
                return null;
            }
            try {
                c = new FileChunk(nextChunkSize, nextChunkBaseAddress);
            }
            catch (OutOfMemoryError e) {
                return null;
            }
            this.chunks.add(c);
        } while ((address = c.writeMappingBuffers(keyBuffer, valueBuffer, hash)) == null);
        return address + c.baseAddress();
    }

    @Override
    public long getAllocatedMemory() {
        long sum = 0L;
        for (FileChunk c : this.chunks) {
            sum += c.capacity();
        }
        return sum;
    }

    @Override
    public long getOccupiedMemory() {
        long sum = 0L;
        for (FileChunk c : this.chunks) {
            sum += c.occupied();
        }
        return sum;
    }

    @Override
    public long getVitalMemory() {
        return this.getAllocatedMemory();
    }

    @Override
    public long getDataSize() {
        long sum = 0L;
        for (FileChunk c : this.chunks) {
            sum += c.occupied();
        }
        return sum;
    }

    private FileChunk findChunk(long address) {
        int chunkIndex = 64 - Long.numberOfLeadingZeros(address + this.initialSize) - this.chunkIndexOffset;
        return this.chunks.get(chunkIndex);
    }

    private int readIntFromChannel(long position) throws IOException {
        ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
        int i = 0;
        while (lengthBuffer.hasRemaining()) {
            int read = this.readFromChannel(lengthBuffer, position + (long)i);
            if (read < 0) {
                throw new EOFException();
            }
            i += read;
        }
        return ((ByteBuffer)lengthBuffer.flip()).getInt();
    }

    private void writeIntToChannel(long position, int data) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(data).flip();
        this.writeBufferToChannel(position, buffer);
    }

    private void writeLongToChannel(long position, long data) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(data).flip();
        this.writeBufferToChannel(position, buffer);
    }

    private void writeBufferToChannel(long position, ByteBuffer buffer) throws IOException {
        int i = 0;
        while (buffer.hasRemaining()) {
            int written = this.writeChannel.write(buffer, position + (long)i);
            if (written < 0) {
                throw new EOFException();
            }
            i += written;
        }
    }

    private int readFromChannel(ByteBuffer buffer, long position) throws IOException {
        FileChannel current = this.readChannelReference.get();
        if (current == null) {
            throw new IOException("Storage engine is closed");
        }
        try {
            return this.readFromChannel(current, buffer, position);
        }
        catch (ClosedChannelException e) {
            boolean interrupted = Thread.interrupted();
            while (true) {
                current = this.readChannelReference.get();
                try {
                    int n = this.readFromChannel(current, buffer, position);
                    return n;
                }
                catch (ClosedChannelException f) {
                    interrupted |= Thread.interrupted();
                    FileChannel newChannel = this.source.getReadableChannel();
                    if (!this.readChannelReference.compareAndSet(current, newChannel)) {
                        newChannel.close();
                        continue;
                    }
                    LOGGER.info("Creating new read-channel for " + this.source.getFile().getName() + " as previous one was closed (likely due to interrupt)");
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private int readFromChannel(FileChannel channel, ByteBuffer buffer, long position) throws IOException {
        int ret = channel.read(buffer, position);
        if (ret < 0) {
            ret = channel.read(buffer, position);
        }
        return ret;
    }

    @Override
    public boolean shrink() {
        return false;
    }

    @Override
    public void bind(StorageEngine.Owner m) {
        if (this.owner != null) {
            throw new AssertionError();
        }
        this.owner = m;
    }

    @Override
    public int readKeyHash(long address) {
        FileChunk chunk = this.findChunk(address);
        return chunk.readPojoHash(address - chunk.baseAddress());
    }

    class FileWriteTask
    implements Runnable {
        private final FileChunk chunk;
        private final ByteBuffer keyBuffer;
        private final ByteBuffer valueBuffer;
        private final int pojoHash;
        private final long position;

        FileWriteTask(FileChunk chunk, long position, ByteBuffer keyBuffer, ByteBuffer valueBuffer, int pojoHash) {
            this.chunk = chunk;
            this.position = position;
            this.keyBuffer = keyBuffer;
            this.valueBuffer = valueBuffer;
            this.pojoHash = pojoHash;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (FileBackedStorageEngine.this.pendingWrites.get(this.position) == this) {
                try {
                    FileChunk fileChunk = this.chunk;
                    synchronized (fileChunk) {
                        if (this.chunk.isValid()) {
                            try {
                                try {
                                    this.write();
                                }
                                catch (IOException e) {
                                    LOGGER.warn("Received IOException '{}' while trying to write @ {} : trying again", (Object)e.getMessage(), (Object)this.position);
                                    this.write();
                                }
                            }
                            catch (ClosedChannelException e) {
                                LOGGER.debug("DiskWriteTask terminated due to closed channel - we must be shutting down", (Throwable)e);
                            }
                            catch (IOException e) {
                                LOGGER.warn("Received IOException '{}' during write @ {} : giving up", (Object)e.getMessage(), (Object)this.position);
                            }
                            catch (OutOfMemoryError e) {
                                LOGGER.error("Failed to allocate a direct buffer for a FileChannel write.  Consider increasing the -XX:MaxDirectMemorySize property to allow enough space for the FileChannel transfer buffers");
                                throw e;
                            }
                        }
                    }
                }
                finally {
                    FileBackedStorageEngine.this.pendingWrites.remove(this.position, this);
                }
            }
        }

        private void write() throws IOException {
            ByteBuffer key = this.getKeyBuffer();
            ByteBuffer value = this.getValueBuffer();
            int keyLength = key.remaining();
            int valueLength = value.remaining();
            FileBackedStorageEngine.this.writeIntToChannel(this.position + 0L, this.pojoHash);
            FileBackedStorageEngine.this.writeIntToChannel(this.position + 4L, keyLength);
            FileBackedStorageEngine.this.writeIntToChannel(this.position + 8L, valueLength);
            FileBackedStorageEngine.this.writeBufferToChannel(this.position + 12L, key);
            FileBackedStorageEngine.this.writeBufferToChannel(this.position + 12L + (long)keyLength, value);
            long size = FileBackedStorageEngine.this.writeChannel.size();
            long expected = this.position + (long)keyLength + (long)valueLength + 12L;
            if (size < expected) {
                throw new IOException("File size does not encompass last write [size:" + size + " end-of-write:" + expected);
            }
        }

        ByteBuffer getKeyBuffer() {
            return this.keyBuffer.duplicate();
        }

        ByteBuffer getValueBuffer() {
            return this.valueBuffer.duplicate();
        }
    }

    class FileChunk {
        private final AATreeFileAllocator allocator;
        private final long filePosition;
        private final long baseAddress;
        private boolean valid = true;

        FileChunk(long size, long baseAddress) {
            Long newOffset = FileBackedStorageEngine.this.source.allocateRegion(size);
            if (newOffset == null) {
                StringBuilder sb = new StringBuilder("Storage engine file data area allocation failed:\n");
                sb.append("Allocator: ").append(FileBackedStorageEngine.this.source);
                throw new OutOfMemoryError(sb.toString());
            }
            this.filePosition = newOffset;
            this.allocator = new AATreeFileAllocator(size);
            this.baseAddress = baseAddress;
        }

        FileChunk(ObjectInput input) throws IOException {
            if (input.readInt() != 1313753427) {
                throw new IOException("Wrong magic number");
            }
            this.filePosition = input.readLong();
            this.baseAddress = input.readLong();
            long size = input.readLong();
            FileBackedStorageEngine.this.source.claimRegion(this.filePosition, size);
            this.allocator = new AATreeFileAllocator(size, input);
        }

        ByteBuffer readKeyBuffer(long address) {
            try {
                long position = this.filePosition + address;
                FileWriteTask pending = (FileWriteTask)FileBackedStorageEngine.this.pendingWrites.get(position);
                if (pending == null) {
                    int keyLength = FileBackedStorageEngine.this.readIntFromChannel(position + 4L);
                    return this.readBuffer(position + 12L, keyLength);
                }
                return pending.getKeyBuffer();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (OutOfMemoryError e) {
                LOGGER.error("Failed to allocate direct buffer for FileChannel read.  Consider increasing the -XX:MaxDirectMemorySize property to allow enough space for the FileChannel transfer buffers");
                throw e;
            }
        }

        protected int readPojoHash(long address) {
            try {
                long position = this.filePosition + address;
                FileWriteTask pending = (FileWriteTask)FileBackedStorageEngine.this.pendingWrites.get(position);
                if (pending == null) {
                    return FileBackedStorageEngine.this.readIntFromChannel(position + 0L);
                }
                return pending.pojoHash;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (OutOfMemoryError e) {
                LOGGER.error("Failed to allocate direct buffer for FileChannel read.  Consider increasing the -XX:MaxDirectMemorySize property to allow enough space for the FileChannel transfer buffers");
                throw e;
            }
        }

        ByteBuffer readValueBuffer(long address) {
            try {
                long position = this.filePosition + address;
                FileWriteTask pending = (FileWriteTask)FileBackedStorageEngine.this.pendingWrites.get(position);
                if (pending == null) {
                    int keyLength = FileBackedStorageEngine.this.readIntFromChannel(position + 4L);
                    int valueLength = FileBackedStorageEngine.this.readIntFromChannel(position + 8L);
                    return this.readBuffer(position + (long)keyLength + 12L, valueLength);
                }
                return pending.getValueBuffer();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (OutOfMemoryError e) {
                LOGGER.error("Failed to allocate direct buffer for FileChannel read.  Consider increasing the -XX:MaxDirectMemorySize property to allow enough space for the FileChannel transfer buffers");
                throw e;
            }
        }

        ByteBuffer readBuffer(long position, int length) {
            try {
                ByteBuffer data = ByteBuffer.allocate(length);
                int i = 0;
                while (data.hasRemaining()) {
                    int read = FileBackedStorageEngine.this.readFromChannel(data, position + (long)i);
                    if (read < 0) {
                        throw new EOFException();
                    }
                    i += read;
                }
                return (ByteBuffer)data.rewind();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (OutOfMemoryError e) {
                LOGGER.error("Failed to allocate direct buffer for FileChannel read.  Consider increasing the -XX:MaxDirectMemorySize property to allow enough space for the FileChannel transfer buffers");
                throw e;
            }
        }

        Long writeMappingBuffers(ByteBuffer keyBuffer, ByteBuffer valueBuffer, int pojoHash) {
            int valueLength;
            int keyLength = keyBuffer.remaining();
            long address = this.allocator.allocate(keyLength + (valueLength = valueBuffer.remaining()) + 12);
            if (address >= 0L) {
                long position = this.filePosition + address;
                FileWriteTask task = new FileWriteTask(this, position, keyBuffer, valueBuffer, pojoHash);
                FileBackedStorageEngine.this.pendingWrites.put(position, task);
                FileBackedStorageEngine.this.writeExecutor.execute(task);
                return address;
            }
            return null;
        }

        WriteContext getKeyWriteContext(long address) {
            try {
                long position = this.filePosition + address;
                FileWriteTask pending = (FileWriteTask)FileBackedStorageEngine.this.pendingWrites.get(position);
                if (pending == null) {
                    int keyLength = FileBackedStorageEngine.this.readIntFromChannel(position + 4L);
                    return this.getDiskWriteContext(position + 12L, keyLength);
                }
                if (FileBackedStorageEngine.this.pendingWrites.get(position) != pending) {
                    return this.getKeyWriteContext(address);
                }
                return this.getQueuedWriteContext(pending, pending.getKeyBuffer());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        WriteContext getValueWriteContext(long address) {
            try {
                long position = this.filePosition + address;
                FileWriteTask pending = (FileWriteTask)FileBackedStorageEngine.this.pendingWrites.get(position);
                if (pending == null) {
                    int keyLength = FileBackedStorageEngine.this.readIntFromChannel(position + 4L);
                    int valueLength = FileBackedStorageEngine.this.readIntFromChannel(position + 8L);
                    return this.getDiskWriteContext(position + (long)keyLength + 12L, valueLength);
                }
                if (FileBackedStorageEngine.this.pendingWrites.get(position) != pending) {
                    return this.getValueWriteContext(address);
                }
                return this.getQueuedWriteContext(pending, pending.getValueBuffer());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private WriteContext getDiskWriteContext(final long address, final int max) {
            return new WriteContext(){

                @Override
                public void setLong(int offset, long value) {
                    if (offset < 0 || offset >= max) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        FileBackedStorageEngine.this.writeLongToChannel(address + (long)offset, value);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void flush() {
                }
            };
        }

        private WriteContext getQueuedWriteContext(final FileWriteTask current, final ByteBuffer queuedBuffer) {
            return new WriteContext(){

                @Override
                public void setLong(int offset, long value) {
                    queuedBuffer.putLong(offset, value);
                }

                @Override
                public void flush() {
                    FileWriteTask flush = new FileWriteTask(current.chunk, current.position, current.keyBuffer, current.valueBuffer, current.pojoHash);
                    FileBackedStorageEngine.this.pendingWrites.put(flush.position, flush);
                    FileBackedStorageEngine.this.writeExecutor.execute(flush);
                }
            };
        }

        void free(long address) {
            try {
                int valueLength;
                int keyLength;
                long position = this.filePosition + address;
                FileWriteTask pending = (FileWriteTask)FileBackedStorageEngine.this.pendingWrites.remove(position);
                if (pending == null) {
                    keyLength = FileBackedStorageEngine.this.readIntFromChannel(position + 4L);
                    valueLength = FileBackedStorageEngine.this.readIntFromChannel(position + 8L);
                } else {
                    keyLength = pending.getKeyBuffer().remaining();
                    valueLength = pending.getValueBuffer().remaining();
                }
                this.allocator.free(address, keyLength + valueLength + 12);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        synchronized void clear() {
            FileBackedStorageEngine.this.source.freeRegion(this.filePosition);
            this.valid = false;
        }

        long capacity() {
            return this.allocator.capacity();
        }

        long occupied() {
            return this.allocator.occupied();
        }

        long baseAddress() {
            return this.baseAddress;
        }

        void persist(ObjectOutput output) throws IOException {
            output.writeInt(1313753427);
            output.writeLong(this.filePosition);
            output.writeLong(this.baseAddress);
            output.writeLong(this.allocator.capacity());
            this.allocator.persist(output);
        }

        synchronized boolean isValid() {
            return this.valid;
        }
    }
}

