/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.extended;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.archive.Timestamped;
import org.terracotta.statistics.extended.SampledStatistic;
import org.terracotta.statistics.extended.StatisticHistory;

abstract class AbstractSampledStatistic<T extends Number>
implements SampledStatistic<T> {
    private final ValueStatistic<T> source;
    private final StatisticHistory<T> history;

    AbstractSampledStatistic(ValueStatistic<T> source, ScheduledExecutorService executor, int historySize, long historyPeriod, TimeUnit historyTimeUnit) {
        this.source = source;
        this.history = new StatisticHistory<T>(source, executor, historySize, historyPeriod, historyTimeUnit);
    }

    @Override
    public T value() {
        return this.source.value();
    }

    @Override
    public List<Timestamped<T>> history() {
        return this.history.history();
    }

    final void startSampling() {
        this.history.startSampling();
    }

    final void stopSampling() {
        this.history.stopSampling();
    }

    final void setHistory(int historySize, long historyPeriod, TimeUnit historyTimeUnit) {
        this.history.adjust(historySize, historyPeriod, historyTimeUnit);
    }
}

