/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.terracotta.statistics.StatisticType;
import org.terracotta.statistics.ValueStatistic;

public class MemoizingValueStatistic<T extends Serializable>
implements ValueStatistic<T> {
    private final long delayNs;
    private final AtomicReference<T> memoized = new AtomicReference();
    private final AtomicLong expiration = new AtomicLong();
    private final ValueStatistic<T> delegate;

    public MemoizingValueStatistic(long delay, TimeUnit unit, ValueStatistic<T> delegate) {
        this.delayNs = TimeUnit.NANOSECONDS.convert(delay, unit);
        this.delegate = delegate;
    }

    @Override
    public StatisticType type() {
        return this.delegate.type();
    }

    @Override
    public T value() {
        long exp;
        long now = System.nanoTime();
        if (now >= (exp = this.expiration.get()) && this.expiration.compareAndSet(exp, now + this.delayNs)) {
            this.memoized.set(this.delegate.value());
        }
        return (T)((Serializable)this.memoized.get());
    }
}

