/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Supplier;
import org.terracotta.statistics.StatisticType;
import org.terracotta.statistics.Table;
import org.terracotta.statistics.ValueStatistic;

public class SuppliedValueStatistic<T extends Serializable>
implements ValueStatistic<T> {
    private final Supplier<T> supplier;
    private final StatisticType type;

    public static <T extends Serializable> ValueStatistic<T> supply(StatisticType type, Supplier<T> supplier) {
        return new SuppliedValueStatistic<T>(type, supplier);
    }

    public static <T extends Number> ValueStatistic<T> gauge(Supplier<T> supplier) {
        return SuppliedValueStatistic.supply(StatisticType.GAUGE, supplier);
    }

    public static <T extends Number> ValueStatistic<T> counter(Supplier<T> supplier) {
        return SuppliedValueStatistic.supply(StatisticType.COUNTER, supplier);
    }

    public static <T extends Number> ValueStatistic<T> rate(Supplier<T> supplier) {
        return SuppliedValueStatistic.supply(StatisticType.RATE, supplier);
    }

    public static <T extends Number> ValueStatistic<T> ratio(Supplier<T> supplier) {
        return SuppliedValueStatistic.supply(StatisticType.RATIO, supplier);
    }

    public static <T extends Table> ValueStatistic<T> table(Supplier<T> supplier) {
        return SuppliedValueStatistic.supply(StatisticType.TABLE, supplier);
    }

    private SuppliedValueStatistic(StatisticType type, Supplier<T> supplier) {
        this.type = Objects.requireNonNull(type);
        this.supplier = Objects.requireNonNull(supplier);
    }

    @Override
    public T value() {
        return (T)((Serializable)this.supplier.get());
    }

    @Override
    public StatisticType type() {
        return this.type;
    }
}

