/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test.net;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.utilities.test.net.EphemeralPorts;
import org.terracotta.utilities.test.net.NetStat;
import org.terracotta.utilities.test.net.SystemLevelLocker;

public class PortManager {
    public static final String DISABLE_PORT_RELEASE_CHECK_PROPERTY = "org.terracotta.disablePortReleaseCheck";
    private static final Logger LOGGER = LoggerFactory.getLogger(PortManager.class);
    private static final PortManager INSTANCE = new PortManager();
    private static final int MAXIMUM_PORT_NUMBER = 65535;
    private static final int MINIMUM_ASSIGNABLE_PORT_COUNT = 1024;
    private static final InetAddress LOCALHOST;
    private final Random rnd = new SecureRandom();
    private final BitSet restrictedPorts = new BitSet();
    private final BitSet portMap = new BitSet(65536);
    private final Map<Integer, AllocatedPort> allocatedPorts = new HashMap<Integer, AllocatedPort>();
    private final ReferenceQueue<PortRef> dereferencedPorts = new ReferenceQueue();
    private final SystemLevelLocker systemLevelLocker = new SystemLevelLocker();
    private final int assignablePortCount;

    public static PortManager getInstance() {
        PortManager.emitInstanceNotification("Using");
        return INSTANCE;
    }

    private PortManager() {
        this.portMap.set(0, 1025);
        EphemeralPorts.Range range = EphemeralPorts.getRange();
        this.portMap.set(range.getLower(), range.getUpper() + 1);
        this.restrictedPorts.or(this.portMap);
        this.assignablePortCount = 65536 - this.portMap.cardinality();
        if (this.assignablePortCount < 1024) {
            LOGGER.warn("\n*****************************************************************************************\nOnly {} ports available for assignment (ephemeral range=[{}]); operations may be unstable\n*****************************************************************************************", (Object)this.assignablePortCount, (Object)range);
        }
    }

    public boolean isReservablePort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Port " + port + " is not a valid port number");
        }
        return !this.restrictedPorts.get(port);
    }

    public synchronized Optional<PortRef> getPortRef(int port) {
        if (!this.isReservablePort(port)) {
            throw new IllegalArgumentException("Port " + port + " is not reservable");
        }
        this.cleanReleasedPorts();
        return Optional.ofNullable(this.allocatedPorts.get(port)).map(Reference::get).filter(portRef -> !portRef.isClosed());
    }

    public synchronized Optional<PortRef> reserve(int port) {
        if (!this.isReservablePort(port)) {
            throw new IllegalArgumentException("Port " + port + " is not reservable");
        }
        this.cleanReleasedPorts();
        if (this.portMap.get(port)) {
            LOGGER.trace("Port {} is already reserved", (Object)port);
            return Optional.empty();
        }
        return Optional.ofNullable(this.reserveInternal(port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PortRef> reservePorts(int portCount) {
        if (portCount <= 0 || portCount > this.assignablePortCount) {
            throw new IllegalArgumentException("portCount " + portCount + " not valid");
        }
        ArrayList<PortRef> ports = new ArrayList<PortRef>(portCount);
        try {
            for (int i = 0; i < portCount; ++i) {
                ports.add(this.reservePort());
            }
            List<PortRef> list = Collections.unmodifiableList(ports);
            return list;
        }
        finally {
            if (ports.size() < portCount) {
                ports.forEach(r -> {
                    try {
                        r.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        }
    }

    public synchronized PortRef reservePort() {
        int startingPoint;
        this.cleanReleasedPorts();
        while (this.restrictedPorts.get(startingPoint = this.rnd.nextInt(65536))) {
        }
        LOGGER.trace("Starting port reservation search at {}", (Object)startingPoint);
        BitSearch bitSearch = this.rnd.nextBoolean() ? BitSearch.ASCENDING : BitSearch.DESCENDING;
        boolean switched = false;
        int candidatePort = startingPoint;
        while (true) {
            if ((candidatePort = bitSearch.nextFree(this.portMap).applyAsInt(candidatePort)) == -1 && !switched) {
                bitSearch = bitSearch.reverse();
                switched = true;
                candidatePort = startingPoint;
                candidatePort = bitSearch.nextFree(this.portMap).applyAsInt(candidatePort);
            }
            if (candidatePort == -1) {
                throw new IllegalStateException("No port available for reservation");
            }
            PortRef portRef = this.reserveInternal(candidatePort);
            if (portRef != null) {
                return portRef;
            }
            candidatePort = bitSearch.successor(candidatePort);
        }
    }

    private void cleanReleasedPorts() {
        Reference<PortRef> reference;
        while ((reference = this.dereferencedPorts.poll()) != null) {
            if (reference instanceof AllocatedPort) {
                AllocatedPort allocatedPort = (AllocatedPort)reference;
                LOGGER.info("Port {} dereferenced; releasing reservation", (Object)allocatedPort.port);
                allocatedPort.release();
                continue;
            }
            LOGGER.warn("Unexpected Reference observed: {}", reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PortRef reserveInternal(int candidatePort) {
        LOGGER.trace("Vetting port {}", (Object)candidatePort);
        PortRef portRef = new PortRef(candidatePort);
        boolean releaseRequired = true;
        try {
            boolean systemLevelLockHeld;
            this.portMap.set(candidatePort);
            this.allocatedPorts.put(portRef.port, new AllocatedPort(portRef, this.dereferencedPorts));
            portRef.onClose(this::release);
            ServerSocket ignored = new ServerSocket(candidatePort);
            Object object = null;
            try {
                systemLevelLockHeld = this.systemLevelLocker.lock(portRef);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ignored != null) {
                    if (object != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
            if (systemLevelLockHeld) {
                if (this.refusesConnect(candidatePort)) {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    LOGGER.info("Port {} reserved (JVM-level) by {}@{} ({}@{})", new Object[]{candidatePort, this.getClass().getSimpleName(), Integer.toHexString(System.identityHashCode(this)), classLoader.getClass().getSimpleName(), Integer.toHexString(System.identityHashCode(classLoader))});
                    releaseRequired = false;
                    portRef.onClose(this::diagnosticReleaseCheck);
                    object = portRef;
                    return object;
                }
                LOGGER.trace("Port {} failed refusesConnect", (Object)candidatePort);
            } else {
                LOGGER.trace("Port {} failed to obtain system-level lock", (Object)candidatePort);
            }
        }
        catch (IllegalStateException e) {
            LOGGER.error("Failed to reserve port {}; abandoning reservation", (Object)candidatePort, (Object)e);
            throw e;
        }
        catch (BindException e) {
        }
        catch (Exception e) {
            LOGGER.warn("Failed to reserve port {}; checking next port", (Object)candidatePort, (Object)e);
        }
        finally {
            if (releaseRequired) {
                try {
                    portRef.close();
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    private synchronized void release(int port, Set<PortRef.CloseOption> options) {
        this.portMap.clear(port);
        this.allocatedPorts.remove(port);
        LOGGER.info("Port {} released (JVM-level)", (Object)port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refusesConnect(int port) {
        boolean isFree;
        InetSocketAddress endpoint = LOCALHOST == null ? new InetSocketAddress("localhost", port) : new InetSocketAddress(LOCALHOST, port);
        Socket sock = new Socket();
        try {
            sock.connect(endpoint, 50);
            isFree = false;
        }
        catch (ConnectException | SocketTimeoutException e) {
            isFree = true;
        }
        catch (Exception e) {
            LOGGER.debug("[refusesConnect] Client connection to port {} failed for unexpected reason", (Object)endpoint, (Object)e);
            isFree = false;
        }
        finally {
            try {
                sock.close();
            }
            catch (IOException e) {}
        }
        return isFree;
    }

    private void diagnosticReleaseCheck(int port, Set<PortRef.CloseOption> options) {
        if (options.contains((Object)PortRef.CloseOption.NO_RELEASE_CHECK)) {
            return;
        }
        if (Boolean.getBoolean(DISABLE_PORT_RELEASE_CHECK_PROPERTY)) {
            LOGGER.info("Port {} release check for disabled by {}=true", (Object)port, (Object)DISABLE_PORT_RELEASE_CHECK_PROPERTY);
            return;
        }
        boolean disableCheck = false;
        try {
            List<NetStat.BusyPort> portInfo = NetStat.info();
            if (portInfo.isEmpty()) {
                LOGGER.warn("No busy port information obtained to verify release of port {}", (Object)port);
                disableCheck = true;
            } else {
                List collisions = portInfo.stream().filter(p -> p.localEndpoint().getPort() == port).collect(Collectors.toList());
                if (!collisions.isEmpty()) {
                    LOGGER.error("Port {} being released to PortManager is in use by the following:\n{}", (Object)port, (Object)collisions.stream().map(NetStat.BusyPort::toString).map(s -> "    " + s).collect(Collectors.joining("\n")));
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.warn("Unable to obtain busy port information to verify release of port {}", (Object)port, (Object)e);
            disableCheck = true;
        }
        if (disableCheck) {
            try {
                AccessController.doPrivileged(() -> System.setProperty(DISABLE_PORT_RELEASE_CHECK_PROPERTY, "true"));
                LOGGER.warn("Further use of diagnostic busy port check in this JVM disabled");
            }
            catch (SecurityException exception) {
                LOGGER.debug("Failed to disable further use of diagnostic busy port check", (Throwable)exception);
            }
        }
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"})
    private static void emitInstanceNotification(String use) {
        try {
            ClassLoader classLoader = INSTANCE.getClass().getClassLoader();
            LOGGER.info("PID {}: {} PortManager instance: {}@{} ({}@{})", new Object[]{Pid.PID.orElse(-1L), use, INSTANCE.getClass().getName(), Integer.toHexString(System.identityHashCode(INSTANCE)), classLoader.getClass().getName(), Integer.toHexString(System.identityHashCode(classLoader))});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static <T, U> BiConsumer<T, U> combine(BiConsumer<T, U> a, BiConsumer<T, U> b) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        return (t, u) -> {
            try {
                b.accept(t, u);
            }
            finally {
                a.accept(t, u);
            }
        };
    }

    static {
        PortManager.emitInstanceNotification("Instantiated");
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getByName("localhost");
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to obtain an InetAddress for localhost via InetAddress.getByName(\"localhost\")", (Throwable)e);
        }
        LOCALHOST = localHost;
    }

    private static enum BitSearch {
        ASCENDING{

            @Override
            IntUnaryOperator nextFree(BitSet bitSet) {
                return fromIndex -> {
                    int nextClearBit = bitSet.nextClearBit(fromIndex);
                    return nextClearBit > 65535 ? -1 : nextClearBit;
                };
            }

            @Override
            int successor(int value) {
                return value + 1;
            }

            @Override
            BitSearch reverse() {
                return DESCENDING;
            }
        }
        ,
        DESCENDING{

            @Override
            IntUnaryOperator nextFree(BitSet bitSet) {
                return bitSet::previousClearBit;
            }

            @Override
            int successor(int value) {
                return value - 1;
            }

            @Override
            BitSearch reverse() {
                return ASCENDING;
            }
        };


        abstract IntUnaryOperator nextFree(BitSet var1);

        abstract int successor(int var1);

        abstract BitSearch reverse();
    }

    public static class PortRef
    implements AutoCloseable {
        private final int port;
        private final AtomicReference<BiConsumer<Integer, Set<CloseOption>>> closers = new AtomicReference<BiConsumer<Integer, Set>>((port, options) -> {});
        private final AtomicBoolean closed = new AtomicBoolean();

        private PortRef(int port2) {
            this.port = port2;
        }

        void onClose(BiConsumer<Integer, Set<CloseOption>> action) {
            this.closers.accumulateAndGet(action, (x$0, x$1) -> PortManager.combine(x$0, x$1));
        }

        private AtomicReference<BiConsumer<Integer, Set<CloseOption>>> closers() {
            return this.closers;
        }

        public int port() {
            return this.port;
        }

        public boolean isClosed() {
            return this.closed.get();
        }

        @Override
        public void close() {
            this.close(EnumSet.noneOf(CloseOption.class));
        }

        public void close(Set<CloseOption> options) {
            Objects.requireNonNull(options, "options");
            if (this.closed.compareAndSet(false, true)) {
                Optional.ofNullable(this.closers.getAndSet(null)).ifPresent(action -> action.accept(this.port, options));
            }
        }

        public static enum CloseOption {
            NO_RELEASE_CHECK;

        }
    }

    private static class AllocatedPort
    extends WeakReference<PortRef> {
        private final int port;
        private final AtomicReference<BiConsumer<Integer, Set<PortRef.CloseOption>>> closer;

        private AllocatedPort(PortRef referent, ReferenceQueue<? super PortRef> q) {
            super(referent, q);
            this.port = referent.port();
            this.closer = referent.closers();
        }

        private void release() {
            try {
                Optional.ofNullable(this.closer.get()).ifPresent(action -> action.accept(this.port, EnumSet.noneOf(PortRef.CloseOption.class)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final class Pid {
        private static final OptionalLong PID = Pid.getPidInternal();

        private Pid() {
        }

        private static OptionalLong getPidInternal() {
            Long pid = null;
            try {
                Class<?> processHandleClass = Class.forName("java.lang.ProcessHandle");
                Method currentMethod = processHandleClass.getMethod("current", new Class[0]);
                Method getPidMethod = processHandleClass.getMethod("pid", new Class[0]);
                pid = (Long)getPidMethod.invoke(currentMethod.invoke(null, new Object[0]), new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                String jvmProcessName = ManagementFactory.getRuntimeMXBean().getName();
                try {
                    pid = Long.parseLong(jvmProcessName.substring(0, jvmProcessName.indexOf(64)));
                }
                catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                    // empty catch block
                }
            }
            return pid == null ? OptionalLong.empty() : OptionalLong.of(pid);
        }
    }
}

