/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test.rules;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRetryer<T, R>
implements TestRule,
Supplier<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestRetryer.class);
    private final RetryMode retryMode;
    private final Function<T, R> mapper;
    private final Set<OutputIs> outputIs;
    private final Supplier<Stream<? extends T>> inputs;
    private final AtomicReference<T> inputRef = new AtomicReference();
    private final AtomicReference<R> outputRef = new AtomicReference();
    private volatile boolean classRuleApplied = false;
    private volatile boolean ruleApplied = false;
    private volatile boolean terminalAttempt = false;
    private volatile Map<Description, Object> attemptResults = Collections.emptyMap();
    private final Map<Description, Object> accumulatedResults = new ConcurrentHashMap<Description, Object>();

    @SafeVarargs
    public static <T> TestRetryer<T, T> tryValues(T ... values) {
        return TestRetryer.tryValues(Arrays.asList(values));
    }

    public static <T> TestRetryer<T, T> tryValues(Collection<? extends T> values) {
        Objects.requireNonNull(values).forEach(Objects::requireNonNull);
        return new TestRetryer(values::stream, Function.identity(), EnumSet.noneOf(OutputIs.class), RetryMode.FAILED);
    }

    private TestRetryer(Supplier<Stream<? extends T>> values, Function<T, R> mapper, Set<OutputIs> outputIs, RetryMode retryMode) {
        this.inputs = () -> ((Stream)values.get()).map(Objects::requireNonNull);
        this.mapper = Objects.requireNonNull(mapper);
        this.outputIs = Objects.requireNonNull(outputIs);
        this.retryMode = retryMode;
    }

    public <O> TestRetryer<T, O> map(Function<? super R, ? extends O> mapper) {
        return new TestRetryer<T, O>(this.inputs, this.mapper.andThen(mapper), this.outputIs, this.retryMode);
    }

    public TestRetryer<T, R> retry(RetryMode retryMode) {
        return new TestRetryer<T, R>(this.inputs, this.mapper, this.outputIs, retryMode);
    }

    public TestRetryer<T, R> outputIs(OutputIs a, OutputIs ... and) {
        EnumSet<OutputIs> newOut = EnumSet.copyOf(this.outputIs);
        newOut.add(a);
        newOut.addAll(Arrays.asList(and));
        return new TestRetryer<T, R>(this.inputs, this.mapper, newOut, this.retryMode);
    }

    public Statement apply(Statement base, Description description) {
        if (description.isTest()) {
            return this.applyRule(base, description);
        }
        return this.applyClassRule(base, description);
    }

    private Statement applyClassRule(final Statement base, final Description description) {
        this.classRuleApplied = true;
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                Iterator iterator = ((Stream)TestRetryer.this.inputs.get()).iterator();
                while (iterator.hasNext()) {
                    Object input = iterator.next();
                    TestRetryer.this.terminalAttempt = !iterator.hasNext();
                    TestRetryer.this.attemptResults = new ConcurrentHashMap();
                    LOGGER.debug("{}: attempting with input value {}", (Object)description, input);
                    Assert.assertTrue((boolean)TestRetryer.this.inputRef.compareAndSet(null, input));
                    try {
                        Object output = TestRetryer.this.mapper.apply(input);
                        LOGGER.debug("{}: input {} maps to {}", new Object[]{description, input, output});
                        Assert.assertTrue((boolean)TestRetryer.this.outputRef.compareAndSet(null, output));
                        try {
                            if (output instanceof TestRule && TestRetryer.this.outputIs.contains((Object)OutputIs.CLASS_RULE)) {
                                ((TestRule)output).apply(base, description).evaluate();
                            } else {
                                base.evaluate();
                            }
                        }
                        catch (Throwable t) {
                            throw TestRetryer.this.handleTestFailure(description, t);
                        }
                        finally {
                            Assert.assertTrue((boolean)TestRetryer.this.outputRef.compareAndSet(output, null));
                        }
                    }
                    finally {
                        Assert.assertTrue((boolean)TestRetryer.this.inputRef.compareAndSet(input, null));
                    }
                    if (!TestRetryer.this.ruleApplied) {
                        throw new AssertionError((Object)(TestRetryer.this.getClass().getSimpleName() + " must be annotated with both @ClassRule and @Rule"));
                    }
                    if (TestRetryer.this.attemptResults.values().stream().noneMatch(Throwable.class::isInstance)) {
                        LOGGER.debug("{}: successful with input value {}", (Object)description, input);
                        return;
                    }
                    LOGGER.info("{}: failed with input value {}\n{}", new Object[]{description, input, TestRetryer.this.attemptResults.entrySet().stream().map(e -> {
                        String testMethodHeader = ((Description)e.getKey()).getMethodName() + ": ";
                        return TestRetryer.indent(testMethodHeader + e.getValue().toString(), new Integer[]{4, 4 + testMethodHeader.length()});
                    }).collect(Collectors.joining("\n"))});
                }
            }
        };
    }

    private Statement applyRule(Statement base, final Description description) {
        this.ruleApplied = true;
        if (!this.classRuleApplied) {
            throw new AssertionError((Object)(this.getClass().getSimpleName() + " must be annotated with both @ClassRule and @Rule"));
        }
        R output = this.get();
        final Statement target = output instanceof TestRule && this.outputIs.contains((Object)OutputIs.RULE) ? ((TestRule)output).apply(base, description) : base;
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    TestRetryer.this.retryMode.evaluate(TestRetryer.this.accumulatedResults.get(description), target);
                    TestRetryer.this.handleTestPass(description);
                }
                catch (AssumptionViolatedException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw TestRetryer.this.handleTestFailure(description, t);
                }
            }
        };
    }

    private void handleTestPass(Description description) {
        this.attemptResults.merge(description, "PASSED", TestRetryer::mergeResults);
        this.accumulatedResults.merge(description, "PASSED", TestRetryer::mergeResults);
    }

    private Throwable handleTestFailure(Description description, Throwable t) {
        Throwable failure = (Throwable)this.attemptResults.merge(description, t, TestRetryer::mergeResults);
        Throwable merged = (Throwable)this.accumulatedResults.merge(description, t, TestRetryer::mergeResults);
        if (this.isTerminalAttempt()) {
            return merged;
        }
        return new AssumptionViolatedException("Failure for input parameter: " + this.input(), failure);
    }

    static Object mergeResults(Object previous, Object current) {
        if (current instanceof Throwable && previous instanceof Throwable) {
            ((Throwable)current).addSuppressed((Throwable)previous);
        }
        return current;
    }

    public T input() {
        return Objects.requireNonNull(this.inputRef.get());
    }

    @Override
    public R get() {
        return Objects.requireNonNull(this.outputRef.get());
    }

    private boolean isTerminalAttempt() {
        return this.terminalAttempt;
    }

    private static CharSequence indent(String string, Integer ... indent) {
        char[] chars = new char[Collections.max(Arrays.asList(indent)).intValue()];
        Arrays.fill(chars, ' ');
        String indentStrings = new String(chars);
        String[] strings = string.split("(?m)^");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i < indent.length) {
                sb.append(indentStrings, 0, (int)indent[i]);
            } else {
                sb.append(indentStrings, 0, (int)indent[indent.length - 1]);
            }
            sb.append(strings[i]);
        }
        return sb;
    }

    public static enum RetryMode {
        ALL{

            @Override
            public void evaluate(Object result, Statement target) throws Throwable {
                target.evaluate();
            }
        }
        ,
        FAILED{

            @Override
            public void evaluate(Object result, Statement target) throws Throwable {
                if (result != null && !(result instanceof Throwable)) {
                    throw new AssumptionViolatedException("Test already passed");
                }
                target.evaluate();
            }
        };


        public abstract void evaluate(Object var1, Statement var2) throws Throwable;
    }

    public static enum OutputIs {
        RULE,
        CLASS_RULE;

    }
}

