/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.terracotta.utilities.test.Diagnostics;

public final class WaitForAssert {
    private WaitForAssert() {
    }

    public static <T> EventualAssertion assertThatEventually(Supplier<T> value, Matcher<? super T> matcher) {
        return new EventualAssertion().and(value, matcher);
    }

    public static void assertThatCleanly(Callable<?> task, Duration timeout) throws TimeoutException {
        AtomicReference failure = new AtomicReference();
        try {
            WaitForAssert.waitOrTimeout(() -> {
                try {
                    task.call();
                    return true;
                }
                catch (Throwable t) {
                    failure.set(t);
                    return false;
                }
            }, timeout);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        catch (TimeoutException e) {
            e.addSuppressed((Throwable)failure.get());
            throw e;
        }
    }

    private static void waitOrTimeout(BooleanSupplier condition, Duration timeout) throws TimeoutException, InterruptedException {
        Instant threshold = Instant.now().plus(timeout);
        Duration sleep = Duration.ofMillis(50L);
        do {
            if (condition.getAsBoolean()) {
                return;
            }
            Thread.sleep(sleep.toMillis());
            sleep = sleep.multipliedBy(2L);
        } while (Instant.now().isBefore(threshold));
        if (condition.getAsBoolean()) {
            return;
        }
        throw new TimeoutException();
    }

    public static final class EventualAssertion {
        private final Collection<Runnable> assertions = new ArrayList<Runnable>();
        private Consumer<Throwable> action = null;

        public <T> EventualAssertion and(Supplier<T> value, Matcher<? super T> matcher) {
            this.assertions.add(() -> MatcherAssert.assertThat(value.get(), (Matcher)matcher));
            return this;
        }

        public EventualAssertion onFailure(Consumer<Throwable> action) {
            if (this.action == null) {
                this.action = action;
            } else {
                Consumer<Throwable> first = this.action;
                this.action = t -> {
                    try {
                        first.accept((Throwable)t);
                    }
                    catch (Throwable t1) {
                        try {
                            action.accept((Throwable)t);
                        }
                        catch (Throwable t2) {
                            try {
                                t1.addSuppressed(t2);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        throw t1;
                    }
                    action.accept((Throwable)t);
                };
            }
            return this;
        }

        public EventualAssertion threadDumpOnTimeout() {
            return this.onFailure(t -> Diagnostics.threadDump());
        }

        public void within(Duration timeout) throws TimeoutException {
            try {
                WaitForAssert.assertThatCleanly(() -> {
                    this.assertions.forEach(Runnable::run);
                    return null;
                }, timeout);
            }
            catch (TimeoutException t) {
                if (this.action != null) {
                    try {
                        this.action.accept(t.getSuppressed()[0]);
                    }
                    catch (Throwable t1) {
                        try {
                            t.addSuppressed(t1);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                throw t;
            }
        }
    }
}

