/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test.matchers;

import java.util.Arrays;
import java.util.stream.StreamSupport;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsEmptyIterable;

public class SequenceMatcher<T>
extends TypeSafeMatcher<Iterable<? extends T>> {
    Matcher<Iterable<? extends T>> headMatcher;
    Matcher<Iterable<? extends T>> tailMatcher;

    public SequenceMatcher(Matcher<Iterable<? extends T>> head, Matcher<Iterable<? extends T>> tail) {
        this.headMatcher = head;
        this.tailMatcher = tail;
    }

    protected boolean matchesSafely(Iterable<? extends T> item) {
        int i = 0;
        Iterable<? extends T>[] iterables;
        while (!this.headMatcher.matches((iterables = SequenceMatcher.splitIterable(item, i))[0]) || !this.tailMatcher.matches(iterables[1])) {
            if (!iterables[1].iterator().hasNext()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendDescriptionOf(this.headMatcher).appendText(", followed-by ").appendDescriptionOf(this.tailMatcher);
    }

    @SafeVarargs
    public static <T> Matcher<Iterable<? extends T>> containsSequencesInOrder(Matcher<Iterable<? extends T>> ... sequences) {
        if (sequences.length == 0) {
            return IsEmptyIterable.emptyIterable();
        }
        if (sequences.length == 1) {
            return sequences[0];
        }
        return new SequenceMatcher<T>(sequences[0], SequenceMatcher.containsSequencesInOrder(Arrays.copyOfRange(sequences, 1, sequences.length)));
    }

    private static <T> Iterable<T>[] splitIterable(Iterable<T> iterable, int headLength) {
        Iterable it1 = () -> StreamSupport.stream(iterable.spliterator(), false).limit(headLength).iterator();
        Iterable it2 = () -> StreamSupport.stream(iterable.spliterator(), false).skip(headLength).iterator();
        return new Iterable[]{it1, it2};
    }
}

