/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test.matchers;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class ThrowsMatcher
extends TypeSafeDiagnosingMatcher<Task> {
    private final Matcher<? extends Throwable> matcher;

    public ThrowsMatcher(Matcher<? extends Throwable> matcher) {
        this.matcher = matcher;
    }

    protected boolean matchesSafely(Task task, Description mismatch) {
        try {
            task.run();
            mismatch.appendText("the task completed normally");
            return false;
        }
        catch (Throwable t) {
            if (this.matcher.matches((Object)t)) {
                return true;
            }
            this.matcher.describeMismatch((Object)t, mismatch.appendText("the thrown "));
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("a task that throws ").appendDescriptionOf(this.matcher);
    }

    public static Matcher<Task> threw(Matcher<? extends Throwable> matcher) {
        return new ThrowsMatcher(matcher);
    }

    @FunctionalInterface
    public static interface Task {
        public void run() throws Throwable;
    }
}

