/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.common.bind;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DataBindingSupport;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidatingUnmarshaler
extends DataBindingSupport {
    private static Log log = LogFactory.getLog(ValidatingUnmarshaler.class);
    private Unmarshaller unmarshaler;
    private Resolver resolver;
    private Handler handler;

    private ValidatingUnmarshaler() {
        super(null);
    }

    public ValidatingUnmarshaler(URL url, JAXBContext context, BindingValidationEventHandler validationEventHandler) throws JAXBException, SAXException {
        super(context);
        if (url == null) {
            throw new IllegalArgumentException("non-null argument expected, url");
        }
        this.unmarshaler = this.createUnmarshaler(url, context);
        this.unmarshaler.setEventHandler((ValidationEventHandler)validationEventHandler);
    }

    public ValidatingUnmarshaler(InputStream stream, JAXBContext context, BindingValidationEventHandler validationEventHandler) throws JAXBException, SAXException {
        super(context);
        if (stream == null) {
            throw new IllegalArgumentException("non-null argument expected, stream");
        }
        this.unmarshaler = this.createUnmarshaler(new InputStream[]{stream}, context, this.handler, this.resolver);
        this.unmarshaler.setEventHandler((ValidationEventHandler)validationEventHandler);
    }

    public ValidatingUnmarshaler(InputStream[] streams, JAXBContext context, BindingValidationEventHandler validationEventHandler) throws JAXBException, SAXException {
        super(context);
        if (streams == null) {
            throw new IllegalArgumentException("non-null argument expected, streams");
        }
        this.resolver = new Resolver();
        this.handler = new Handler();
        this.unmarshaler = this.createUnmarshaler(streams, context, this.handler, this.resolver);
        this.unmarshaler.setEventHandler((ValidationEventHandler)validationEventHandler);
    }

    public ValidatingUnmarshaler(URL url, JAXBContext context, Handler handler, Resolver resolver) throws JAXBException, SAXException {
        super(context);
        if (url == null) {
            throw new IllegalArgumentException("non-null argument expected, url");
        }
        this.resolver = resolver;
        this.handler = handler;
        this.unmarshaler = this.createUnmarshaler(url, context, this.handler, this.resolver);
    }

    public ValidatingUnmarshaler(InputStream stream, JAXBContext context, Handler handler, Resolver resolver) throws JAXBException, SAXException {
        super(context);
        if (stream == null) {
            throw new IllegalArgumentException("non-null argument expected, stream");
        }
        this.resolver = resolver;
        this.handler = handler;
        this.unmarshaler = this.createUnmarshaler(new InputStream[]{stream}, context, this.handler, this.resolver);
    }

    private Unmarshaller createUnmarshaler(URL url, JAXBContext context, Handler handler, Resolver resolver) throws JAXBException, SAXException {
        Unmarshaller u = context.createUnmarshaller();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schemaGrammar = schemaFactory.newSchema(url);
        u.setSchema(schemaGrammar);
        Validator schemaValidator = schemaGrammar.newValidator();
        schemaValidator.setResourceResolver(resolver);
        schemaValidator.setErrorHandler(handler);
        return u;
    }

    private Unmarshaller createUnmarshaler(URL url, JAXBContext context) throws JAXBException, SAXException {
        Unmarshaller u = context.createUnmarshaller();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schemaGrammar = schemaFactory.newSchema(url);
        u.setSchema(schemaGrammar);
        return u;
    }

    private Unmarshaller createUnmarshaler(InputStream[] streams, JAXBContext context, Handler handler, Resolver resolver) throws JAXBException, SAXException {
        Unmarshaller u = context.createUnmarshaller();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] sources = new StreamSource[streams.length];
        for (int i = 0; i < streams.length; ++i) {
            sources[i] = new StreamSource(streams[i]);
        }
        Schema schemaGrammar = schemaFactory.newSchema(sources);
        u.setSchema(schemaGrammar);
        Validator schemaValidator = schemaGrammar.newValidator();
        schemaValidator.setResourceResolver(resolver);
        schemaValidator.setErrorHandler(handler);
        return u;
    }

    public Object validate(String xml) throws JAXBException, UnmarshalException {
        return this.unmarshaler.unmarshal((Reader)new StringReader(xml));
    }

    public Object validate(InputStream xml) throws JAXBException, UnmarshalException {
        return this.unmarshaler.unmarshal(xml);
    }

    public Object validate(Reader reader) throws JAXBException, UnmarshalException {
        return this.unmarshaler.unmarshal(reader);
    }

    public Object validate(Source source) throws JAXBException, UnmarshalException {
        return this.unmarshaler.unmarshal(source);
    }

    public BindingValidationEventHandler getValidationEventHandler() throws JAXBException {
        return (BindingValidationEventHandler)this.unmarshaler.getEventHandler();
    }

    protected static class Resolver
    implements LSResourceResolver {
        protected Resolver() {
        }

        public LSInput resolveResource(String str, String str1, String str2, String str3, String str4) {
            log.info((Object)("Resolving : " + str + ":" + str1 + ":" + str2 + ":" + str3 + ":" + str4));
            return null;
        }
    }

    protected static class Handler
    extends DefaultHandler {
        protected Handler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            log.error((Object)sAXParseException.getMessage(), (Throwable)sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            log.error((Object)sAXParseException.getMessage(), (Throwable)sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            log.warn((Object)sAXParseException.getMessage(), (Throwable)sAXParseException);
        }
    }
}

