/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.common.sort;

import org.plasma.common.sort.Sorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickSort
extends Sorter {
    @Override
    public <T extends Comparable<? super T>> void sort(T[] a) {
        this.sort((Comparable[])a, 0, a.length - 1);
    }

    private <T extends Comparable<? super T>> void sort(T[] a, int s_low, int s_high) {
        int low = s_low;
        int high = s_high;
        if (low == high - 1) {
            if (a[low].compareTo(a[high]) > 0) {
                this.swap(a, low, high);
            }
        } else if (low < high) {
            T pivot = a[(low + high) / 2];
            a[(low + high) / 2] = a[high];
            a[high] = pivot;
            while (low < high) {
                while (a[low].compareTo(pivot) < 1 && low < high) {
                    ++low;
                }
                while (pivot.compareTo(a[high]) < 1 && low < high) {
                    --high;
                }
                if (low >= high) continue;
                this.swap(a, low, high);
            }
            a[s_high] = a[high];
            a[high] = pivot;
            this.sort((Comparable[])a, s_low, low - 1);
            this.sort((Comparable[])a, high + 1, s_high);
        }
    }
}

