/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.common;

public class Hash {
    private static final byte[] htable;
    private int intKey;
    private long longKey;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = 33;
        byArray[1] = 14;
        byArray[2] = -68;
        byArray[3] = -126;
        byArray[4] = 50;
        byArray[5] = 93;
        byArray[6] = 118;
        byArray[7] = -40;
        byArray[8] = 108;
        byArray[9] = -110;
        byArray[10] = 27;
        byArray[11] = -20;
        byArray[12] = 111;
        byArray[13] = -65;
        byArray[14] = -125;
        byArray[15] = 52;
        byArray[16] = -116;
        byArray[17] = -96;
        byArray[18] = -67;
        byArray[19] = -58;
        byArray[20] = -13;
        byArray[21] = 103;
        byArray[22] = -114;
        byArray[23] = -50;
        byArray[24] = 110;
        byArray[25] = -123;
        byArray[26] = -105;
        byArray[27] = 71;
        byArray[28] = 24;
        byArray[29] = -70;
        byArray[30] = 76;
        byArray[31] = 9;
        byArray[32] = -83;
        byArray[33] = -115;
        byArray[34] = 94;
        byArray[35] = -101;
        byArray[36] = -30;
        byArray[37] = 38;
        byArray[38] = -27;
        byArray[39] = 31;
        byArray[40] = 29;
        byArray[41] = 13;
        byArray[42] = 51;
        byArray[43] = -119;
        byArray[44] = -34;
        byArray[45] = 8;
        byArray[46] = -3;
        byArray[47] = 102;
        byArray[48] = 61;
        byArray[49] = 56;
        byArray[50] = 127;
        byArray[51] = 55;
        byArray[52] = 35;
        byArray[53] = 37;
        byArray[54] = -97;
        byArray[55] = -25;
        byArray[56] = 36;
        byArray[57] = -64;
        byArray[58] = -107;
        byArray[59] = 96;
        byArray[60] = 85;
        byArray[61] = -71;
        byArray[62] = 78;
        byArray[63] = -79;
        byArray[64] = -118;
        byArray[65] = 63;
        byArray[66] = -47;
        byArray[67] = -100;
        byArray[68] = -102;
        byArray[69] = -18;
        byArray[70] = 11;
        byArray[71] = -81;
        byArray[72] = -88;
        byArray[73] = -95;
        byArray[74] = 7;
        byArray[75] = -66;
        byArray[76] = -17;
        byArray[77] = 82;
        byArray[78] = -35;
        byArray[79] = -122;
        byArray[80] = -113;
        byArray[81] = 46;
        byArray[82] = 72;
        byArray[83] = 92;
        byArray[84] = -59;
        byArray[85] = -41;
        byArray[86] = 10;
        byArray[87] = 70;
        byArray[88] = -52;
        byArray[89] = 86;
        byArray[90] = -49;
        byArray[91] = -111;
        byArray[92] = 69;
        byArray[93] = 18;
        byArray[94] = -103;
        byArray[95] = -12;
        byArray[96] = -80;
        byArray[97] = 67;
        byArray[98] = -44;
        byArray[99] = -2;
        byArray[100] = -7;
        byArray[101] = -78;
        byArray[102] = -74;
        byArray[103] = -57;
        byArray[104] = 114;
        byArray[105] = -42;
        byArray[106] = 19;
        byArray[107] = -94;
        byArray[108] = 4;
        byArray[109] = 120;
        byArray[110] = 62;
        byArray[111] = 21;
        byArray[112] = -60;
        byArray[113] = 104;
        byArray[114] = 124;
        byArray[115] = -36;
        byArray[116] = -26;
        byArray[117] = -55;
        byArray[118] = -93;
        byArray[119] = 3;
        byArray[120] = -121;
        byArray[121] = 100;
        byArray[122] = -46;
        byArray[123] = -21;
        byArray[124] = -29;
        byArray[125] = -90;
        byArray[126] = -76;
        byArray[127] = -45;
        byArray[128] = -92;
        byArray[129] = -53;
        byArray[130] = -37;
        byArray[131] = 49;
        byArray[132] = 54;
        byArray[133] = 64;
        byArray[134] = 101;
        byArray[135] = -89;
        byArray[136] = 117;
        byArray[137] = -28;
        byArray[138] = -56;
        byArray[139] = -85;
        byArray[140] = 2;
        byArray[141] = -128;
        byArray[142] = 47;
        byArray[143] = -51;
        byArray[144] = 66;
        byArray[145] = -38;
        byArray[146] = 125;
        byArray[147] = 90;
        byArray[148] = 68;
        byArray[149] = 99;
        byArray[150] = -91;
        byArray[151] = 97;
        byArray[152] = -77;
        byArray[153] = 77;
        byArray[154] = -1;
        byArray[155] = 59;
        byArray[156] = -84;
        byArray[157] = 109;
        byArray[158] = -32;
        byArray[159] = 6;
        byArray[160] = 81;
        byArray[161] = -4;
        byArray[162] = -82;
        byArray[163] = 116;
        byArray[164] = -75;
        byArray[165] = -6;
        byArray[166] = -72;
        byArray[167] = 88;
        byArray[168] = -39;
        byArray[169] = -108;
        byArray[170] = 84;
        byArray[171] = -69;
        byArray[172] = 105;
        byArray[173] = 107;
        byArray[174] = -16;
        byArray[175] = 74;
        byArray[176] = 58;
        byArray[177] = 17;
        byArray[178] = -117;
        byArray[179] = 30;
        byArray[180] = -104;
        byArray[181] = 40;
        byArray[182] = 39;
        byArray[183] = 43;
        byArray[184] = 22;
        byArray[185] = 42;
        byArray[186] = -87;
        byArray[187] = 41;
        byArray[188] = 12;
        byArray[189] = 28;
        byArray[190] = -5;
        byArray[191] = -124;
        byArray[192] = -61;
        byArray[193] = 112;
        byArray[194] = -54;
        byArray[195] = 15;
        byArray[196] = -22;
        byArray[197] = -99;
        byArray[198] = 60;
        byArray[199] = -112;
        byArray[200] = 119;
        byArray[201] = -43;
        byArray[202] = -19;
        byArray[203] = -11;
        byArray[204] = 5;
        byArray[205] = 126;
        byArray[206] = 98;
        byArray[207] = -33;
        byArray[208] = -62;
        byArray[209] = 83;
        byArray[210] = -9;
        byArray[211] = 91;
        byArray[212] = 115;
        byArray[213] = -15;
        byArray[214] = 65;
        byArray[215] = -86;
        byArray[216] = 23;
        byArray[217] = -106;
        byArray[218] = -14;
        byArray[219] = -31;
        byArray[220] = -23;
        byArray[221] = 45;
        byArray[222] = -98;
        byArray[223] = 26;
        byArray[224] = 80;
        byArray[225] = 53;
        byArray[226] = -63;
        byArray[227] = 16;
        byArray[228] = 87;
        byArray[230] = 48;
        byArray[231] = 121;
        byArray[232] = -8;
        byArray[233] = 32;
        byArray[234] = 95;
        byArray[235] = 20;
        byArray[236] = 75;
        byArray[237] = 44;
        byArray[238] = 106;
        byArray[239] = 79;
        byArray[240] = -10;
        byArray[241] = 73;
        byArray[242] = 113;
        byArray[243] = -120;
        byArray[244] = 25;
        byArray[245] = -48;
        byArray[246] = -73;
        byArray[247] = 34;
        byArray[248] = 89;
        byArray[249] = -127;
        byArray[250] = -24;
        byArray[251] = 1;
        byArray[252] = -109;
        byArray[253] = 123;
        byArray[254] = 57;
        byArray[255] = 122;
        htable = byArray;
    }

    private static byte[] int2bytes(int n, byte[] buf) {
        int i = 4;
        while (i > 0) {
            buf[--i] = (byte)(n & 0xFF);
            n >>>= 8;
        }
        return buf;
    }

    private static byte[] long2bytes(long n, byte[] buf) {
        int i = 8;
        while (i > 0) {
            buf[--i] = (byte)(n & 0xFFL);
            n >>>= 8;
        }
        return buf;
    }

    public static int intHash(byte[] data, int key) {
        byte[] hash = new byte[4];
        Hash.int2bytes(key, hash);
        Hash.int2bytes(Hash.intHash(hash), hash);
        return Hash.intHash(data, hash);
    }

    public static int intHash(byte[] data) {
        byte[] hash = new byte[]{-54, -2, -70, -66};
        return Hash.intHash(data, hash);
    }

    public static int intHash(byte[] data, byte[] hash) {
        Hash.byteHash(data, hash);
        return hash[0] << 24 | hash[1] << 24 >>> 8 | hash[2] << 24 >>> 16 | hash[3] << 24 >>> 24;
    }

    public static long longHash(byte[] data, long key) {
        byte[] hash = new byte[8];
        Hash.long2bytes(key, hash);
        Hash.long2bytes(Hash.longHash(hash), hash);
        return Hash.longHash(data, hash);
    }

    public static long longHash(byte[] data) {
        byte[] hash = new byte[]{-34, -82, -66, -17, -54, -2, -70, -66};
        return Hash.longHash(data, hash);
    }

    public static long longHash(byte[] data, byte[] hash) {
        Hash.byteHash(data, hash);
        return (long)hash[0] << 56 | (long)hash[1] << 56 >>> 8 | (long)hash[2] << 56 >>> 16 | (long)hash[3] << 56 >>> 24 | (long)hash[4] << 56 >>> 32 | (long)hash[5] << 56 >>> 40 | (long)hash[6] << 56 >>> 48 | (long)hash[7] << 56 >>> 56;
    }

    public static byte[] byteHash(byte[] data, byte[] hash) {
        int i = -1;
        while (++i < data.length) {
            byte source = data[i];
            int j = hash.length;
            int s = 0;
            while (--j >= 0) {
                int index;
                hash[j] = htable[(index = hash[j] ^ source + (byte)s++) < 0 ? index + 256 : index];
            }
        }
        return hash;
    }

    public static String toString(int hash) {
        String hex = Integer.toHexString(hash);
        String zeroes = "0x0000000";
        return String.valueOf(zeroes.substring(0, 8 - hex.length() + 2)) + hex;
    }

    public static String toString(long hash) {
        String hex = Long.toHexString(hash);
        String zeroes = "0x000000000000000";
        return String.valueOf(zeroes.substring(0, 16 - hex.length() + 2)) + hex;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(Hash.intHash(args[0].getBytes("UTF-16BE")));
        System.out.println(Hash.toString(Hash.longHash(args[0].getBytes("UTF-16BE"))));
    }

    public Hash(byte[] bytes) {
        this.intKey = Hash.intHash(bytes);
        this.longKey = Hash.longHash(bytes);
    }

    public Hash(String string) {
        this(string.getBytes());
    }

    public String toString() {
        return Hash.toString(this.intKey);
    }

    public int hashCode() {
        return this.intKey;
    }

    public long longHashCode() {
        return this.longKey;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Hash && ((Hash)o).longKey == this.longKey;
    }

    public void hash(byte[] bytes) {
        this.intKey = Hash.intHash(bytes, this.intKey);
        this.longKey = Hash.longHash(bytes, this.longKey);
    }

    public void hash(String string) {
        this.hash(string.getBytes());
    }
}

