/**
 * Copyright 2017 TerraMeta Software, Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.plasma.common.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import org.plasma.common.exception.PlasmaRuntimeException;

public class FileNameFilter implements FilenameFilter {
  private Pattern pattern;

  public FileNameFilter(String expression) {
    try {
      pattern = Pattern.compile(expression);
    } catch (PatternSyntaxException e) {
      throw new PlasmaRuntimeException(e);
    }
  }

  public boolean accept(File dir, String name) {
    return pattern.matcher(name).matches();
  }
}
