/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.common.provisioning;

public class NameUtils {
    public static String toCamelCase(String name) {
        StringBuilder buf = new StringBuilder();
        if (name.indexOf("_") >= 0) {
            char[] array = name.toLowerCase().toCharArray();
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    if (array[i] == '_') {
                        int next = i + 1;
                        if (next >= array.length) continue;
                        array[next] = Character.toUpperCase(array[next]);
                        continue;
                    }
                    buf.append(array[i]);
                    continue;
                }
                buf.append(Character.toUpperCase(array[i]));
            }
        } else {
            char[] array = name.toCharArray();
            if (NameUtils.hasUpper(array)) {
                if (NameUtils.hasLower(array)) {
                    buf.append(name);
                } else {
                    buf.append(name.toLowerCase());
                }
            } else {
                buf.append(name);
            }
        }
        return buf.toString();
    }

    private static boolean hasDelimiter(char[] array, char c) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != c) continue;
            return true;
        }
        return false;
    }

    private static boolean hasLower(char[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!Character.isLowerCase(array[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean hasUpper(char[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!Character.isUpperCase(array[i])) continue;
            return true;
        }
        return false;
    }

    public static String toConstantName(String name) {
        StringBuilder buf = new StringBuilder();
        char[] array = name.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0 && Character.isLetter(array[i]) && Character.isUpperCase(array[i])) {
                buf.append("_");
            }
            if (Character.isLetterOrDigit(array[i])) {
                buf.append(Character.toUpperCase(array[i]));
                continue;
            }
            buf.append("_");
        }
        return buf.toString();
    }

    public static String toAbbreviatedName(String name) {
        return NameUtils.toAbbreviatedName(name, 4);
    }

    public static String toAbbreviatedName(String name, int max) {
        String constantName = NameUtils.toConstantName(name);
        if (constantName.length() <= max) {
            return constantName;
        }
        StringBuilder buf = new StringBuilder();
        char[] array = constantName.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            if (i == 0) {
                buf.append(array[i]);
                continue;
            }
            if (array[i] == 'A' || array[i] == 'E' || array[i] == 'I' || array[i] == 'O' || array[i] == 'U') continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String firstToUpperCase(String name) {
        if (Character.isLowerCase(name.charAt(0))) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return name;
    }

    public static String firstToLowerCase(String name) {
        if (Character.isUpperCase(name.charAt(0))) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return name;
    }
}

