/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.common;

import java.io.Serializable;
import java.util.Arrays;

public class Key<T>
implements Serializable {
    private static final long serialVersionUID = -4400857484478081281L;
    private static final String DELIM = "|";
    private static final String DELIM_REGEX = "\\|";
    private T[] values;
    private int hashCode;

    private Key() {
    }

    @SafeVarargs
    public Key(T ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("expected non-null and non-zero length array");
        }
        this.values = values;
        this.hashCode = Arrays.hashCode(this.values);
    }

    public static String[] parse(String source) {
        String[] tokens = source.split(DELIM_REGEX);
        return tokens;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Key other = (Key)obj;
        return this.hashCode == other.hashCode;
    }

    public String toString() {
        if (this.values.length == 1) {
            return String.valueOf(this.values[0]);
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        T[] TArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            if (i > 0) {
                buf.append(DELIM);
            }
            buf.append(String.valueOf(value));
            ++i;
            ++n2;
        }
        return buf.toString();
    }
}

