/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.common.env;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.plasma.common.env.EnvName;

public class EnvProperties {
    private static EnvProperties instance;
    private Properties props = new Properties();
    private EnvName env;
    private String fileName = System.getProperty("plasma.env.property.filename", "plasma.properties");

    private EnvProperties() {
        try {
            FileInputStream fis = new FileInputStream(this.fileName);
            this.props.load(fis);
        }
        catch (IOException fis) {
            // empty catch block
        }
        this.props.putAll((Map<?, ?>)System.getProperties());
        for (String string : this.props.keySet()) {
            this.props.setProperty(string, this.props.getProperty(string).trim());
        }
        try {
            String string = this.props.getProperty("plasma.env");
            if (string != null) {
                String string2 = string.toUpperCase();
                this.env = EnvName.valueOf(string2);
            } else {
                this.env = EnvName.DEV;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.env = EnvName.DEV;
        }
    }

    public String dumpProperties(String separator) {
        StringBuffer buf = new StringBuffer();
        for (String string : this.props.keySet()) {
            String value = this.props.getProperty(string);
            buf.append(String.valueOf(separator) + string + "='" + value + "'");
        }
        return buf.toString();
    }

    public static EnvProperties instance() {
        if (instance == null) {
            EnvProperties.initInstance();
        }
        return instance;
    }

    private static synchronized void initInstance() {
        if (instance == null) {
            instance = new EnvProperties();
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public String getProperty(String name, String defaultValue) {
        return this.props.getProperty(name, defaultValue);
    }

    public String getPropertiesFileName() {
        return this.fileName;
    }

    public EnvName getEnv() {
        return this.env;
    }
}

