/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.common.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PlasmaTest
extends TestCase {
    protected Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public PlasmaTest() {
    }

    public PlasmaTest(String name) {
        super(name);
    }

    public MBeanServerConnection getServer() throws NamingException {
        throw new RuntimeException("not implemented");
    }

    public boolean isTargetJBoss() {
        return true;
    }

    public boolean isTargetTomcat() {
        return false;
    }

    protected InitialContext getInitialContext(String clientName) throws NamingException {
        InitialContext iniCtx = new InitialContext();
        Hashtable<?, ?> env = iniCtx.getEnvironment();
        env.put("java.naming.factory.url.pkgs", "org.jboss.naming.client");
        env.put("j2ee.clientName", clientName);
        return new InitialContext(env);
    }

    protected InitialContext getInitialContext() throws NamingException {
        return this.getInitialContext("jbossws-client");
    }

    public boolean hasJDK15() {
        try {
            Class.forName("java.lang.Enum");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static String getServerHost() {
        String hostName = System.getProperty("jbosstest.host.name", "localhost");
        return hostName;
    }

    public static void assertEquals(Object exp, Object was) {
        if (exp instanceof Object[] && was instanceof Object[]) {
            PlasmaTest.assertEqualsArray((Object[])exp, (Object[])was);
        } else if (exp instanceof byte[] && was instanceof byte[]) {
            PlasmaTest.assertEqualsArray((byte[])exp, (byte[])was);
        } else if (exp instanceof boolean[] && was instanceof boolean[]) {
            PlasmaTest.assertEqualsArray((boolean[])exp, (boolean[])was);
        } else if (exp instanceof short[] && was instanceof short[]) {
            PlasmaTest.assertEqualsArray((short[])exp, (short[])was);
        } else if (exp instanceof int[] && was instanceof int[]) {
            PlasmaTest.assertEqualsArray((int[])exp, (int[])was);
        } else if (exp instanceof long[] && was instanceof long[]) {
            PlasmaTest.assertEqualsArray((long[])exp, (long[])was);
        } else if (exp instanceof float[] && was instanceof float[]) {
            PlasmaTest.assertEqualsArray((float[])exp, (float[])was);
        } else if (exp instanceof double[] && was instanceof double[]) {
            PlasmaTest.assertEqualsArray((double[])exp, (double[])was);
        } else {
            TestCase.assertEquals((Object)exp, (Object)was);
        }
    }

    private static void assertEqualsArray(Object[] exp, Object[] was) {
        if (exp == null && was == null) {
            return;
        }
        if (exp != null && was != null) {
            if (exp.length != was.length) {
                PlasmaTest.fail((String)("Expected <" + exp.length + "> array items, but was <" + was.length + ">"));
            } else {
                for (int i = 0; i < exp.length; ++i) {
                    Object compExp = exp[i];
                    Object compWas = was[i];
                    PlasmaTest.assertEquals(compExp, compWas);
                }
            }
        } else if (exp == null) {
            PlasmaTest.fail((String)("Expected a null array, but was: " + Arrays.asList(was)));
        } else if (was == null) {
            PlasmaTest.fail((String)("Expected " + Arrays.asList(exp) + ", but was: null"));
        }
    }

    private static void assertEqualsArray(byte[] exp, byte[] was) {
        PlasmaTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(boolean[] exp, boolean[] was) {
        PlasmaTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(short[] exp, short[] was) {
        PlasmaTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(int[] exp, int[] was) {
        PlasmaTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(long[] exp, long[] was) {
        PlasmaTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(float[] exp, float[] was) {
        PlasmaTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    private static void assertEqualsArray(double[] exp, double[] was) {
        PlasmaTest.assertTrue((String)"Arrays don't match", (boolean)Arrays.equals(exp, was));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContent(InputStream source) throws IOException {
        byte[] buf = new byte[4000];
        ByteArrayOutputStream os = new ByteArrayOutputStream(4000);
        try {
            int len = -1;
            while ((len = source.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
        }
        finally {
            source.close();
            os.flush();
        }
        return os.toByteArray();
    }
}

