/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.common.sort;

import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.common.sort.Sorter;

public class InsertionSort
extends Sorter {
    private static Log log = LogFactory.getFactory().getInstance(InsertionSort.class);

    @Override
    public <T extends Comparable<? super T>> void sort(T[] a) {
        for (int i = 1; i < a.length; ++i) {
            T o = a[i];
            for (int j = i; j > 0 && o.compareTo(a[j - 1]) < 0; --j) {
                a[j] = a[j - 1];
            }
            a[j] = o;
        }
    }

    public <T> void sort(T[] a, Comparator<T> c) {
        for (int i = 1; i < a.length; ++i) {
            T o = a[i];
            for (int j = i; j > 0 && c.compare(o, a[j - 1]) < 0; --j) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("swapping (" + String.valueOf(j) + ") " + a[j].toString() + " for (" + String.valueOf(j - 1) + ") " + a[j - 1].toString()));
                }
                a[j] = a[j - 1];
            }
            a[j] = o;
        }
    }
}

