/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.common.provisioning;

public class NameUtils {
    public static String toCamelCase(String name) {
        StringBuilder buf = new StringBuilder();
        if (name.indexOf("_") >= 0) {
            char[] array = name.toLowerCase().toCharArray();
            int i = 0;
            while (i < array.length) {
                if (i > 0) {
                    if (array[i] == '_') {
                        int next = i + 1;
                        if (next < array.length) {
                            array[next] = Character.toUpperCase(array[next]);
                        }
                    } else {
                        buf.append(array[i]);
                    }
                } else {
                    buf.append(Character.toUpperCase(array[i]));
                }
                ++i;
            }
        } else {
            char[] array = name.toCharArray();
            if (NameUtils.hasUpper(array)) {
                if (NameUtils.hasLower(array)) {
                    buf.append(name);
                } else {
                    buf.append(name.toLowerCase());
                }
            } else {
                buf.append(name);
            }
        }
        return buf.toString();
    }

    private static boolean hasDelimiter(char[] array, char c) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasLower(char[] array) {
        int i = 0;
        while (i < array.length) {
            if (Character.isLowerCase(array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasUpper(char[] array) {
        int i = 0;
        while (i < array.length) {
            if (Character.isUpperCase(array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String toConstantName(String name) {
        StringBuilder buf = new StringBuilder();
        char[] array = name.toCharArray();
        int i = 0;
        while (i < array.length) {
            if (i > 0 && Character.isLetter(array[i]) && Character.isUpperCase(array[i])) {
                buf.append("_");
            }
            if (Character.isLetterOrDigit(array[i])) {
                buf.append(Character.toUpperCase(array[i]));
            } else {
                buf.append("_");
            }
            ++i;
        }
        return buf.toString();
    }

    public static String toAbbreviatedName(String name) {
        return NameUtils.toAbbreviatedName(name, 4);
    }

    public static String toAbbreviatedName(String name, int max) {
        String constantName = NameUtils.toConstantName(name);
        if (constantName.length() <= max) {
            return constantName;
        }
        StringBuilder buf = new StringBuilder();
        char[] array = constantName.toCharArray();
        int i = 0;
        while (i < array.length) {
            if (i == 0) {
                buf.append(array[i]);
            } else if (array[i] != 'A' && array[i] != 'E' && array[i] != 'I' && array[i] != 'O' && array[i] != 'U') {
                buf.append(array[i]);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String firstToUpperCase(String name) {
        if (Character.isLowerCase(name.charAt(0))) {
            return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        }
        return name;
    }

    public static String firstToLowerCase(String name) {
        if (Character.isUpperCase(name.charAt(0))) {
            return String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
        }
        return name;
    }
}

