/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.common.bind;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Source;

public class DataBindingSupport {
    protected JAXBContext context;

    private DataBindingSupport() {
    }

    public DataBindingSupport(JAXBContext context) {
        this.context = context;
    }

    public String marshal(Object root) throws JAXBException {
        StringWriter writer = new StringWriter();
        Marshaller m = this.context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        m.marshal(root, (Writer)writer);
        return writer.toString();
    }

    public void marshal(Object root, OutputStream stream) throws JAXBException {
        Marshaller m = this.context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        m.marshal(root, stream);
    }

    public void marshal(Object root, OutputStream stream, boolean formattedOutput) throws JAXBException {
        Marshaller m = this.context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)new Boolean(formattedOutput));
        m.setProperty("jaxb.encoding", (Object)"UTF-8");
        m.marshal(root, stream);
    }

    public Object unmarshal(String xml) throws JAXBException {
        Unmarshaller u = this.context.createUnmarshaller();
        return u.unmarshal((Reader)new StringReader(xml));
    }

    public Object unmarshal(Reader reader) throws JAXBException {
        Unmarshaller u = this.context.createUnmarshaller();
        return u.unmarshal(reader);
    }

    public Object unmarshal(Source source) throws JAXBException {
        Unmarshaller u = this.context.createUnmarshaller();
        return u.unmarshal(source);
    }

    public Object unmarshal(InputStream stream) throws JAXBException {
        StringWriter writer = new StringWriter();
        Unmarshaller u = this.context.createUnmarshaller();
        return u.unmarshal(stream);
    }
}

