/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.Fuml;
import org.modeldriven.fuml.io.ResourceArtifact;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.common.env.EnvProperties;
import org.plasma.common.exception.PlasmaRuntimeException;
import org.plasma.config.Artifact;
import org.plasma.config.ConfigUtils;
import org.plasma.config.ConfigurationException;
import org.plasma.config.DataAccessProvider;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.DataAccessService;
import org.plasma.config.DataStoreType;
import org.plasma.config.ImplementationProvisioning;
import org.plasma.config.Namespace;
import org.plasma.config.NamespaceLink;
import org.plasma.config.NamespaceProvisioning;
import org.plasma.config.NonExistantNamespaceException;
import org.plasma.config.PlasmaConfigDataBinding;
import org.plasma.config.PlasmaConfigValidationEventHandler;
import org.plasma.config.PlasmaConfiguration;
import org.plasma.config.ProfileVersionDetectionException;
import org.plasma.config.ProfileVersionFinder;
import org.plasma.config.Property;
import org.plasma.config.QueryDSLProvisioning;
import org.plasma.config.RDBMSVendorName;
import org.plasma.config.Repository;
import org.plasma.config.SDO;
import org.plasma.config.TypeBinding;
import org.plasma.config.adapter.NamespaceAdapter;
import org.plasma.config.adapter.PropertyBindingAdapter;
import org.plasma.config.adapter.TypeBindingAdapter;
import org.plasma.profile.ProfileArtifact;
import org.plasma.profile.ProfileConfig;
import org.plasma.profile.ProfileURN;
import org.plasma.profile.adapter.ProfileArtifactAdapter;
import org.xml.sax.SAXException;

public class PlasmaConfig {
    private static Log log = LogFactory.getLog(PlasmaConfig.class);
    private static volatile PlasmaConfig instance = null;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final String defaultConfigFileName = "plasma-config.xml";
    private String configFileNameOrURIString;
    private URI configURI;
    private long configFileLastModifiedDate = System.currentTimeMillis();
    private PlasmaConfiguration config;
    private Map<String, Artifact> artifactMap = new HashMap<String, Artifact>();
    private Map<String, NamespaceAdapter> sdoNamespaceMap = new HashMap<String, NamespaceAdapter>();
    private DataAccessProviderName defaultProviderName;
    private Map<DataStoreType, Map<String, NamespaceLink>> dataStoreNamespaceLinkMap = new HashMap<DataStoreType, Map<String, NamespaceLink>>();
    private Map<DataAccessProviderName, DataAccessProvider> dataAccessProviderMap = new HashMap<DataAccessProviderName, DataAccessProvider>();
    private Map<DataAccessProviderName, Map<String, NamespaceProvisioning>> dataAccessProviderProvisioningMap = new HashMap<DataAccessProviderName, Map<String, NamespaceProvisioning>>();
    private Map<DataAccessProviderName, Map<String, Property>> dataAccessProviderPropertyMap = new HashMap<DataAccessProviderName, Map<String, Property>>();
    private NamespaceAdapter dataTypesNamespace;
    private NamespaceAdapter profileNamespace;

    private PlasmaConfig() {
        log.debug((Object)"initializing...");
        try {
            this.configFileNameOrURIString = EnvProperties.instance().getProperty("plasma.configuration");
            if (this.configFileNameOrURIString == null) {
                this.configFileNameOrURIString = defaultConfigFileName;
            }
            PlasmaConfigDataBinding configBinding = new PlasmaConfigDataBinding(new PlasmaConfigValidationEventHandler());
            this.config = this.unmarshalConfig(this.configFileNameOrURIString, configBinding);
            this.constructArtifactAndNamespaceMappings();
            this.constructKnownArtifacts();
            this.constructDataAccessServiceMappings();
            this.validateNamespaceToDataStoreMappings();
        }
        catch (SAXException e) {
            throw new ConfigurationException(e);
        }
        catch (JAXBException e) {
            throw new ConfigurationException(e);
        }
    }

    private void constructArtifactAndNamespaceMappings() throws ConfigurationException {
        for (Artifact artifact : this.config.getRepository().getArtifacts()) {
            this.artifactMap.put(artifact.getNamespaceUri(), artifact);
        }
        if (this.config.getSDO().getDefaultNamespace() != null) {
            if (this.artifactMap.get(this.config.getSDO().getDefaultNamespace().getArtifact()) == null) {
                throw new ConfigurationException("Invalid SDO Namespace - could not find repository artifact based on URI '" + this.config.getSDO().getDefaultNamespace().getArtifact() + "'");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("setting default namespace: " + this.config.getSDO().getDefaultNamespace().getUri()));
            }
            NamespaceAdapter defaultNamespace = new NamespaceAdapter(this.config.getSDO().getDefaultNamespace());
            this.sdoNamespaceMap.put(this.config.getSDO().getDefaultNamespace().getUri(), defaultNamespace);
            this.profileNamespace = defaultNamespace;
            this.dataTypesNamespace = defaultNamespace;
        }
        for (Namespace namespace : this.config.getSDO().getNamespaces()) {
            if (this.artifactMap.get(namespace.getArtifact()) == null) {
                throw new ConfigurationException("Invalid SDO Namespace - could not find repository artifact based on URI '" + namespace.getArtifact() + "'");
            }
            if (this.sdoNamespaceMap.get(namespace.getUri()) != null) {
                throw new ConfigurationException("duplicate SDO namespace configuration - a namespace with URI '" + namespace.getUri() + "' already exists " + "within the configuration");
            }
            if (namespace.getProvisioning() == null) {
                NamespaceProvisioning provisioning = this.createDefaultProvisioning(namespace.getUri());
                namespace.setProvisioning(provisioning);
            }
            NamespaceAdapter namespaceAdapter = new NamespaceAdapter(namespace);
            this.sdoNamespaceMap.put(namespace.getUri(), namespaceAdapter);
            if (this.sdoNamespaceMap.get(namespace.getProvisioning().getPackageName()) != null) {
                throw new ConfigurationException("duplicate SDO namespace configuration - a namespace with provisioning package name '" + namespace.getProvisioning().getPackageName() + "' already exists " + "within the configuration");
            }
            this.sdoNamespaceMap.put(namespace.getProvisioning().getPackageName(), namespaceAdapter);
            for (TypeBinding typeBinding : namespace.getTypeBindings()) {
                namespaceAdapter.addTypeBinding(typeBinding);
            }
        }
        for (String artifactUri : this.artifactMap.keySet()) {
            Artifact artifact = this.artifactMap.get(artifactUri);
            if (this.sdoNamespaceMap.get(artifact.getNamespaceUri()) != null) continue;
            Namespace namespace = new Namespace();
            namespace.setArtifact(artifact.getNamespaceUri());
            namespace.setUri(artifact.getNamespaceUri());
            NamespaceProvisioning provisioning = this.createDefaultProvisioning(artifact.getNamespaceUri());
            namespace.setProvisioning(provisioning);
            NamespaceAdapter namespaceAdapter = new NamespaceAdapter(namespace);
            this.sdoNamespaceMap.put(namespace.getUri(), namespaceAdapter);
        }
    }

    private void constructKnownArtifacts() throws ProfileVersionDetectionException {
        NamespaceAdapter namespaceAdapter;
        ProfileArtifactAdapter papyrusProfile;
        HashMap<String, ProfileArtifactAdapter> versions = new HashMap<String, ProfileArtifactAdapter>();
        for (Artifact artifact : this.config.getRepository().getArtifacts()) {
            if (ProfileConfig.getInstance().findArtifactByUri(artifact.getNamespaceUri()) != null) continue;
            InputStream stream = PlasmaConfig.class.getResourceAsStream(artifact.getUrn());
            if (stream == null) {
                stream = PlasmaConfig.class.getClassLoader().getResourceAsStream(artifact.getUrn());
            }
            if (stream == null) {
                if (this.configURI == null) {
                    throw new PlasmaRuntimeException("could not find artifact resource '" + artifact.getUrn() + "' on the current classpath");
                }
                URI artifactURI = null;
                try {
                    artifactURI = this.configURI.resolve(artifact.getUrn());
                    stream = artifactURI.toURL().openStream();
                }
                catch (IllegalArgumentException e) {
                    throw new PlasmaRuntimeException((Throwable)e);
                }
                catch (MalformedURLException e) {
                    throw new PlasmaRuntimeException((Throwable)e);
                }
                catch (IOException e) {
                    throw new PlasmaRuntimeException((Throwable)e);
                }
                if (stream == null) {
                    throw new PlasmaRuntimeException("could not find artifact resource '" + artifact.getUrn() + "' on the current classpath or as a relative URI based on the configuration URI, " + this.configURI.toString());
                }
            }
            ProfileVersionFinder finder = new ProfileVersionFinder();
            ProfileArtifactAdapter version = finder.getVersion(artifact.getUrn(), stream);
            if (log.isDebugEnabled()) {
                log.debug((Object)("artifact: (" + artifact.getUrn() + ") " + artifact.getNamespaceUri() + " - detected as Plasma SDO Profile version (" + (Object)((Object)version.getUrn()) + ") " + version.getNamespaceUri()));
            }
            versions.put(version.getNamespaceUri(), version);
        }
        if (versions.size() > 1) {
            StringBuilder buf = new StringBuilder();
            ProfileArtifact[] versionArray = new ProfileArtifact[versions.values().size()];
            versions.values().toArray(versionArray);
            for (int i = 0; i < versionArray.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(versionArray[i].getNamespaceUri());
            }
            throw new ProfileVersionDetectionException("multiple profile versions detected(" + buf.toString() + ") for configured set of UML artifacts '" + "' - all UML artifacts are required to be annotated with the same version " + "of the PlasmaSDO UML Profile");
        }
        if (this.profileNamespace == null && versions.get((papyrusProfile = ProfileConfig.getInstance().findArtifactByUrn(ProfileURN.PLASMA_SDO___PROFILE___V_1___1___UML)).getNamespaceUri()) != null) {
            ProfileArtifactAdapter papyrusProfileDatatypes;
            if (this.artifactMap.get(papyrusProfile.getNamespaceUri()) == null) {
                namespaceAdapter = this.loadKnownArtifact(papyrusProfile.getUrn().value(), papyrusProfile.getNamespaceUri());
                if (namespaceAdapter != null) {
                    this.profileNamespace = namespaceAdapter;
                } else {
                    log.debug((Object)("no resource found for, " + papyrusProfile.getUrn().value()));
                }
            }
            if (this.artifactMap.get((papyrusProfileDatatypes = ProfileConfig.getInstance().findArtifactByUrn(ProfileURN.PLASMA_SDO_DATA_TYPES___V_1___1___UML)).getNamespaceUri()) == null) {
                NamespaceAdapter namespaceAdapter2 = this.loadKnownArtifact(papyrusProfileDatatypes.getUrn().value(), papyrusProfileDatatypes.getNamespaceUri());
                if (namespaceAdapter2 != null) {
                    this.dataTypesNamespace = namespaceAdapter2;
                } else {
                    log.debug((Object)("no resource found for, " + papyrusProfileDatatypes.getUrn().value()));
                }
            }
        }
        if (this.profileNamespace == null) {
            ProfileArtifactAdapter magicdrawProfile = ProfileConfig.getInstance().findArtifactByUrn(ProfileURN.PLASMA___SDO___PROFILE___V_1___1___MDXML);
            namespaceAdapter = this.loadKnownArtifact(magicdrawProfile.getUrn().value(), magicdrawProfile.getNamespaceUri());
            if (namespaceAdapter != null) {
                this.profileNamespace = namespaceAdapter;
                this.dataTypesNamespace = namespaceAdapter;
            } else {
                log.debug((Object)("no resource found for, " + magicdrawProfile.getUrn().value()));
            }
        }
    }

    private NamespaceAdapter loadKnownArtifact(String resource, String uri) {
        InputStream stream = PlasmaConfig.class.getClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("loading known UML/XMI artifact, " + resource + " (" + uri + ")"));
        }
        Fuml.load((ResourceArtifact)new ResourceArtifact(resource, uri, stream));
        Namespace namespace = new Namespace();
        namespace.setArtifact(uri);
        namespace.setUri(uri);
        namespace.setProvisioning(null);
        NamespaceAdapter namespaceAdapter = new NamespaceAdapter(namespace);
        this.sdoNamespaceMap.put(namespace.getUri(), namespaceAdapter);
        return namespaceAdapter;
    }

    public NamespaceAdapter getSDODataTypesNamespace() {
        return this.dataTypesNamespace;
    }

    public NamespaceAdapter getSDOProfileNamespace() {
        return this.profileNamespace;
    }

    private void constructDataAccessServiceMappings() throws ConfigurationException {
        for (DataAccessService daconfig : this.config.getSDO().getDataAccessServices()) {
            for (DataAccessProvider provider : daconfig.getDataAccessProviders()) {
                Map<String, NamespaceLink> linkMap;
                if (this.defaultProviderName == null) {
                    this.defaultProviderName = provider.name;
                }
                this.dataAccessProviderMap.put(provider.getName(), provider);
                Map<String, NamespaceProvisioning> provMap = this.dataAccessProviderProvisioningMap.get((Object)provider.getName());
                if (provMap == null) {
                    provMap = new HashMap<String, NamespaceProvisioning>();
                    this.dataAccessProviderProvisioningMap.put(provider.getName(), provMap);
                }
                if ((linkMap = this.dataStoreNamespaceLinkMap.get((Object)daconfig.getDataStoreType())) == null) {
                    linkMap = new HashMap<String, NamespaceLink>();
                    this.dataStoreNamespaceLinkMap.put(daconfig.getDataStoreType(), linkMap);
                }
                for (NamespaceLink namespaceLink : provider.getNamespaceLinks()) {
                    if (namespaceLink.getUri() == null) {
                        throw new ConfigurationException("expected namespace URI for Data Access Service configuration '" + provider.getName().toString() + "'");
                    }
                    linkMap.put(namespaceLink.getUri(), namespaceLink);
                    NamespaceAdapter adapter = this.sdoNamespaceMap.get(namespaceLink.getUri());
                    if (adapter == null) {
                        throw new ConfigurationException("Invalid SDO Namespace - could not find SDO namespace based on namespace URI '" + namespaceLink.getUri() + "' for Data Access Service configuration '" + provider.getName().toString() + "'");
                    }
                    if (adapter.getNamespace().getProvisioning() != null && adapter.getNamespace().getProvisioning().getPackageName() != null && namespaceLink.getProvisioning() != null && adapter.getNamespace().getProvisioning().getPackageName().equals(namespaceLink.getProvisioning().getPackageName())) {
                        throw new ConfigurationException("Duplicate provisioning package name (" + namespaceLink.getProvisioning().getPackageName() + ") for SDO Namespace '" + namespaceLink.getUri() + "' and Data Access Service configuration '" + provider.getName().toString() + "'");
                    }
                    if (namespaceLink.getProvisioning() == null) continue;
                    provMap.put(namespaceLink.getUri(), namespaceLink.getProvisioning());
                }
                Map<String, Property> propertyMap = this.dataAccessProviderPropertyMap.get((Object)provider.getName());
                if (propertyMap == null) {
                    propertyMap = new HashMap<String, Property>();
                    this.dataAccessProviderPropertyMap.put(provider.getName(), propertyMap);
                }
                for (Property property : provider.getProperties()) {
                    propertyMap.put(property.getName(), property);
                }
            }
        }
    }

    private void validateNamespaceToDataStoreMappings() {
        for (Namespace namespace : this.config.getSDO().getNamespaces()) {
            int count = 0;
            for (Map<String, NamespaceLink> map : this.dataStoreNamespaceLinkMap.values()) {
                NamespaceLink link = map.get(namespace.getUri());
                if (link == null) continue;
                ++count;
            }
            if (count == 0) {
                throw new ConfigurationException("SDO namespace '" + namespace.getUri() + "' not mapped to any " + "data access provider - every namespace should ba mapped/linked to one provider using a " + NamespaceLink.class.getSimpleName() + " within the provider configuration");
            }
            if (count <= true) continue;
            throw new ConfigurationException("SDO namespace '" + namespace.getUri() + "' mapped to multiple " + "data access providers - every namespace should ba mapped/linked to a single provider using a " + NamespaceLink.class.getSimpleName() + " within the provider configuration");
        }
    }

    public String getConfigFileName() {
        return this.configFileNameOrURIString;
    }

    public long getConfigFileLastModifiedDate() {
        return this.configFileLastModifiedDate;
    }

    public URI getConfigURI() {
        return this.configURI;
    }

    public DataAccessProviderName getDefaultProviderName() {
        return this.defaultProviderName;
    }

    private NamespaceProvisioning createDefaultProvisioning(String uri) {
        NamespaceProvisioning provisioning = new NamespaceProvisioning();
        String[] tokens = ConfigUtils.toPackageTokens(uri);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            if (i > 0) {
                buf.append(".");
            }
            buf.append(tokens[i]);
        }
        provisioning.setPackageName(buf.toString());
        return provisioning;
    }

    private PlasmaConfiguration unmarshalConfig(String configFileURI, PlasmaConfigDataBinding binding) {
        try {
            File urlFile;
            try {
                this.configURI = new URI(configFileURI);
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            InputStream stream = null;
            if (this.configURI == null || this.configURI.getScheme() == null) {
                stream = PlasmaConfig.class.getResourceAsStream(configFileURI);
                if (stream == null) {
                    stream = PlasmaConfig.class.getClassLoader().getResourceAsStream(configFileURI);
                }
                if (stream == null) {
                    throw new ConfigurationException("could not find configuration file resource '" + configFileURI + "' on the current classpath");
                }
            } else {
                try {
                    stream = this.configURI.toURL().openStream();
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException(e);
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
                if (stream == null) {
                    throw new ConfigurationException("could not open stream for configuration file resource '" + configFileURI + "'");
                }
            }
            PlasmaConfiguration result = (PlasmaConfiguration)binding.validate(stream);
            URL url = PlasmaConfig.class.getResource(configFileURI);
            if (url == null) {
                url = PlasmaConfig.class.getClassLoader().getResource(configFileURI);
            }
            if (url != null && (urlFile = new File(url.getFile())).exists()) {
                this.configFileLastModifiedDate = urlFile.lastModified();
            }
            return result;
        }
        catch (UnmarshalException e) {
            throw new ConfigurationException(e);
        }
        catch (JAXBException e) {
            throw new ConfigurationException(e);
        }
    }

    public void marshal(OutputStream stream) {
        try {
            PlasmaConfigDataBinding configBinding = new PlasmaConfigDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            configBinding.marshal(this.config, stream);
        }
        catch (JAXBException e1) {
            throw new ConfigurationException(e1);
        }
        catch (SAXException e1) {
            throw new ConfigurationException(e1);
        }
    }

    public static PlasmaConfig getInstance() throws PlasmaRuntimeException {
        if (instance == null) {
            PlasmaConfig.initializeInstance();
        }
        return instance;
    }

    private static synchronized void initializeInstance() throws PlasmaRuntimeException {
        if (instance == null) {
            instance = new PlasmaConfig();
        }
    }

    public PlasmaConfiguration getConfig() {
        return this.config;
    }

    public SDO getSDO() {
        return this.config.getSDO();
    }

    public Namespace getSDONamespaceByURI(String uri) {
        NamespaceAdapter result = this.sdoNamespaceMap.get(uri);
        if (result != null) {
            return result.getNamespace();
        }
        throw new ConfigurationException("no configured SDO namespace found for URI '" + uri + "'");
    }

    public Namespace getSDONamespaceByInterfacePackage(String packageName) {
        NamespaceAdapter result = this.sdoNamespaceMap.get(packageName);
        if (result != null) {
            return result.getNamespace();
        }
        throw new ConfigurationException("no configured SDO namespace found for interface package name '" + packageName + "'");
    }

    public TypeBindingAdapter findTypeBinding(String uri, String typeName) {
        NamespaceAdapter namespaceAdapter = this.sdoNamespaceMap.get(uri);
        if (namespaceAdapter != null) {
            TypeBindingAdapter resultAdapter = namespaceAdapter.findTypeBinding(typeName);
            if (resultAdapter != null) {
                return resultAdapter;
            }
            return null;
        }
        throw new ConfigurationException("no configured SDO namespace found for URI '" + uri + "'");
    }

    public void remapTypeBinding(String uri, TypeBindingAdapter typeBinding) {
        NamespaceAdapter namespaceAdapter = this.sdoNamespaceMap.get(uri);
        if (namespaceAdapter == null) {
            throw new ConfigurationException("no configured SDO namespace found for URI '" + uri + "'");
        }
        namespaceAdapter.remapTypeBinding(typeBinding);
    }

    public PropertyBindingAdapter findPropertyBinding(String uri, String typeName, String propertyName) {
        NamespaceAdapter namespaceAdapter = this.sdoNamespaceMap.get(uri);
        if (namespaceAdapter != null) {
            TypeBindingAdapter typeBinding = namespaceAdapter.findTypeBinding(typeName);
            if (typeBinding != null) {
                PropertyBindingAdapter resultAdapter = typeBinding.findPropertyBinding(propertyName);
                if (resultAdapter != null) {
                    return resultAdapter;
                }
                return null;
            }
            return null;
        }
        throw new ConfigurationException("no configured SDO namespace found for URI '" + uri + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDynamicSDONamespace(String uri, String supplierUri) {
        Namespace namespace = new Namespace();
        namespace.setArtifact(uri);
        namespace.setUri(uri);
        if (this.sdoNamespaceMap.get(namespace.getUri()) != null) {
            throw new ConfigurationException("duplicate SDO namespace configuration - a namespace with URI '" + namespace.getUri() + "' already exists " + "within the configuration");
        }
        this.lock.writeLock().lock();
        try {
            this.sdoNamespaceMap.put(uri, new NamespaceAdapter(namespace));
            for (Map<String, NamespaceProvisioning> map : this.dataAccessProviderProvisioningMap.values()) {
                Iterator<String> iter = map.keySet().iterator();
                NamespaceProvisioning provisioning = null;
                while (iter.hasNext()) {
                    String key = iter.next();
                    if (!key.equals(supplierUri)) continue;
                    provisioning = map.get(key);
                }
                if (provisioning == null) continue;
                map.put(uri, provisioning);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Namespace addDynamicSDONamespace(String uri, String artifact, NamespaceProvisioning provisioning) {
        Namespace namespace = new Namespace();
        namespace.setArtifact(artifact);
        namespace.setUri(uri);
        namespace.setProvisioning(provisioning);
        if (this.sdoNamespaceMap.get(namespace.getUri()) != null) {
            throw new ConfigurationException("duplicate SDO namespace configuration - a namespace with URI '" + namespace.getUri() + "' already exists " + "within the configuration");
        }
        this.lock.writeLock().lock();
        try {
            this.sdoNamespaceMap.put(uri, new NamespaceAdapter(namespace));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return namespace;
    }

    public DataAccessProvider findDataAccessProvider(DataAccessProviderName providerName) {
        DataAccessProvider result = this.dataAccessProviderMap.get((Object)providerName);
        return result;
    }

    public DataAccessProvider getDataAccessProvider(DataAccessProviderName providerName) {
        DataAccessProvider result = this.dataAccessProviderMap.get((Object)providerName);
        if (result != null) {
            return result;
        }
        throw new ConfigurationException("no data access provider configuration found for '" + providerName.value() + "'");
    }

    public Property findProviderProperty(DataAccessProvider provider, String name) {
        for (Property property : provider.getProperties()) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public RDBMSVendorName getRDBMSProviderVendor(DataAccessProviderName providerName) {
        DataAccessProvider provider = this.dataAccessProviderMap.get((Object)providerName);
        if (provider == null) {
            throw new ConfigurationException("no data access provider configuration found for '" + providerName.value() + "'");
        }
        RDBMSVendorName vendor = null;
        switch (providerName) {
            case JDBC: 
            case JDO: 
            case JPA: {
                Property vendorProp = this.findProviderPropertyByName(provider, "org.plasma.sdo.access.provider.jdbc.Vendor");
                if (vendorProp != null) {
                    vendor = this.getVendorName(provider, vendorProp);
                    break;
                }
                log.debug((Object)("no vendor property (org.plasma.sdo.access.provider.jdbc.Vendor) found for provider '" + providerName.value() + "'- searching for vendor based on JDBC driver name"));
                Property driverProp = this.findProviderPropertyByName(provider, "org.plasma.sdo.access.provider.jdbc.ConnectionDriverName");
                if (driverProp != null) {
                    vendor = this.matchVendorName(driverProp);
                }
                if (vendor != null) break;
                throw new ConfigurationException("could not determine RDBMS vendor for provider '" + providerName.value() + "' - no vendor property (" + "org.plasma.sdo.access.provider.jdbc.Vendor" + ")" + " or driver (" + "org.plasma.sdo.access.provider.jdbc.ConnectionDriverName" + ") properties found");
            }
            default: {
                throw new ConfigurationException("could not determine RDBMS vendor for non-RDBMS provider '" + providerName.value() + "'");
            }
        }
        return vendor;
    }

    private RDBMSVendorName getVendorName(DataAccessProvider provider, Property prop) {
        try {
            return RDBMSVendorName.valueOf(prop.getValue());
        }
        catch (IllegalArgumentException e) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < RDBMSVendorName.values().length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(RDBMSVendorName.values()[i].name());
            }
            throw new ConfigurationException("could not determine RDBMS vendor for provider '" + provider.getName().value() + "' based on property value '" + prop.getValue() + "' - expected one of [" + buf.toString() + "]");
        }
    }

    private RDBMSVendorName matchVendorName(Property prop) {
        for (RDBMSVendorName vendor : RDBMSVendorName.values()) {
            if (!prop.getValue().toLowerCase().contains(vendor.name().toLowerCase())) continue;
            return vendor;
        }
        return null;
    }

    private Property findProviderPropertyContainingValue(DataAccessProvider provider, String value) {
        for (Property prop : provider.getProperties()) {
            if (prop.getValue() == null || !prop.getValue().toLowerCase().contains(value)) continue;
            return prop;
        }
        return null;
    }

    private Property findProviderPropertyByName(DataAccessProvider provider, String name) {
        Map<String, Property> propertyMap = this.dataAccessProviderPropertyMap.get((Object)provider.getName());
        if (propertyMap != null) {
            return propertyMap.get(name);
        }
        return null;
    }

    public NamespaceProvisioning getProvisioningByNamespaceURI(DataAccessProviderName providerName, String uri) {
        NamespaceProvisioning result;
        Map<String, NamespaceProvisioning> providerProvisionMap = this.dataAccessProviderProvisioningMap.get((Object)providerName);
        if (providerProvisionMap != null && (result = providerProvisionMap.get(uri)) != null) {
            return result;
        }
        throw new NonExistantNamespaceException("no configured '" + providerName.value() + "' provider namespace found for URI '" + uri + "'");
    }

    public boolean hasNamespace(DataStoreType dataStore) {
        return this.dataStoreNamespaceLinkMap.get((Object)dataStore) != null;
    }

    public Repository getRepository() {
        return this.config.getRepository();
    }

    public String getSDOInterfaceClassName(String uri, String name) {
        String result = name;
        Namespace namespace = this.getSDONamespaceByURI(uri);
        return result;
    }

    public String getSDOInterfacePackageName(String uri) {
        Namespace sdoNamespace = this.getSDONamespaceByURI(uri);
        String packageName = sdoNamespace.getProvisioning().getPackageName();
        return packageName;
    }

    public String getSDOImplementationClassName(String uri, String name) {
        String result = name;
        Namespace namespace = this.getSDONamespaceByURI(uri);
        if (namespace != null) {
            String prefix = null;
            String suffix = null;
            if (this.getSDO() != null && this.getSDO().getGlobalProvisioning() != null && this.getSDO().getGlobalProvisioning().getImplementation() != null) {
                ImplementationProvisioning prov = this.getSDO().getGlobalProvisioning().getImplementation();
                prefix = prov.getClassNamePrefix();
                suffix = prov.getClassNameSuffix();
            }
            if (prefix != null && prefix.trim().length() > 0) {
                result = prefix + result;
            }
            if (suffix != null && suffix.trim().length() > 0) {
                result = result + suffix;
            }
            return result;
        }
        return null;
    }

    public String getSDOImplementationPackageName(String uri) {
        Namespace sdoNamespace = this.getSDONamespaceByURI(uri);
        if (sdoNamespace != null && sdoNamespace.getProvisioning() != null) {
            String packageName = sdoNamespace.getProvisioning().getPackageName();
            String subpackage = null;
            if (this.getSDO() != null && this.getSDO().getGlobalProvisioning() != null && this.getSDO().getGlobalProvisioning().getImplementation() != null) {
                ImplementationProvisioning prov = this.getSDO().getGlobalProvisioning().getImplementation();
                subpackage = prov.getChildPackageName();
            }
            if (subpackage != null && subpackage.trim().length() > 0) {
                packageName = packageName + "." + subpackage;
            }
            return packageName;
        }
        return null;
    }

    public boolean generateQueryDSL(String uri, String name) {
        Namespace namespace = this.getSDONamespaceByURI(uri);
        if (this.getSDO() != null && this.getSDO().getGlobalProvisioning() != null && this.getSDO().getGlobalProvisioning().getQueryDSL() != null) {
            QueryDSLProvisioning queryDsl = this.getSDO().getGlobalProvisioning().getQueryDSL();
            if (!queryDsl.isGenerate()) {
                return false;
            }
            NamespaceProvisioning prov = namespace.getProvisioning();
            if (prov != null && prov.getQueryDSL() != null && !prov.getQueryDSL().isGenerate()) {
                return false;
            }
        }
        return true;
    }

    public String getQueryDSLImplementationClassName(String uri, String name) {
        String result = name;
        Namespace namespace = this.getSDONamespaceByURI(uri);
        if (namespace != null) {
            QueryDSLProvisioning queryDsl;
            String prefix = null;
            String suffix = null;
            if (this.getSDO() != null && this.getSDO().getGlobalProvisioning() != null && this.getSDO().getGlobalProvisioning().getQueryDSL() != null && (queryDsl = this.getSDO().getGlobalProvisioning().getQueryDSL()).getImplementation() != null) {
                ImplementationProvisioning prov = queryDsl.getImplementation();
                prefix = prov.getClassNamePrefix();
                suffix = prov.getClassNameSuffix();
            }
            if (prefix != null && prefix.trim().length() > 0) {
                result = prefix + result;
            }
            if (suffix != null && suffix.trim().length() > 0) {
                result = result + suffix;
            }
            return result;
        }
        return null;
    }

    public String getServiceImplementationClassName(DataAccessProviderName providerName, String uri, String name) {
        String result = name;
        DataAccessProvider config = this.getDataAccessProvider(providerName);
        Namespace namespace = this.getSDONamespaceByURI(uri);
        return result;
    }

    public String getServiceImplementationPackageName(DataAccessProviderName serviceName, String uri) {
        NamespaceProvisioning provisioning = this.getProvisioningByNamespaceURI(serviceName, uri);
        Namespace namespace = this.getSDONamespaceByURI(uri);
        return provisioning.getPackageName();
    }
}

