/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.config.adapter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.plasma.config.ConfigurationException;
import org.plasma.config.PropertyBinding;
import org.plasma.config.TypeBinding;
import org.plasma.config.adapter.NamespaceAdapter;
import org.plasma.config.adapter.PropertyBindingAdapter;

public class TypeBindingAdapter {
    private NamespaceAdapter namespace;
    private TypeBinding binding;
    private Map<String, PropertyBindingAdapter> propertyBindings;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private TypeBindingAdapter() {
    }

    public TypeBindingAdapter(NamespaceAdapter namespace, TypeBinding binding) {
        this.namespace = namespace;
        this.binding = binding;
        for (PropertyBinding propertyBinding : binding.getPropertyBindings()) {
            this.addPropertyBinding(propertyBinding);
        }
    }

    protected TypeBinding getBinding() {
        return this.binding;
    }

    public String getLogicalName() {
        return this.binding.getLogicalName();
    }

    public List<PropertyBinding> getPropertyBindings() {
        return this.binding.getPropertyBindings();
    }

    public String getPhysicalName() {
        return this.binding.getPhysicalName();
    }

    public String getLocalName() {
        return this.binding.getLocalName();
    }

    public String getType() {
        return this.binding.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyBinding(PropertyBinding propertyBinding) {
        if (this.propertyBindings != null && this.propertyBindings.get(propertyBinding.getProperty()) != null) {
            throw new ConfigurationException("duplicate type binding - a type binding for type '" + propertyBinding.getProperty() + "' already exists " + "within the configucation for namespace, " + this.namespace.getNamespace().getUri());
        }
        if (this.propertyBindings == null) {
            this.propertyBindings = new HashMap<String, PropertyBindingAdapter>();
        }
        this.lock.writeLock().lock();
        try {
            this.propertyBindings.put(propertyBinding.getProperty(), new PropertyBindingAdapter(propertyBinding));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public PropertyBindingAdapter findPropertyBinding(String propertyName) {
        if (this.propertyBindings != null) {
            PropertyBindingAdapter adapter = this.propertyBindings.get(propertyName);
            if (adapter != null) {
                return adapter;
            }
            return null;
        }
        return null;
    }
}

