/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.profile;

import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.config.ConfigurationException;

public class ProfileConfigValidationEventHandler
implements BindingValidationEventHandler {
    private static Log log = LogFactory.getLog(ProfileConfigValidationEventHandler.class);
    private int errorCount;
    private boolean cumulative = true;

    public int getErrorCount() {
        return this.errorCount;
    }

    public ProfileConfigValidationEventHandler() {
    }

    public ProfileConfigValidationEventHandler(boolean cumulative) {
        this.cumulative = cumulative;
    }

    public boolean handleEvent(ValidationEvent ve) {
        boolean result = this.cumulative;
        ++this.errorCount;
        ValidationEventLocator vel = ve.getLocator();
        String message = "Line:Col:Offset[" + vel.getLineNumber() + ":" + vel.getColumnNumber() + ":" + String.valueOf(vel.getOffset()) + "] - " + ve.getMessage();
        switch (ve.getSeverity()) {
            case 0: {
                log.warn((Object)message);
                break;
            }
            case 1: 
            case 2: {
                log.fatal((Object)message);
                throw new ConfigurationException(message);
            }
            default: {
                log.error((Object)message);
            }
        }
        return result;
    }

    public void reset() {
        this.errorCount = 0;
    }
}

