/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javanet.staxutils.events.EventAllocator;
import javanet.staxutils.events.NamespaceEvent;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.config.ConfigurationException;
import org.plasma.config.ProfileVersionDetectionException;
import org.plasma.profile.ProfileConfig;
import org.plasma.profile.ProfileURN;
import org.plasma.profile.adapter.ProfileArtifactAdapter;

public class ProfileVersionFinder {
    private static Log log = LogFactory.getLog(ProfileVersionFinder.class);
    public static final String ELEM_XMI = "XMI";
    public static final String ATTR_OPF_VERSION = "";
    private XMLEventAllocator allocator = null;
    private XMLInputFactory factory;
    private String currentNamespaceUri = null;
    private boolean abort = false;
    private ProfileArtifactAdapter result;

    public ProfileArtifactAdapter getVersion(String artifactURN, InputStream stream) {
        try {
            this.setup();
            this.read(stream);
        }
        catch (XMLStreamException e) {
            throw new ConfigurationException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.result == null) {
            StringBuilder buf = new StringBuilder();
            ProfileURN[] v = ProfileURN.values();
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(v[i].value());
            }
            throw new ProfileVersionDetectionException("no profile version detected for artifact '" + artifactURN + "' - all UML artifacts are required to be annotated with one of the following versions " + "of the PlasmaSDO UML Profile [" + buf.toString() + "]");
        }
        return this.result;
    }

    private void read(InputStream stream) throws XMLStreamException {
        XMLStreamReader streamReader = this.factory.createXMLStreamReader(stream);
        block5: while (streamReader.hasNext() && !this.abort) {
            int eventType = streamReader.next();
            XMLEvent event = this.allocateXMLEvent(streamReader);
            block0 : switch (eventType) {
                case 1: {
                    StartElement start = event.asStartElement();
                    QName name = start.getName();
                    String uri = name.getNamespaceURI();
                    if (uri != null && uri.trim().length() > 0) {
                        this.currentNamespaceUri = uri.trim();
                    }
                    if (!this.isRoot(name)) break;
                    Iterator<Namespace> iter = start.getNamespaces();
                    while (iter.hasNext()) {
                        NamespaceEvent namespaceEvent = (NamespaceEvent)iter.next();
                        String value = namespaceEvent.getValue();
                        ProfileArtifactAdapter version = this.findVersion(value);
                        if (version == null) continue;
                        this.result = version;
                        this.abort = true;
                        break block0;
                    }
                    continue block5;
                }
                case 2: {
                    QName name = event.asEndElement().getName();
                    String uri = name.getNamespaceURI();
                    break;
                }
                case 4: {
                    String data = event.asCharacters().getData();
                    if (data == null || data.trim().length() == 0 || !(data = data.trim()).contains(">")) break;
                    Location loc = event.getLocation();
                    String msg = "line:col[" + loc.getLineNumber() + ":" + loc.getColumnNumber() + "]";
                    msg = msg + " - document is not well-formed";
                    throw new XMLStreamException(msg);
                }
            }
        }
    }

    private boolean isRoot(QName name) {
        return ELEM_XMI.equals(name.getLocalPart());
    }

    private ProfileArtifactAdapter findVersion(String value) {
        return ProfileConfig.getInstance().findArtifactByUri(value);
    }

    private void setup() {
        this.factory = XMLInputFactory.newInstance();
        this.factory.setXMLResolver(new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                log.info((Object)("resolve: " + publicID + ":" + systemID + ":" + baseURI + ":" + namespace));
                return null;
            }
        });
        this.factory.setEventAllocator((XMLEventAllocator)new EventAllocator());
        this.factory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.allocator = this.factory.getEventAllocator();
    }

    private XMLEvent allocateXMLEvent(XMLStreamReader reader) throws XMLStreamException {
        return this.allocator.allocate(reader);
    }

    private void logEventInfo(XMLEvent event) {
        if (log.isDebugEnabled()) {
            Location loc = event.getLocation();
            String msg = ProfileVersionFinder.getEventTypeString(event.getEventType());
            msg = msg + " line:col[" + loc.getLineNumber() + ":" + loc.getColumnNumber() + "] - ";
            msg = msg + event.toString();
            log.debug((Object)msg);
        }
    }

    public static final String getEventTypeString(int eventType) {
        switch (eventType) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
            case 6: {
                return "SPACE";
            }
        }
        return "UNKNOWN_EVENT_TYPE , " + eventType;
    }
}

