/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.config.adapter;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.plasma.config.ConfigurationException;
import org.plasma.config.Namespace;
import org.plasma.config.NamespaceProvisioning;
import org.plasma.config.Property;
import org.plasma.config.TypeBinding;
import org.plasma.config.adapter.TypeBindingAdapter;

public class NamespaceAdapter {
    private Namespace namespace;
    private Map<String, TypeBindingAdapter> typeBindings;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean systemArtifact = false;

    private NamespaceAdapter() {
    }

    public NamespaceAdapter(Namespace namespace) {
        this.namespace = namespace;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.namespace.getProperties());
    }

    public NamespaceProvisioning getProvisioning() {
        return this.namespace.getProvisioning();
    }

    public List<TypeBinding> getTypeBindings() {
        return Collections.unmodifiableList(this.namespace.getTypeBindings());
    }

    public String getUri() {
        return this.namespace.getUri();
    }

    public String getArtifact() {
        return this.namespace.getArtifact();
    }

    public boolean isSystemArtifact() {
        return this.systemArtifact;
    }

    public void setSystemArtifact(boolean systemArtifact) {
        this.systemArtifact = systemArtifact;
    }

    public void addTypeBinding(TypeBinding typeBinding) {
        if (this.typeBindings != null && this.typeBindings.get(typeBinding.getType()) != null) {
            throw new ConfigurationException("duplicate type binding - a type binding for type '" + typeBinding.getType() + "' already exists " + "within the configucation for namespace with URI, " + this.namespace.getUri());
        }
        if (this.typeBindings == null) {
            this.typeBindings = new HashMap<String, TypeBindingAdapter>();
        }
        this.lock.writeLock().lock();
        try {
            this.typeBindings.put(typeBinding.getType(), new TypeBindingAdapter(this, typeBinding));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void remapTypeBinding(TypeBindingAdapter typeBinding) {
        TypeBindingAdapter existing;
        if (typeBinding.getLogicalName() == null) {
            throw new ConfigurationException("cloud not remap type binding for type '" + typeBinding.getType() + "' with no logical name");
        }
        if (this.typeBindings != null && this.typeBindings.get(typeBinding.getLogicalName()) != null) {
            throw new ConfigurationException("duplicate type binding - a type binding for type '" + typeBinding.getLogicalName() + "' already exists " + "within the configucation for namespace with URI, " + this.namespace.getUri());
        }
        if (this.typeBindings == null) {
            this.typeBindings = new HashMap<String, TypeBindingAdapter>();
        }
        if ((existing = this.typeBindings.remove(typeBinding.getType())) == null) {
            throw new ConfigurationException("missing type binding - no type binding for type '" + typeBinding.getType() + "' exists " + "within the configucation for namespace with URI, " + this.namespace.getUri());
        }
        this.lock.writeLock().lock();
        try {
            this.typeBindings.put(typeBinding.getLogicalName(), existing);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public TypeBindingAdapter findTypeBinding(String typeName) {
        if (this.typeBindings != null) {
            TypeBindingAdapter adapter = this.typeBindings.get(typeName);
            if (adapter != null) {
                return adapter;
            }
            return null;
        }
        return null;
    }
}

