/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.profile;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.common.exception.PlasmaRuntimeException;
import org.plasma.config.ConfigurationException;
import org.plasma.profile.ProfileArtifact;
import org.plasma.profile.ProfileConfigDataBinding;
import org.plasma.profile.ProfileConfigValidationEventHandler;
import org.plasma.profile.ProfileConfiguration;
import org.plasma.profile.ProfileURN;
import org.plasma.profile.adapter.ProfileArtifactAdapter;
import org.xml.sax.SAXException;

public class ProfileConfig {
    private static Log log = LogFactory.getLog(ProfileConfig.class);
    private static volatile ProfileConfig instance = null;
    private static final String defaultConfigFileName = "profile-config.xml";
    private String configFileName;
    private long configFileLastModifiedDate = System.currentTimeMillis();
    private ProfileConfiguration config;
    private Map<ProfileURN, ProfileArtifactAdapter> artifactURNMap = new HashMap<ProfileURN, ProfileArtifactAdapter>();
    private Map<String, ProfileArtifactAdapter> artifactURIMap = new HashMap<String, ProfileArtifactAdapter>();

    private ProfileConfig() {
        log.debug((Object)"initializing...");
        try {
            this.configFileName = defaultConfigFileName;
            ProfileConfigDataBinding configBinding = new ProfileConfigDataBinding(new ProfileConfigValidationEventHandler());
            this.config = this.unmarshalConfig(this.configFileName, configBinding);
            for (ProfileArtifact artifact : this.config.getArtifacts()) {
                this.artifactURNMap.put(artifact.getUrn(), new ProfileArtifactAdapter(artifact));
                this.artifactURIMap.put(artifact.getNamespaceUri(), new ProfileArtifactAdapter(artifact));
            }
        }
        catch (SAXException e) {
            throw new ConfigurationException(e);
        }
        catch (JAXBException e) {
            throw new ConfigurationException(e);
        }
    }

    public ProfileArtifactAdapter findArtifactByUrn(ProfileURN urn) {
        return this.artifactURNMap.get((Object)urn);
    }

    public ProfileArtifactAdapter findArtifactByUri(String namespaceUri) {
        return this.artifactURIMap.get(namespaceUri);
    }

    public Collection<ProfileArtifactAdapter> getArtifacts() {
        return Collections.unmodifiableCollection(this.artifactURNMap.values());
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public long getConfigFileLastModifiedDate() {
        return this.configFileLastModifiedDate;
    }

    private ProfileConfiguration unmarshalConfig(String configFileName, ProfileConfigDataBinding binding) {
        try {
            File urlFile;
            InputStream stream = ProfileConfig.class.getResourceAsStream(configFileName);
            if (stream == null) {
                stream = ProfileConfig.class.getClassLoader().getResourceAsStream(configFileName);
            }
            if (stream == null) {
                throw new ConfigurationException("could not find configuration file resource '" + configFileName + "' on the current classpath");
            }
            ProfileConfiguration result = (ProfileConfiguration)binding.validate(stream);
            URL url = ProfileConfig.class.getResource(configFileName);
            if (url == null) {
                url = ProfileConfig.class.getClassLoader().getResource(configFileName);
            }
            if (url != null && (urlFile = new File(url.getFile())).exists()) {
                this.configFileLastModifiedDate = urlFile.lastModified();
            }
            return result;
        }
        catch (UnmarshalException e) {
            throw new ConfigurationException(e);
        }
        catch (JAXBException e) {
            throw new ConfigurationException(e);
        }
    }

    public void marshal(OutputStream stream) {
        try {
            ProfileConfigDataBinding configBinding = new ProfileConfigDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            configBinding.marshal(this.config, stream);
        }
        catch (JAXBException e1) {
            throw new ConfigurationException(e1);
        }
        catch (SAXException e1) {
            throw new ConfigurationException(e1);
        }
    }

    public static ProfileConfig getInstance() throws PlasmaRuntimeException {
        if (instance == null) {
            ProfileConfig.initializeInstance();
        }
        return instance;
    }

    private static synchronized void initializeInstance() throws ConfigurationException {
        if (instance == null) {
            instance = new ProfileConfig();
        }
    }

    public ProfileConfiguration getConfig() {
        return this.config;
    }
}

