/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.model;

import java.util.HashSet;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.plasma.sdo.DataType;

@XmlType(name="FunctionName")
@XmlEnum
public enum FunctionName {
    AVG("avg"),
    COUNT("count"),
    MAX("max"),
    MIN("min"),
    SDTDEV("sdtdev"),
    SUM("sum"),
    VAR("var"),
    CAST("cast"),
    CONVERT("convert"),
    ABS("abs"),
    ACOS("acos"),
    ASIN("asin"),
    ATAN("atan"),
    CEILING("ceiling"),
    COS("cos"),
    COT("cot"),
    EXP("exp"),
    FLOOR("floor"),
    LOG("log"),
    LOG_10("log10"),
    PI("pi"),
    POW("pow"),
    ROUND("round"),
    SIN("sin"),
    SQRT("sqrt"),
    SQUARE("square"),
    TAN("tan"),
    META_COL_PRECISION("meta_col_precision"),
    META_COL_SCALE("meta_col_scale"),
    META_NAME("meta_name"),
    META_PHYSICAL_NAME("meta_physical_name"),
    META_BUSINESS_NAME("meta_business_name"),
    META_LOCAL_NAME("meta_local_name"),
    RANK("rank"),
    ROW_NUMBER("row_number"),
    USER("user"),
    SUBSTRING_BEFORE("substringBefore"),
    SUBSTRING_AFTER("substringAfter"),
    NORMALIZE_SPACE("normalizeSpace"),
    UPPER_CASE("upperCase"),
    LOWER_CASE("lowerCase"),
    YEAR_FROM_DATE("yearFromDate"),
    MONTH_FROM_DATE("monthFromDate"),
    DAY_FROM_DATE("dayFromDate"),
    TIMEZONE_FROM_DATE("timezoneFromDate"),
    OFFSETS("offsets"),
    RELEVANCE("relevance"),
    SCORE("score"),
    TERMS("terms"),
    NGRAMS("ngrams"),
    PROXIMITY("proximity"),
    WEIGHT("weight");

    private final String value;
    private static HashSet<String> names;

    private FunctionName(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static FunctionName fromValue(String v) {
        for (FunctionName c : FunctionName.values()) {
            if (!c.value.equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }

    public boolean isAggreate() {
        switch (this) {
            case AVG: 
            case COUNT: 
            case MAX: 
            case MIN: 
            case SUM: {
                return true;
            }
        }
        return false;
    }

    public boolean isFullText() {
        switch (this) {
            case NGRAMS: 
            case OFFSETS: 
            case PROXIMITY: 
            case RANK: 
            case RELEVANCE: 
            case SCORE: 
            case TERMS: 
            case WEIGHT: {
                return true;
            }
        }
        return false;
    }

    public DataType getScalarDatatype(DataType sourceDataType) {
        switch (this) {
            case COUNT: {
                return DataType.Long;
            }
            case AVG: {
                switch (sourceDataType) {
                    case Float: 
                    case Int: 
                    case Short: {
                        return DataType.Float;
                    }
                    case Double: 
                    case Integer: 
                    case Long: 
                    case UnsignedInt: 
                    case UnsignedLong: {
                        return DataType.Double;
                    }
                }
                throw new IllegalArgumentException("illegal datatype (" + sourceDataType + ") conversion for function, " + (Object)((Object)this));
            }
            case SUM: {
                switch (sourceDataType) {
                    case Float: 
                    case Double: {
                        return DataType.Double;
                    }
                    case Int: 
                    case Short: 
                    case Integer: 
                    case Long: 
                    case UnsignedInt: 
                    case UnsignedLong: {
                        return DataType.Long;
                    }
                }
                throw new IllegalArgumentException("illegal datatype (" + sourceDataType + ") conversion for function, " + (Object)((Object)this));
            }
            case MAX: 
            case MIN: {
                switch (sourceDataType) {
                    case Float: 
                    case Int: 
                    case Short: 
                    case Double: 
                    case Integer: 
                    case Long: 
                    case UnsignedInt: 
                    case UnsignedLong: {
                        return sourceDataType;
                    }
                }
                throw new IllegalArgumentException("illegal datatype (" + sourceDataType + ") conversion for function, " + (Object)((Object)this));
            }
            case NGRAMS: 
            case OFFSETS: 
            case PROXIMITY: 
            case RANK: 
            case RELEVANCE: 
            case SCORE: 
            case TERMS: 
            case WEIGHT: {
                switch (sourceDataType) {
                    case String: {
                        return sourceDataType;
                    }
                }
                throw new IllegalArgumentException("illegal datatype (" + sourceDataType + ") conversion for function, " + (Object)((Object)this));
            }
        }
        return sourceDataType;
    }

    public static boolean hasName(String name) {
        return names.contains(name);
    }

    static {
        names = new HashSet();
        for (FunctionName name : FunctionName.values()) {
            names.add(name.name());
        }
    }
}

