/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.model;

import commonj.sdo.Type;
import org.plasma.query.EmptySelectClauseException;
import org.plasma.query.InvalidPathElementException;
import org.plasma.query.QueryException;
import org.plasma.query.model.AbstractPathElement;
import org.plasma.query.model.AbstractQueryValidator;
import org.plasma.query.model.Expression;
import org.plasma.query.model.From;
import org.plasma.query.model.Literal;
import org.plasma.query.model.Path;
import org.plasma.query.model.PathElement;
import org.plasma.query.model.PathNode;
import org.plasma.query.model.PredicateOperator;
import org.plasma.query.model.Property;
import org.plasma.query.model.Query;
import org.plasma.query.model.QueryConstants;
import org.plasma.query.model.Select;
import org.plasma.query.model.Term;
import org.plasma.query.model.Where;
import org.plasma.runtime.PlasmaRuntime;
import org.plasma.sdo.helper.PlasmaTypeHelper;

public class QueryValidator
extends AbstractQueryValidator
implements QueryConstants {
    private Type rootType;
    private Type contextType;

    private QueryValidator() {
    }

    public QueryValidator(Query query, Type contextType) {
        this.rootType = contextType;
        this.contextType = contextType;
        query.accept(this);
    }

    public QueryValidator(Where where, Type contextType) {
        this.rootType = contextType;
        this.contextType = contextType;
        where.accept(this);
    }

    @Override
    public void start(Select select) {
        if (select.getProperties().size() == 0) {
            throw new EmptySelectClauseException("Select clause has no properties");
        }
        super.start(select);
    }

    public void start(From from) {
        Type type = PlasmaTypeHelper.INSTANCE.getType(from.getEntity().getNamespaceURI(), from.getEntity().getName());
        try {
            String pkgName = PlasmaRuntime.getInstance().getSDONamespaceByURI(type.getURI()).getProvisioning().getPackageName();
            Class.forName(pkgName + "." + type.getName());
        }
        catch (ClassNotFoundException e) {
            throw new QueryException(e);
        }
        super.start(from);
    }

    @Override
    public void start(Expression expression) {
        for (int i = 0; i < expression.getTerms().size(); ++i) {
            PredicateOperator oper = expression.getTerms().get(i).getPredicateOperator();
            if (oper == null) continue;
            if (i == 0) {
                throw new QueryException("did not expect WildcardOperator as first term in expression");
            }
            Term t = expression.getTerms().get(i - 1);
            if (t.getProperty() == null) {
                throw new QueryException("expected Property before WildcardOperator in expression");
            }
            t = expression.getTerms().get(i + 1);
            if (t.getLiteral() != null) continue;
            throw new QueryException("expected Literal after WildcardOperator in expression");
        }
        super.start(expression);
    }

    @Override
    public void start(Property property) {
        commonj.sdo.Property endpoint;
        if (property.getPath() != null) {
            try {
                Path path = property.getPath();
                for (int i = 0; i < path.getPathNodes().size(); ++i) {
                    PathNode node = path.getPathNodes().get(i);
                    AbstractPathElement elem = node.getPathElement();
                    if (elem instanceof PathElement) {
                        commonj.sdo.Property prop = this.contextType.getProperty(((PathElement)elem).getValue());
                        if (prop.getType().isDataType()) {
                            throw new InvalidPathElementException("expected reference property as path element");
                        }
                        this.contextType = prop.getType();
                    }
                    if (node.getWhere() == null) continue;
                    new QueryValidator(node.getWhere(), this.contextType);
                }
            }
            catch (QueryException e) {
                throw new InvalidPathElementException((Throwable)((Object)e));
            }
        }
        if (!"*".equals(property.getName()) && (endpoint = this.contextType.getProperty(property.getName())).isMany()) {
            throw new QueryException("expected singular property as endpoint, not '" + endpoint.getName() + "'");
        }
        this.contextType = this.rootType;
        super.start(property);
    }

    @Override
    public void start(Literal literal) {
        if (literal.getValue() == null) {
            throw new QueryException("found null content for literal");
        }
        super.start(literal);
    }
}

