/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.repository.fuml;

import java.util.ArrayList;
import java.util.List;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.repository.NamedElement;
import org.modeldriven.fuml.repository.Package;
import org.modeldriven.fuml.repository.Stereotype;
import org.plasma.sdo.Alias;
import org.plasma.sdo.profile.SDOAlias;
import org.plasma.sdo.profile.SDONamespace;
import org.plasma.sdo.repository.Comment;
import org.plasma.sdo.repository.Element;
import org.plasma.sdo.repository.RepositoryException;
import org.plasma.sdo.repository.fuml.FumlComment;
import org.plasma.sdo.repository.fuml.FumlRepository;

class FumlElement<T extends NamedElement>
implements Element {
    protected T element;

    protected FumlElement(T delegate) {
        this.element = delegate;
        if (this.element == null) {
            throw new IllegalArgumentException("element cannot be null");
        }
    }

    public T getDelegate() {
        return this.element;
    }

    @Override
    public String getName() {
        return this.element.getName();
    }

    @Override
    public String getId() {
        return this.element.getDelegate().getXmiId();
    }

    protected String getNamespaceURI(Classifier classifier) {
        Package p = classifier.getPackage();
        String uri = this.findSDONamespaceURI(p);
        if (uri == null) {
            throw new RepositoryException("no SDO Namespace uri found for classifier, '" + classifier.getName() + "'");
        }
        return uri;
    }

    private String findSDONamespaceURI(Package pkg) {
        SDONamespace sdoNamespaceStereotype = this.findSDONamespace(pkg);
        if (sdoNamespaceStereotype != null) {
            return sdoNamespaceStereotype.getUri();
        }
        if (pkg.getNestingPackage() != null) {
            return this.findSDONamespaceURI(pkg.getNestingPackage());
        }
        return null;
    }

    private SDONamespace findSDONamespace(Package pkg) {
        List<Stereotype> stereotypes = FumlRepository.getFumlRepositoryInstance().getStereotypes((org.modeldriven.fuml.repository.Element)pkg);
        if (stereotypes != null) {
            for (Stereotype stereotype : stereotypes) {
                if (!(stereotype.getDelegate() instanceof SDONamespace)) continue;
                return (SDONamespace)stereotype.getDelegate();
            }
        }
        return null;
    }

    @Override
    public String getPhysicalName() {
        List<Stereotype> stereotypes = FumlRepository.getFumlRepositoryInstance().getStereotypes((org.modeldriven.fuml.repository.Element)this.element);
        if (stereotypes != null) {
            for (Stereotype stereotype : stereotypes) {
                SDOAlias sdoAliasStereotype;
                if (!(stereotype.getDelegate() instanceof SDOAlias) || (sdoAliasStereotype = (SDOAlias)stereotype.getDelegate()).getPhysicalName() == null) continue;
                return sdoAliasStereotype.getPhysicalName();
            }
        }
        return null;
    }

    @Override
    public Alias findAlias() {
        List<Stereotype> stereotypes = FumlRepository.getFumlRepositoryInstance().getStereotypes((org.modeldriven.fuml.repository.Element)this.element);
        if (stereotypes != null) {
            for (Stereotype stereotype : stereotypes) {
                if (!(stereotype.getDelegate() instanceof SDOAlias)) continue;
                return (SDOAlias)stereotype.getDelegate();
            }
        }
        return null;
    }

    @Override
    public List<Comment> getComments() {
        ArrayList<Comment> result = new ArrayList<Comment>();
        for (fUML.Syntax.Classes.Kernel.Comment comment : this.element.getDelegate().ownedComment) {
            result.add(new FumlComment(comment));
        }
        return result;
    }
}

