/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.xsd;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.plasma.metamodel.Enumeration;
import org.plasma.provisioning.xsd.AbstractCollector;
import org.plasma.provisioning.xsd.EnumerationAssembler;
import org.plasma.provisioning.xsd.SimpleTypeUtils;
import org.plasma.xml.schema.AbstractSimpleType;
import org.plasma.xml.schema.Schema;
import org.plasma.xml.schema.SimpleType;
import org.plasma.xml.schema.SimpleTypeVisitor;

public class EnumerationCollector
extends AbstractCollector
implements SimpleTypeVisitor {
    private Schema schema;
    private Map<String, SimpleType> simpleTypeMap;
    private EnumerationAssembler assembler;
    private List<Enumeration> result = new ArrayList<Enumeration>();

    public EnumerationCollector(Schema schema, Map<String, SimpleType> simpleTypeMap, EnumerationAssembler enumerationAssembler) {
        this.schema = schema;
        this.simpleTypeMap = simpleTypeMap;
        this.assembler = enumerationAssembler;
    }

    public List<Enumeration> getResult() {
        return this.result;
    }

    public void visit(AbstractSimpleType target, AbstractSimpleType source, int level) {
        if (target.getRestriction() != null && SimpleTypeUtils.isEnumeration(target)) {
            Enumeration enumeration = this.assembler.buildEnumeration(target, source);
            this.result.add(enumeration);
        }
    }

    public SimpleType getTopLevelSimpleType(QName name) {
        return this.simpleTypeMap.get(name.getLocalPart());
    }

    public String getTargetNamespace() {
        return this.schema.getTargetNamespace();
    }
}

