/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.provider.common;

import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.PlasmaChangeSummary;
import org.plasma.sdo.PlasmaDataGraphVisitor;
import org.plasma.sdo.PlasmaDataObject;

public class ModifiedObjectCollector
implements PlasmaDataGraphVisitor {
    private static Log log = LogFactory.getFactory().getInstance(ModifiedObjectCollector.class);
    private HashSet<PlasmaDataObject> result = new HashSet();
    private PlasmaChangeSummary changeSummary;

    private ModifiedObjectCollector() {
    }

    public ModifiedObjectCollector(DataGraph dataGraph) {
        this.changeSummary = (PlasmaChangeSummary)dataGraph.getChangeSummary();
        PlasmaDataObject root = (PlasmaDataObject)dataGraph.getRootObject();
        root.accept(this);
    }

    @Override
    public void visit(DataObject target, DataObject source, String sourceKey, int level) {
        if (this.changeSummary.isModified(target) && !this.result.contains(target)) {
            this.result.add((PlasmaDataObject)target);
        }
    }

    public List<PlasmaDataObject> getResult() {
        PlasmaDataObject[] array = new PlasmaDataObject[this.result.size()];
        this.result.toArray(array);
        return Arrays.asList(array);
    }
}

