/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.core;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.plasma.common.Key;
import org.plasma.query.FunctionIdentifier;
import org.plasma.query.model.FunctionName;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.Increment;
import org.plasma.sdo.PlasmaChangeSummary;
import org.plasma.sdo.PlasmaDataGraphEventVisitor;
import org.plasma.sdo.PlasmaDataGraphVisitor;
import org.plasma.sdo.PlasmaDataLink;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaDataObjectException;
import org.plasma.sdo.PlasmaEdge;
import org.plasma.sdo.PlasmaNode;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.PlasmaValue;
import org.plasma.sdo.access.provider.common.PropertyPair;
import org.plasma.sdo.core.CoreNode;
import org.plasma.sdo.core.CoreObject;
import org.plasma.sdo.core.CoreValue;
import org.plasma.sdo.core.NullValue;
import org.plasma.sdo.core.PathEndpoint;
import org.plasma.sdo.core.SnapshotMap;
import org.plasma.sdo.core.collector.ContainmentGraphCollector;
import org.plasma.sdo.core.collector.LinkedNode;
import org.plasma.sdo.core.collector.SourceNodeCollector;
import org.plasma.sdo.helper.DataConverter;
import org.plasma.sdo.helper.InvalidDataFormatException;
import org.plasma.sdo.helper.PlasmaDataFactory;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.plasma.sdo.profile.KeyType;
import org.plasma.sdo.xpath.DataGraphNodeAdapter;
import org.plasma.sdo.xpath.DataGraphXPath;
import org.plasma.sdo.xpath.InvalidEndpointException;
import org.plasma.sdo.xpath.InvalidMultiplicityException;
import org.plasma.sdo.xpath.XPathDataObject;
import org.plasma.sdo.xpath.XPathDataProperty;

public class CoreDataObject
extends CoreNode
implements PlasmaDataObject {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getFactory().getInstance(CoreDataObject.class);
    private UUID uuid;
    private int hashCode;
    private DataGraph dataGraph;
    private transient Type type;
    private String typeName;
    private String typeUri;
    private DataObject container;
    private transient Property containmentProperty;
    private String containmentPropertyName;
    private String containmentPropertyTypeName;
    private String containmentPropertyTypeUri;

    protected CoreDataObject() {
    }

    protected CoreDataObject(Type type, CoreObject values, UUID uuid) {
        super(values);
        this.type = type;
        this.uuid = uuid;
        this.hashCode = uuid.hashCode();
    }

    public CoreDataObject(Type type) {
        this(type, new CoreObject(type.getName()), UUID.randomUUID());
    }

    public CoreDataObject(Type type, UUID uuid) {
        this(type, new CoreObject(type.getName()), uuid);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return this.uuid.equals(((CoreDataObject)obj).uuid);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.typeName = this.type.getName();
        this.typeUri = this.type.getURI();
        if (this.containmentProperty != null) {
            this.containmentPropertyName = this.containmentProperty.getName();
            this.containmentPropertyTypeName = this.containmentProperty.getContainingType().getName();
            this.containmentPropertyTypeUri = this.containmentProperty.getContainingType().getURI();
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.type = PlasmaTypeHelper.INSTANCE.getType(this.typeUri, this.typeName);
        this.typeName = null;
        this.typeUri = null;
        if (this.containmentPropertyName != null) {
            Type propertyType = PlasmaTypeHelper.INSTANCE.getType(this.containmentPropertyTypeUri, this.containmentPropertyTypeName);
            this.containmentProperty = propertyType.getProperty(this.containmentPropertyName);
            this.containmentPropertyName = null;
            this.containmentPropertyTypeName = null;
            this.containmentPropertyTypeUri = null;
        }
    }

    public DataGraph getDataGraph() {
        return this.dataGraph;
    }

    @Override
    public void setDataGraph(DataGraph dataGraph) {
        this.dataGraph = dataGraph;
    }

    public ChangeSummary getChangeSummary() {
        if (this.dataGraph == null) {
            throw new IllegalStateException("orphaned data object, " + this);
        }
        return this.dataGraph.getChangeSummary();
    }

    public DataObject getRootObject() {
        if (this.dataGraph == null) {
            throw new IllegalStateException("orphaned data object, " + this);
        }
        return this.dataGraph.getRootObject();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void resetUUID(UUID uuid) {
        this.uuid = uuid;
        this.hashCode = uuid.hashCode();
    }

    @Override
    @Deprecated
    public String getUUIDAsString() {
        return this.uuid.toString();
    }

    public String uuidToBase64(String str) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(this.uuid.getMostSignificantBits());
        bb.putLong(this.uuid.getLeastSignificantBits());
        return Base64.encodeBase64URLSafeString((byte[])bb.array());
    }

    public String uuidFromBase64(String str) {
        byte[] bytes = Base64.decodeBase64((String)str);
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        UUID uuid = new UUID(bb.getLong(), bb.getLong());
        return uuid.toString();
    }

    @Override
    public PlasmaDataObject getDataObject() {
        return this;
    }

    public DataObject createDataObject(String propertyName) {
        Property property = this.getType().getProperty(propertyName);
        return this.createContainedDataObject(property, property.getType());
    }

    public DataObject createDataObject(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.createContainedDataObject(property, property.getType());
    }

    public DataObject createDataObject(Property property) {
        return this.createContainedDataObject(property, property.getType());
    }

    public DataObject createDataObject(String propertyName, String namespaceURI, String typeName) {
        Property property = this.getType().getProperty(propertyName);
        Type type = PlasmaTypeHelper.INSTANCE.getType(namespaceURI, typeName);
        return this.createContainedDataObject(property, type);
    }

    public DataObject createDataObject(int propertyIndex, String namespaceURI, String typeName) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        Type type = PlasmaTypeHelper.INSTANCE.getType(namespaceURI, typeName);
        return this.createContainedDataObject(property, type);
    }

    public DataObject createDataObject(Property property, Type type) {
        return this.createContainedDataObject(property, type);
    }

    private DataObject createContainedDataObject(Property property, Type type) {
        PlasmaType targetType;
        if (property.getType().isDataType()) {
            throw new IllegalArgumentException("property '" + this.getType().getName() + "." + property.getName() + "' is a datatype property (" + property.getType().getName() + "), not a containment reference property");
        }
        if (!property.isContainment()) {
            throw new IllegalArgumentException("property '" + this.getType().getName() + "." + property.getName() + "' is not a containment property");
        }
        if (!(property.getType().getName().equals(type.getName()) && property.getType().getURI().equals(type.getURI()) || (targetType = (PlasmaType)type).isBaseType((PlasmaType)property.getType()))) {
            throw new IllegalArgumentException("the type for property '" + this.getType().getName() + "." + property.getName() + "(" + property.getType().getURI() + "#" + property.getType().getName() + ")" + "' is not compatible with (i.e. a base type of) the given type, " + type.getURI() + "#" + type.getName());
        }
        PlasmaDataObject dataObject = (PlasmaDataObject)PlasmaDataFactory.INSTANCE.create(type);
        Object oldValue = this.get(property);
        if (oldValue == null) {
            oldValue = new NullValue();
        }
        if (property.isMany()) {
            this.add(property, dataObject);
        } else {
            this.setValue(property, (Object)dataObject);
        }
        dataObject.setContainer(this);
        dataObject.setContainmentProperty(property);
        if (this.getDataGraph() == null) {
            throw new IllegalStateException("orphaned data-object, " + this);
        }
        dataObject.setDataGraph(this.getDataGraph());
        PlasmaChangeSummary changeSummary = (PlasmaChangeSummary)this.getDataGraph().getChangeSummary();
        changeSummary.created(dataObject);
        changeSummary.modified(this, property, oldValue);
        return dataObject;
    }

    @Override
    public void setContainer(DataObject container) {
        this.container = container;
    }

    @Override
    public void setContainmentProperty(Property containmentProperty) {
        this.containmentProperty = containmentProperty;
    }

    @Override
    public void reparent(PlasmaDataObject container, Property containmentProperty) {
        if (container.getDataGraph() != null) {
            Object oppositeOldValue;
            Object containerOldValue = container.get(containmentProperty);
            if (containerOldValue == null) {
                containerOldValue = new NullValue();
            }
            if ((oppositeOldValue = this.get(containmentProperty.getOpposite())) == null) {
                oppositeOldValue = new NullValue();
            }
            if (containmentProperty.isMany()) {
                container.add(containmentProperty, this);
            } else {
                container.set(containmentProperty, this);
            }
            this.setContainer(container);
            this.setContainmentProperty(containmentProperty);
            this.dataGraph = container.getDataGraph();
            Object timestamp = ((CoreNode)((Object)container)).getValue("snapshotTimestamp");
            if (timestamp != null) {
                this.setValue("snapshotTimestamp", timestamp);
            } else {
                this.setValue("snapshotTimestamp", (Object)new Timestamp(new Date().getTime()));
            }
            PlasmaChangeSummary changeSummary = (PlasmaChangeSummary)container.getDataGraph().getChangeSummary();
            changeSummary.modified(container, containmentProperty, containerOldValue);
            if (containmentProperty.getOpposite() != null) {
                changeSummary.modified(this, containmentProperty.getOpposite(), oppositeOldValue);
            }
        } else {
            throw new IllegalStateException("given container data-object has no data-graph");
        }
    }

    public void delete() {
        PlasmaProperty prop;
        PlasmaDataObject toDelete;
        ContainmentGraphCollector collector = new ContainmentGraphCollector();
        this.accept(collector);
        List<LinkedNode> nodes = collector.getResult();
        for (LinkedNode node : nodes) {
            toDelete = node.getDataObject();
            if (toDelete.getContainer() == null) {
                String rootKey = ((PlasmaNode)this.getDataGraph().getRootObject()).getUUIDAsString();
                if (!toDelete.getUUIDAsString().equals(rootKey)) {
                    throw new IllegalStateException("non-root data-object (" + toDelete + " has no container");
                }
            }
            if (toDelete.getDataGraph() == null) continue;
            Iterator changeSummary = (PlasmaChangeSummary)toDelete.getDataGraph().getChangeSummary();
            changeSummary.deleted(toDelete);
        }
        for (LinkedNode node : nodes) {
            toDelete = node.getDataObject();
            for (Property property : toDelete.getType().getProperties()) {
                if (!property.getType().isDataType() || property.isReadOnly() || (prop = (PlasmaProperty)property).isReadOnly() || prop.isKey(KeyType.primary) || !toDelete.isSet(property)) continue;
                toDelete.unset(property);
            }
        }
        for (LinkedNode node : nodes) {
            toDelete = node.getDataObject();
            for (Property property : toDelete.getType().getProperties()) {
                if (property.getType().isDataType()) continue;
                prop = (PlasmaProperty)property;
                if (!property.isMany()) {
                    DataObject dataObject = toDelete.getDataObject(property);
                    if (dataObject == null || prop.isReadOnly() || prop.isKey(KeyType.primary)) continue;
                    toDelete.unset(property);
                    continue;
                }
                List dataObjectList = toDelete.getList(property);
                if (dataObjectList == null) continue;
                for (DataObject dataObject : dataObjectList) {
                    toDelete.remove(property, dataObject);
                }
            }
        }
        SourceNodeCollector sourceCollector = new SourceNodeCollector(this);
        ((PlasmaDataObject)this.getDataGraph().getRootObject()).accept(sourceCollector);
        for (LinkedNode sourceNode : sourceCollector.getResult()) {
            PlasmaDataObject parent = sourceNode.getDataObject();
            if (sourceNode.getTargetProperty().isMany()) {
                parent.remove(sourceNode.getTargetProperty(), this);
                continue;
            }
            parent.unset(sourceNode.getTargetProperty());
        }
    }

    @Override
    public boolean contains(DataObject dataObject) {
        CoreDataObject container = (CoreDataObject)dataObject.getContainer();
        if (container == null) {
            throw new IllegalArgumentException("the given data-object, " + dataObject + ", has no container");
        }
        return container.equals(this);
    }

    public void detach() {
        if (this.dataGraph == null) {
            throw new IllegalStateException("this data object alrteady detached");
        }
        ContainmentGraphCollector collector = new ContainmentGraphCollector();
        this.accept(collector);
        List<LinkedNode> nodes = collector.getResult();
        for (LinkedNode node : nodes) {
            if (node.getDataObject().equals(this)) continue;
            node.getDataObject().setDataGraph(null);
        }
        if (this.containmentProperty != null) {
            if (this.container != null) {
                if (this.containmentProperty.isMany()) {
                    this.getContainer().getList(this.containmentProperty).remove(this);
                } else {
                    this.getContainer().unset(this.containmentProperty);
                }
                this.container = null;
            }
            this.containmentProperty = null;
        } else if (!((CoreDataObject)this.getDataGraph().getRootObject()).equals(this)) {
            log.warn((Object)("detected non root data object of type " + this.getType().getURI() + "#" + this.getType().getName() + " with no container"));
        }
        this.dataGraph = null;
    }

    public Object get(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.get(property);
    }

    public Object get(Property property) {
        ArrayList<DataObject> result = super.getValue(property.getName());
        if (result instanceof NullValue) {
            result = null;
        }
        if (result != null && !property.getType().isDataType()) {
            if (!property.isMany()) {
                result = ((PlasmaEdge)((Object)result)).getOpposite(this);
            } else {
                ArrayList<DataObject> resultList;
                List edgeList = result;
                result = resultList = new ArrayList<DataObject>(edgeList.size());
                for (PlasmaEdge edge : edgeList) {
                    resultList.add((DataObject)edge.getOpposite(this));
                }
            }
        }
        return result;
    }

    public Object get(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            Property property = this.getType().getProperty(path);
            return this.get(property);
        }
        ArrayList<Object> result = null;
        DataGraphNodeAdapter[] nodes = null;
        try {
            DataGraphXPath xpath = new DataGraphXPath(path);
            nodes = xpath.getResults(this);
        }
        catch (JaxenException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidMultiplicityException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        if (nodes.length == 1) {
            result = nodes[0].get();
        } else {
            ArrayList<Object> list = new ArrayList<Object>(nodes.length);
            for (DataGraphNodeAdapter node : nodes) {
                list.add(node.get());
            }
            result = list;
        }
        return result;
    }

    public void set(String path, Object value) {
        if (!DataGraphXPath.isXPath(path)) {
            Property property = this.getType().getProperty(path);
            this.set(property, value);
        } else {
            XPathDataProperty[] nodes = null;
            try {
                DataGraphXPath xpath = new DataGraphXPath(path);
                nodes = xpath.findProperties(this);
            }
            catch (JaxenException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvalidEndpointException e) {
                throw new IllegalArgumentException((Throwable)((Object)e));
            }
            for (XPathDataProperty node : nodes) {
                ((DataGraphNodeAdapter)node).set(value);
            }
        }
    }

    public void set(int propertyIndex, Object value) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.set(property, value);
    }

    public void set(Property property, Object value) {
        Object propertyValue;
        PlasmaChangeSummary changeSummary;
        if (this.getDataGraph() != null && !(changeSummary = (PlasmaChangeSummary)this.getDataGraph().getChangeSummary()).isCreated(this) && property.isReadOnly()) {
            throw new UnsupportedOperationException(this.getType().getURI() + "#" + this.getType().getName() + "." + property.getName() + " is a read-only property");
        }
        Map<DataObject, Object> oldValueMap = null;
        if (!property.getType().isDataType()) {
            oldValueMap = this.getOppositeValues(property, value);
        }
        if ((propertyValue = this.setValue(property, value)) != null) {
            this.setOppositeModified(property, oldValueMap);
        }
    }

    private Object setValue(Property property, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("unexpected null value - use DataObject.unset() to clear a property");
        }
        Serializable propertyValue = value;
        Class instanceClass = property.getType().getInstanceClass();
        if (!property.isMany()) {
            if (!instanceClass.isAssignableFrom(value.getClass())) {
                throw new ClassCastException("expected instance of " + property.getType().getInstanceClass().getName() + " as value for property " + property + " - not class, " + value.getClass().getName());
            }
            if (!property.getType().isDataType()) {
                PlasmaNode existingOpposite;
                PlasmaNode targetNode = (PlasmaNode)((Object)value);
                PlasmaDataLink existingLink = (PlasmaDataLink)super.getValue(property.getName());
                if (existingLink != null && (existingOpposite = existingLink.getOpposite(this)).equals(targetNode)) {
                    log.warn((Object)("detected 'set' operation with identical " + targetNode.getClass().getSimpleName() + " object (" + targetNode.getUUIDAsString() + ") for property " + property + " - ignoring"));
                    return null;
                }
                PlasmaDataLink link = this.createLink(property, targetNode);
                propertyValue = link;
            } else {
                Increment increment;
                PlasmaProperty plasmaProperty = (PlasmaProperty)property;
                DataFlavor flavor = plasmaProperty.getDataFlavor();
                if (flavor.ordinal() == DataFlavor.temporal.ordinal()) {
                    try {
                        DataConverter.INSTANCE.toDate(property.getType(), value);
                    }
                    catch (InvalidDataFormatException dfe) {
                        throw new PlasmaDataObjectException("property, " + property.toString(), dfe);
                    }
                }
                if ((increment = plasmaProperty.getIncrement()) == null) {
                    Object existingValue = this.get(property);
                    if (existingValue != null && existingValue.equals(propertyValue)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("detected 'set' operation with identical " + existingValue.getClass().getSimpleName() + " object (" + String.valueOf(existingValue) + ") for property " + property + " - ignoring"));
                        }
                        return null;
                    }
                } else if (flavor.ordinal() != DataFlavor.integral.ordinal()) {
                    throw new IllegalArgumentException("detected 'increment' operation with non-integral datatype property, " + plasmaProperty);
                }
            }
        } else if (value instanceof List) {
            List list = value;
            ArrayList<PlasmaDataLink> edgeList = null;
            if (!property.getType().isDataType()) {
                propertyValue = edgeList = new ArrayList<PlasmaDataLink>(list.size());
                for (Object listValue : list) {
                    if (!instanceClass.isAssignableFrom(listValue.getClass())) {
                        throw new ClassCastException("expected instance of " + property.getType().getInstanceClass().getName() + " as value for property " + property + " - not class, " + listValue.getClass().getName());
                    }
                    PlasmaDataLink link = this.createLink(property, (PlasmaNode)listValue);
                    edgeList.add(link);
                }
            } else {
                DataFlavor flavor = ((PlasmaProperty)property).getDataFlavor();
                try {
                    for (Object listValue : list) {
                        if (!instanceClass.isAssignableFrom(listValue.getClass())) {
                            throw new ClassCastException("expected instance of " + property.getType().getInstanceClass().getName() + " as value for property " + property + " - not class, " + listValue.getClass().getName());
                        }
                        if (flavor.ordinal() != DataFlavor.temporal.ordinal()) continue;
                        DataConverter.INSTANCE.toDate(property.getType(), value);
                    }
                }
                catch (InvalidDataFormatException dfe) {
                    throw new PlasmaDataObjectException("property, " + property.toString(), dfe);
                }
            }
        } else {
            throw new ClassCastException("expected java.util.List Java Class for property " + property + " - not class, " + value.getClass().getName());
        }
        if (this.getDataGraph() != null) {
            Object oldValue = this.get(property);
            if (oldValue == null) {
                oldValue = new NullValue();
            }
            PlasmaChangeSummary changeSummary = (PlasmaChangeSummary)this.getDataGraph().getChangeSummary();
            changeSummary.modified(this, property, oldValue);
        }
        super.setValue(property.getName(), propertyValue);
        return propertyValue;
    }

    private Map<DataObject, Object> getOppositeValues(Property property, Object value) {
        Property opposite;
        if (!property.getType().isDataType() && (opposite = property.getOpposite()) != null) {
            if (!property.isMany()) {
                return this.getOppositeValues(this, property, opposite, (DataObject)value);
            }
            return this.getOppositeValues(this, property, opposite, (List)value);
        }
        return Collections.emptyMap();
    }

    private Map<DataObject, Object> getOppositeValues(CoreDataObject dataObject, Property property, Property oppositeProperty, DataObject opposite) {
        HashMap<DataObject, Object> result = new HashMap<DataObject, Object>(1);
        Object oldValue = opposite.get(oppositeProperty);
        if (oldValue == null) {
            oldValue = new NullValue();
        }
        result.put(opposite, oldValue);
        return result;
    }

    private Map<DataObject, Object> getOppositeValues(CoreDataObject dataObject, Property property, Property oppositeProperty, List<DataObject> opposites) {
        HashMap<DataObject, Object> result = new HashMap<DataObject, Object>();
        for (DataObject opposite : opposites) {
            Object oldValue = opposite.get(oppositeProperty);
            if (oldValue == null) {
                oldValue = new NullValue();
            }
            result.put(opposite, oldValue);
        }
        return result;
    }

    private void setOppositeModified(Property property, Map<DataObject, Object> opposites) {
        Property oppositeProperty;
        if (!property.getType().isDataType() && (oppositeProperty = property.getOpposite()) != null) {
            PlasmaChangeSummary changeSummary = null;
            for (DataObject opposite : opposites.keySet()) {
                if (opposite.getDataGraph() == null) continue;
                if (changeSummary == null) {
                    changeSummary = (PlasmaChangeSummary)opposite.getDataGraph().getChangeSummary();
                }
                if (changeSummary.isCreated(opposite) || changeSummary.isDeleted(opposite)) continue;
                Object oldValue = opposites.get(opposite);
                changeSummary.modified(opposite, oppositeProperty, oldValue);
            }
        }
    }

    @Override
    public void add(Property property, Object value) {
        if (property.isReadOnly()) {
            throw new UnsupportedOperationException(this.getType().getURI() + "#" + this.getType().getName() + "." + property.getName() + " is a read-only property");
        }
        Class instanceClass = property.getType().getInstanceClass();
        if (!property.isMany()) {
            throw new UnsupportedOperationException(this.getType().getURI() + "#" + this.getType().getName() + "." + property.getName() + " is not a multi-valued property");
        }
        if (value instanceof List) {
            throw new IllegalArgumentException("unexpected List argument - use addList()");
        }
        if (!instanceClass.isAssignableFrom(value.getClass())) {
            throw new ClassCastException("expected instance of " + property.getType().getInstanceClass().getName() + " as value for property " + this.type.getURI() + "#" + this.type.getName() + "." + property.getName() + " - not class, " + value.getClass().getName());
        }
        if (!property.getType().isDataType()) {
            ArrayList<PlasmaDataLink> edgeList = (ArrayList<PlasmaDataLink>)super.getValue(property.getName());
            if (edgeList == null) {
                edgeList = new ArrayList<PlasmaDataLink>();
                super.setValue(property.getName(), edgeList);
            }
            PlasmaDataLink link = this.createLink(property, (PlasmaNode)value);
            edgeList.add(link);
        } else {
            ArrayList<Object> list = (ArrayList<Object>)super.getValue(property.getName());
            if (list == null) {
                list = new ArrayList<Object>();
                super.setValue(property.getName(), list);
            }
            list.add(value);
        }
    }

    @Override
    public void remove(Property property, Object value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing " + this.getType().getURI() + "#" + this.getType().getName() + "." + property.getName()));
        }
        if (property.isReadOnly()) {
            throw new UnsupportedOperationException(this.getType().getURI() + "#" + this.getType().getName() + "." + property.getName() + " is a read-only property");
        }
        Class instanceClass = property.getType().getInstanceClass();
        if (!property.isMany()) {
            throw new UnsupportedOperationException(this.getType().getURI() + "#" + this.getType().getName() + "." + property.getName() + " is not a multi-valued property");
        }
        if (value instanceof List) {
            throw new IllegalArgumentException("unexpected List argument");
        }
        if (!instanceClass.isAssignableFrom(value.getClass())) {
            throw new ClassCastException("expected instance of " + property.getType().getInstanceClass().getName() + " as value for property " + this.type.getURI() + "#" + this.type.getName() + "." + property.getName() + " - not class, " + value.getClass().getName());
        }
        Object oldValue = this.get(property);
        if (!property.getType().isDataType()) {
            List edgeList = (List)super.getValue(property.getName());
            if (edgeList == null) {
                throw new IllegalStateException("no list found for property " + this.type.getURI() + "#" + this.type.getName() + "." + property.getName());
            }
            PlasmaNode nodeValue = (PlasmaNode)value;
            PlasmaEdge link = null;
            CoreDataObject oppositeDataObject = null;
            for (PlasmaEdge edge : edgeList) {
                oppositeDataObject = null;
                if (edge.getLeft().getUUIDAsString().equals(nodeValue.getUUIDAsString())) {
                    link = edge;
                    oppositeDataObject = (CoreDataObject)edge.getLeft().getDataObject();
                    break;
                }
                if (!edge.getRight().getUUIDAsString().equals(nodeValue.getUUIDAsString())) continue;
                link = edge;
                oppositeDataObject = (CoreDataObject)edge.getRight().getDataObject();
                break;
            }
            if (oppositeDataObject == null) {
                throw new IllegalStateException("could not find link for property " + this.type.getURI() + "#" + this.type.getName() + "." + property.getName());
            }
            Property oppositeProperty = property.getOpposite();
            if (oppositeProperty != null) {
                Object oppositeValue = oppositeDataObject.get(oppositeProperty);
                if (oppositeValue != null) {
                    if (oppositeProperty.isMany()) {
                        List oppositeEdgeList = (List)oppositeDataObject.getValue(oppositeProperty.getName());
                        if (!oppositeEdgeList.remove(link)) {
                            throw new IllegalStateException("could not remove opposite link for property " + this.type.getURI() + "#" + this.type.getName() + "." + property.getName());
                        }
                    } else {
                        oppositeDataObject.removeValue(oppositeProperty.getName());
                    }
                } else {
                    throw new IllegalStateException("could not find opposite value for property " + this.type.getURI() + "#" + this.type.getName() + "." + property.getName());
                }
                if (this.getDataGraph() != null && oldValue != null) {
                    PlasmaChangeSummary changeSummary = (PlasmaChangeSummary)this.getDataGraph().getChangeSummary();
                    changeSummary.modified(oppositeDataObject, oppositeProperty, oppositeValue);
                }
            }
            if (!edgeList.remove(link)) {
                throw new IllegalStateException("could not remove link for property " + this.type.getURI() + "#" + this.type.getName() + "." + property.getName());
            }
        } else {
            List list = (List)super.getValue(property.getName());
            if (list == null) {
                throw new IllegalStateException("no values found for property " + this.type.getURI() + "#" + this.type.getName() + "." + property.getName());
            }
            if (!list.remove(value)) {
                throw new IllegalArgumentException("value not found in list for property " + this.type.getURI() + "#" + this.type.getName() + "." + property.getName());
            }
        }
        if (this.getDataGraph() != null && oldValue != null) {
            PlasmaChangeSummary changeSummary = (PlasmaChangeSummary)this.getDataGraph().getChangeSummary();
            changeSummary.modified(this, property, oldValue);
        }
    }

    private PlasmaDataLink createLink(Property property, PlasmaNode node) {
        Property opposite;
        PlasmaDataObject target = node.getDataObject();
        if (this.getDataGraph() == null) {
            throw new IllegalStateException("orphaned data object, " + this);
        }
        if (target.getDataGraph() == null) {
            if (target.getContainer() != null || target.getContainmentProperty() != null) {
                throw new IllegalArgumentException("given data-object has a container but no data graph");
            }
            ContainmentGraphCollector collector = new ContainmentGraphCollector();
            target.accept(collector);
            for (LinkedNode containmentNode : collector.getResult()) {
                containmentNode.getDataObject().setDataGraph(this.getDataGraph());
            }
            target.setContainer(this);
            target.setContainmentProperty(property);
            target.setDataGraph(this.getDataGraph());
        } else if (!target.getDataGraph().equals(this.getDataGraph())) {
            throw new IllegalArgumentException("given data-object already belongs to a data-graph");
        }
        PlasmaDataLink link = new PlasmaDataLink(this, node);
        if (log.isDebugEnabled()) {
            log.debug((Object)("created link (" + link.hashCode() + ") from/to (" + this.getUUIDAsString() + ") " + this.getType().getURI() + "#" + this.getType().getName() + "." + property.getName() + "->(" + target.getUUIDAsString() + ") " + target.getType().getURI() + "#" + target.getType().getName()));
        }
        if ((opposite = property.getOpposite()) != null) {
            if (opposite.isMany()) {
                ArrayList<PlasmaDataLink> oppositeList = (ArrayList<PlasmaDataLink>)((CoreDataObject)target).getValue(opposite.getName());
                if (oppositeList == null) {
                    oppositeList = new ArrayList<PlasmaDataLink>(1);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding link (" + link.hashCode() + ") from/to (" + target.getUUIDAsString() + ") " + target.getType().getURI() + "#" + target.getType().getName() + "." + opposite.getName() + "->(" + this.getUUIDAsString() + ") " + this.getType().getURI() + "#" + this.getType().getName()));
                }
                oppositeList.add(link);
                ((CoreDataObject)target).setValue(opposite.getName(), oppositeList);
            } else {
                if (target.isSet(opposite)) {
                    throw new IllegalArgumentException("cannot link this " + this.getType().getURI() + "#" + this.getType().getName() + " object to singular opposite property " + target.getType().getURI() + "#" + target.getType().getName() + "." + opposite.getName() + " because a value is already set " + "- consider making this property a 'many' property");
                }
                ((CoreDataObject)target).setValue(opposite.getName(), (Object)link);
            }
        }
        return link;
    }

    public void unset(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            Property property = this.getType().getProperty(path);
            this.unset(property);
        } else {
            XPathDataProperty[] nodes = null;
            try {
                DataGraphXPath xpath = new DataGraphXPath(path);
                nodes = xpath.findProperties(this);
            }
            catch (JaxenException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvalidEndpointException e) {
                throw new IllegalArgumentException((Throwable)((Object)e));
            }
            for (XPathDataProperty node : nodes) {
                node.unset();
            }
        }
    }

    public void unset(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.unset(property);
    }

    public void unset(Property property) {
        if (this.getType().getProperty(property.getName()) == null) {
            throw new IllegalArgumentException("given property " + property.getType().getURI() + "#" + property.getType().getName() + "." + property.getName() + " is not found within this Data Objects type, " + this.getType().getURI() + "#" + this.getType().getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("unsetting " + this.getType().getURI() + "#" + this.getType().getName() + "." + property.getName() + "(" + this.getUUIDAsString() + ")"));
        }
        if (!this.isSet(property)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("cannot unset property " + this.getType().getURI() + "#" + this.getType().getName() + "." + property.getName()));
            }
            return;
        }
        if (property.isReadOnly()) {
            throw new UnsupportedOperationException(this.getType().getURI() + "#" + this.getType().getName() + "." + property.getName() + " is a read-only property");
        }
        Object oldValue = this.get(property);
        if (!property.isMany()) {
            if (property.getType().isDataType()) {
                if (this.getDataGraph() != null) {
                    PlasmaChangeSummary changeSummary = (PlasmaChangeSummary)this.getDataGraph().getChangeSummary();
                    if (oldValue != null) {
                        changeSummary.modified(this, property, oldValue);
                    }
                }
                this.setValue(property.getName(), (Object)new NullValue());
            } else {
                this.oppositeModified(this, property);
                if (this.getDataGraph() != null) {
                    PlasmaChangeSummary changeSummary = (PlasmaChangeSummary)this.getDataGraph().getChangeSummary();
                    if (oldValue != null) {
                        changeSummary.modified(this, property, oldValue);
                    }
                }
                PlasmaDataObject oldDataObject = (PlasmaDataObject)oldValue;
                this.unsetOpposite(this, property);
                this.setValue(property.getName(), (Object)new NullValue());
            }
        } else if (property.getType().isDataType()) {
            if (this.getDataGraph() != null) {
                PlasmaChangeSummary changeSummary = (PlasmaChangeSummary)this.getDataGraph().getChangeSummary();
                if (oldValue != null) {
                    changeSummary.modified(this, property, oldValue);
                }
            }
            this.removeValue(property.getName());
        } else {
            this.oppositeModified(this, property);
            if (this.getDataGraph() != null) {
                PlasmaChangeSummary changeSummary = (PlasmaChangeSummary)this.getDataGraph().getChangeSummary();
                if (oldValue != null) {
                    changeSummary.modified(this, property, oldValue);
                }
            }
            this.unsetOpposite(this, property);
            this.removeValue(property.getName());
        }
    }

    @Deprecated
    private void oppositeModified(CoreDataObject dataObject, Property property) {
        block8: {
            Property oppositeProperty;
            block7: {
                PlasmaChangeSummary changeSummary;
                PlasmaDataObject oppositeDataObject;
                block9: {
                    PlasmaChangeSummary changeSummary2;
                    oppositeProperty = property.getOpposite();
                    if (oppositeProperty == null) {
                        return;
                    }
                    if (property.isMany()) break block7;
                    PlasmaDataLink link = (PlasmaDataLink)dataObject.getValue(property.getName());
                    if (link == null) break block8;
                    PlasmaNode oppositeNode = link.getOpposite(dataObject);
                    oppositeDataObject = oppositeNode.getDataObject();
                    if (oppositeProperty.isMany()) break block9;
                    PlasmaDataLink oppositeLink = (PlasmaDataLink)((CoreDataObject)oppositeDataObject).getValue(oppositeProperty.getName());
                    if (oppositeLink == null || !oppositeLink.equals(link)) {
                        throw new IllegalStateException("expected equivalent link for property, " + this.getType().getURI() + "#" + this.getType().getName() + "." + property.getName());
                    }
                    if (oppositeDataObject.getDataGraph() != null && !(changeSummary2 = (PlasmaChangeSummary)oppositeDataObject.getDataGraph().getChangeSummary()).isCreated(oppositeDataObject) && !changeSummary2.isDeleted(oppositeDataObject)) {
                        changeSummary2.modified(oppositeDataObject, oppositeProperty, this);
                    }
                    break block8;
                }
                List oppositeDataObjectList = oppositeDataObject.getList(oppositeProperty);
                if (oppositeDataObject.getDataGraph() == null || (changeSummary = (PlasmaChangeSummary)oppositeDataObject.getDataGraph().getChangeSummary()).isCreated(oppositeDataObject) || changeSummary.isDeleted(oppositeDataObject)) break block8;
                changeSummary.modified(oppositeDataObject, oppositeProperty, oppositeDataObjectList);
                break block8;
            }
            List links = (List)dataObject.getValue(property.getName());
            if (links != null) {
                for (PlasmaDataLink link : links) {
                    PlasmaChangeSummary changeSummary;
                    PlasmaNode oppositeNode = link.getOpposite(dataObject);
                    PlasmaDataObject oppositeDataObject = oppositeNode.getDataObject();
                    if (!oppositeProperty.isMany()) {
                        PlasmaDataLink oppositeLink = (PlasmaDataLink)((CoreDataObject)oppositeDataObject).getValue(oppositeProperty.getName());
                        if (oppositeLink == null || !oppositeLink.equals(link)) {
                            throw new IllegalStateException("expected equivalent link for property, " + this.getType().getURI() + "#" + this.getType().getName() + "." + property.getName());
                        }
                        if (oppositeDataObject.getDataGraph() == null || (changeSummary = (PlasmaChangeSummary)oppositeDataObject.getDataGraph().getChangeSummary()).isCreated(oppositeDataObject) || changeSummary.isDeleted(oppositeDataObject)) continue;
                        changeSummary.modified(oppositeDataObject, oppositeProperty, this);
                        continue;
                    }
                    List oppositeDataObjectList = oppositeDataObject.getList(oppositeProperty);
                    if (oppositeDataObject.getDataGraph() == null || (changeSummary = (PlasmaChangeSummary)oppositeDataObject.getDataGraph().getChangeSummary()).isCreated(oppositeDataObject) || changeSummary.isDeleted(oppositeDataObject)) continue;
                    changeSummary.modified(oppositeDataObject, oppositeProperty, oppositeDataObjectList);
                }
            }
        }
    }

    private void unsetOpposite(CoreDataObject dataObject, Property property) {
        if (!property.isMany()) {
            PlasmaDataLink link = (PlasmaDataLink)dataObject.getValue(property.getName());
            this.unsetLink(link, dataObject, property);
        } else {
            List links = (List)dataObject.getValue(property.getName());
            if (links != null) {
                for (PlasmaDataLink link : links) {
                    this.unsetLink(link, dataObject, property);
                }
            }
        }
    }

    private void unsetLink(PlasmaDataLink link, CoreDataObject dataObject, Property property) {
        PlasmaNode oppositeNode = link.getOpposite(dataObject);
        PlasmaDataObject oppositeDataObject = oppositeNode.getDataObject();
        Property oppositeProperty = property.getOpposite();
        if (oppositeProperty != null) {
            if (!oppositeProperty.isMany()) {
                PlasmaDataLink oppositeLink = (PlasmaDataLink)((CoreDataObject)oppositeDataObject).getValue(oppositeProperty.getName());
                if (oppositeLink == null || !oppositeLink.equals(link)) {
                    throw new IllegalStateException("expected equivalent link for property, " + this.getType().getURI() + "#" + this.getType().getName() + "." + property.getName());
                }
                ((CoreDataObject)oppositeDataObject).setValue(oppositeProperty.getName(), (Object)new NullValue());
            } else {
                List oppositeList = (List)((CoreDataObject)oppositeDataObject).getValue(oppositeProperty.getName());
                if (!oppositeList.remove(link)) {
                    throw new IllegalStateException("could not remove opposite link for property, " + dataObject.getType().getURI() + "#" + this.getType().getName() + "." + property.getName());
                }
            }
        }
    }

    public boolean isSet(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            Property property = this.getType().getProperty(path);
            return this.isSet(property);
        }
        XPathDataProperty[] nodes = null;
        try {
            DataGraphXPath xpath = new DataGraphXPath(path);
            nodes = xpath.findProperties(this);
        }
        catch (JaxenException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidEndpointException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        if (nodes.length > 1) {
            throw new IllegalArgumentException("given XPath '" + path + "' resulted in " + "multiple results");
        }
        return nodes[0].isSet();
    }

    public boolean isSet(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.isSet(property);
    }

    public boolean isSet(Property property) {
        Object value = super.getValue(property.getName());
        return value != null && !(value instanceof NullValue);
    }

    public BigDecimal getBigDecimal(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            return this.getBigDecimal(this.getType().getProperty(path));
        }
        PathEndpoint endpoint = this.findEndpoint(path);
        if (endpoint != null) {
            return endpoint.getSource().getBigDecimal(endpoint.getProperty());
        }
        return null;
    }

    public BigDecimal getBigDecimal(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.getBigDecimal(property);
    }

    public BigDecimal getBigDecimal(Property property) {
        Object value = this.get(property);
        if (value != null) {
            return DataConverter.INSTANCE.toDecimal(property.getType(), value);
        }
        return null;
    }

    public BigInteger getBigInteger(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            return this.getBigInteger(this.getType().getProperty(path));
        }
        PathEndpoint endpoint = this.findEndpoint(path);
        if (endpoint != null) {
            return endpoint.getSource().getBigInteger(endpoint.getProperty());
        }
        return null;
    }

    public BigInteger getBigInteger(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.getBigInteger(property);
    }

    public BigInteger getBigInteger(Property property) {
        Object value = this.get(property);
        if (value != null) {
            try {
                return DataConverter.INSTANCE.toInteger(property.getType(), value);
            }
            catch (NumberFormatException e) {
                throw new ClassCastException(e.getMessage());
            }
        }
        return null;
    }

    public boolean getBoolean(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            return this.getBoolean(this.getType().getProperty(path));
        }
        PathEndpoint endpoint = this.findEndpoint(path);
        if (endpoint != null) {
            return endpoint.getSource().getBoolean(endpoint.getProperty());
        }
        return false;
    }

    public boolean getBoolean(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.getBoolean(property);
    }

    public boolean getBoolean(Property property) {
        Object value = this.get(property);
        if (value != null) {
            return DataConverter.INSTANCE.toBoolean(property.getType(), value);
        }
        return false;
    }

    public byte getByte(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            return this.getByte(this.getType().getProperty(path));
        }
        PathEndpoint endpoint = this.findEndpoint(path);
        if (endpoint != null) {
            return endpoint.getSource().getByte(endpoint.getProperty());
        }
        return 0;
    }

    public byte getByte(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.getByte(property);
    }

    public byte getByte(Property property) {
        Object value = this.get(property);
        if (value != null) {
            return DataConverter.INSTANCE.toByte(property.getType(), value);
        }
        return 0;
    }

    public byte[] getBytes(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            return this.getBytes(this.getType().getProperty(path));
        }
        PathEndpoint endpoint = this.findEndpoint(path);
        if (endpoint != null) {
            return endpoint.getSource().getBytes(endpoint.getProperty());
        }
        return new byte[0];
    }

    public byte[] getBytes(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.getBytes(property);
    }

    public byte[] getBytes(Property property) {
        Object value = this.get(property);
        if (value != null) {
            return DataConverter.INSTANCE.toBytes(property.getType(), value);
        }
        return null;
    }

    public char getChar(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            return this.getChar(this.getType().getProperty(path));
        }
        PathEndpoint endpoint = this.findEndpoint(path);
        if (endpoint != null) {
            return endpoint.getSource().getChar(endpoint.getProperty());
        }
        return '\u0000';
    }

    public char getChar(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.getChar(property);
    }

    public char getChar(Property property) {
        Object value = this.get(property);
        if (value != null) {
            return DataConverter.INSTANCE.toCharacter(property.getType(), value);
        }
        return '\u0000';
    }

    public Date getDate(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            return this.getDate(this.getType().getProperty(path));
        }
        PathEndpoint endpoint = this.findEndpoint(path);
        if (endpoint != null) {
            return endpoint.getSource().getDate(endpoint.getProperty());
        }
        return null;
    }

    public Date getDate(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.getDate(property);
    }

    public Date getDate(Property property) {
        Object value = this.get(property);
        if (value != null) {
            return DataConverter.INSTANCE.toDate(property.getType(), value);
        }
        return null;
    }

    public double getDouble(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            return this.getDouble(this.getType().getProperty(path));
        }
        PathEndpoint endpoint = this.findEndpoint(path);
        if (endpoint != null) {
            return endpoint.getSource().getDouble(endpoint.getProperty());
        }
        return 0.0;
    }

    public double getDouble(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.getDouble(property);
    }

    public double getDouble(Property property) {
        Object value = this.get(property);
        if (value != null) {
            return DataConverter.INSTANCE.toDouble(property.getType(), value);
        }
        return 0.0;
    }

    public float getFloat(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            return this.getFloat(this.getType().getProperty(path));
        }
        PathEndpoint endpoint = this.findEndpoint(path);
        if (endpoint != null) {
            return endpoint.getSource().getFloat(endpoint.getProperty());
        }
        return 0.0f;
    }

    public float getFloat(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.getFloat(property);
    }

    public float getFloat(Property property) {
        Object value = this.get(property);
        if (value != null) {
            return DataConverter.INSTANCE.toFloat(property.getType(), value);
        }
        return 0.0f;
    }

    public int getInt(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            return this.getInt(this.getType().getProperty(path));
        }
        PathEndpoint endpoint = this.findEndpoint(path);
        if (endpoint != null) {
            return endpoint.getSource().getInt(endpoint.getProperty());
        }
        return 0;
    }

    public int getInt(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.getInt(property);
    }

    public int getInt(Property property) {
        Object value = this.get(property);
        if (value != null) {
            try {
                return DataConverter.INSTANCE.toInt(property.getType(), value);
            }
            catch (NumberFormatException e) {
                throw new ClassCastException(e.getMessage());
            }
        }
        return 0;
    }

    public List getList(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            return this.getList(this.getType().getProperty(path));
        }
        PathEndpoint endpoint = this.findEndpoint(path);
        if (endpoint != null) {
            return endpoint.getSource().getList(endpoint.getProperty());
        }
        return new ArrayList();
    }

    public List getList(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.getList(property);
    }

    public List getList(Property property) {
        return (List)this.get(property);
    }

    public long getLong(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            return this.getLong(this.getType().getProperty(path));
        }
        PathEndpoint endpoint = this.findEndpoint(path);
        if (endpoint != null) {
            return endpoint.getSource().getLong(endpoint.getProperty());
        }
        return 0L;
    }

    public long getLong(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.getLong(property);
    }

    public long getLong(Property property) {
        Object value = this.get(property);
        if (value != null) {
            try {
                return DataConverter.INSTANCE.toLong(property.getType(), value);
            }
            catch (NumberFormatException e) {
                throw new ClassCastException(e.getMessage());
            }
        }
        return 0L;
    }

    public Property getProperty(String propertyName) {
        return this.getType().getProperty(propertyName);
    }

    public short getShort(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            return this.getShort(this.getType().getProperty(path));
        }
        PathEndpoint endpoint = this.findEndpoint(path);
        if (endpoint != null) {
            return endpoint.getSource().getShort(endpoint.getProperty());
        }
        return 0;
    }

    public short getShort(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.getShort(property);
    }

    public short getShort(Property property) {
        Object value = this.get(property);
        if (value != null) {
            try {
                return DataConverter.INSTANCE.toShort(property.getType(), value);
            }
            catch (NumberFormatException e) {
                throw new ClassCastException(e.getMessage());
            }
        }
        return 0;
    }

    public String getString(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            return this.getString(this.getType().getProperty(path));
        }
        PathEndpoint endpoint = this.findEndpoint(path);
        if (endpoint != null) {
            return endpoint.getSource().getString(endpoint.getProperty());
        }
        return null;
    }

    public String getString(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return this.getString(property);
    }

    public String getString(Property property) {
        Object value = this.get(property);
        if (value != null) {
            return DataConverter.INSTANCE.toString(property.getType(), value);
        }
        return null;
    }

    public Type getType() {
        return this.type;
    }

    public void setBigDecimal(String path, BigDecimal value) {
        if (!DataGraphXPath.isXPath(path)) {
            this.setBigDecimal(this.getType().getProperty(path), value);
        } else {
            PathEndpoint endpoint = this.findEndpoint(path);
            if (endpoint != null) {
                endpoint.getSource().setBigDecimal(endpoint.getProperty(), value);
            }
        }
    }

    public void setBigDecimal(int propertyIndex, BigDecimal value) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.setBigDecimal(property, value);
    }

    public void setBigDecimal(Property property, BigDecimal value) {
        this.set(property, (Object)value);
    }

    public void setBigInteger(String path, BigInteger value) {
        if (!DataGraphXPath.isXPath(path)) {
            this.setBigInteger(this.getType().getProperty(path), value);
        } else {
            PathEndpoint endpoint = this.findEndpoint(path);
            if (endpoint != null) {
                endpoint.getSource().setBigInteger(endpoint.getProperty(), value);
            }
        }
    }

    public void setBigInteger(int propertyIndex, BigInteger value) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.setBigInteger(property, value);
    }

    public void setBigInteger(Property property, BigInteger value) {
        this.set(property, (Object)value);
    }

    public void setBoolean(String path, boolean value) {
        if (!DataGraphXPath.isXPath(path)) {
            this.setBoolean(this.getType().getProperty(path), value);
        } else {
            PathEndpoint endpoint = this.findEndpoint(path);
            if (endpoint != null) {
                endpoint.getSource().setBoolean(endpoint.getProperty(), value);
            }
        }
    }

    public void setBoolean(int propertyIndex, boolean value) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.setBoolean(property, value);
    }

    public void setBoolean(Property property, boolean value) {
        this.set(property, (Object)value);
    }

    public void setByte(String path, byte value) {
        if (!DataGraphXPath.isXPath(path)) {
            this.setByte(this.getType().getProperty(path), value);
        } else {
            PathEndpoint endpoint = this.findEndpoint(path);
            if (endpoint != null) {
                endpoint.getSource().setByte(endpoint.getProperty(), value);
            }
        }
    }

    public void setByte(int propertyIndex, byte value) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.setByte(property, value);
    }

    public void setByte(Property property, byte value) {
        this.set(property, (Object)value);
    }

    public void setBytes(String path, byte[] value) {
        if (!DataGraphXPath.isXPath(path)) {
            this.setBytes(this.getType().getProperty(path), value);
        } else {
            PathEndpoint endpoint = this.findEndpoint(path);
            if (endpoint != null) {
                endpoint.getSource().setBytes(endpoint.getProperty(), value);
            }
        }
    }

    public void setBytes(int propertyIndex, byte[] value) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.setBytes(property, value);
    }

    public void setBytes(Property property, byte[] value) {
        this.set(property, (Object)value);
    }

    public void setChar(String path, char value) {
        if (!DataGraphXPath.isXPath(path)) {
            this.setChar(this.getType().getProperty(path), value);
        } else {
            PathEndpoint endpoint = this.findEndpoint(path);
            if (endpoint != null) {
                endpoint.getSource().setChar(endpoint.getProperty(), value);
            }
        }
    }

    public void setChar(int propertyIndex, char value) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.setChar(property, value);
    }

    public void setChar(Property property, char value) {
        this.set(property, (Object)Character.valueOf(value));
    }

    public void setDataObject(String path, DataObject value) {
        if (!DataGraphXPath.isXPath(path)) {
            this.setDataObject(this.getType().getProperty(path), value);
        } else {
            PathEndpoint endpoint = this.findEndpoint(path);
            if (endpoint != null) {
                endpoint.getSource().setDataObject(endpoint.getProperty(), value);
            }
        }
    }

    public void setDataObject(int propertyIndex, DataObject value) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.setDataObject(property, value);
    }

    public void setDataObject(Property property, DataObject value) {
        this.set(property, (Object)value);
    }

    public void setDate(String path, Date value) {
        if (!DataGraphXPath.isXPath(path)) {
            this.setDate(this.getType().getProperty(path), value);
        } else {
            PathEndpoint endpoint = this.findEndpoint(path);
            if (endpoint != null) {
                endpoint.getSource().setDate(endpoint.getProperty(), value);
            }
        }
    }

    public void setDate(int propertyIndex, Date value) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.setDate(property, value);
    }

    public void setDate(Property property, Date value) {
        this.set(property, (Object)value);
    }

    public void setDouble(String path, double value) {
        if (!DataGraphXPath.isXPath(path)) {
            this.setDouble(this.getType().getProperty(path), value);
        } else {
            PathEndpoint endpoint = this.findEndpoint(path);
            if (endpoint != null) {
                endpoint.getSource().setDouble(endpoint.getProperty(), value);
            }
        }
    }

    public void setDouble(int propertyIndex, double value) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.setDouble(property, value);
    }

    public void setDouble(Property property, double value) {
        this.set(property, (Object)value);
    }

    public void setFloat(String path, float value) {
        if (!DataGraphXPath.isXPath(path)) {
            this.setFloat(this.getType().getProperty(path), value);
        } else {
            PathEndpoint endpoint = this.findEndpoint(path);
            if (endpoint != null) {
                endpoint.getSource().setFloat(endpoint.getProperty(), value);
            }
        }
    }

    public void setFloat(int propertyIndex, float value) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.setFloat(property, value);
    }

    public void setFloat(Property property, float value) {
        this.set(property, (Object)Float.valueOf(value));
    }

    public void setInt(String path, int value) {
        if (!DataGraphXPath.isXPath(path)) {
            this.setInt(this.getType().getProperty(path), value);
        } else {
            PathEndpoint endpoint = this.findEndpoint(path);
            if (endpoint != null) {
                endpoint.getSource().setInt(endpoint.getProperty(), value);
            }
        }
    }

    public void setInt(int propertyIndex, int value) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.setInt(property, value);
    }

    public void setInt(Property property, int value) {
        this.set(property, (Object)value);
    }

    public void setList(String path, List value) {
        if (!DataGraphXPath.isXPath(path)) {
            this.setList(this.getType().getProperty(path), value);
        } else {
            PathEndpoint endpoint = this.findEndpoint(path);
            if (endpoint != null) {
                endpoint.getSource().setList(endpoint.getProperty(), value);
            }
        }
    }

    public void setList(int propertyIndex, List value) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.setList(property, value);
    }

    public void setList(Property property, List value) {
        this.set(property, (Object)value);
    }

    public void setLong(String path, long value) {
        if (!DataGraphXPath.isXPath(path)) {
            this.setLong(this.getType().getProperty(path), value);
        } else {
            PathEndpoint endpoint = this.findEndpoint(path);
            if (endpoint != null) {
                endpoint.getSource().setLong(endpoint.getProperty(), value);
            }
        }
    }

    public void setLong(int propertyIndex, long value) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.setLong(property, value);
    }

    public void setLong(Property property, long value) {
        this.set(property, (Object)value);
    }

    public void setShort(String path, short value) {
        if (!DataGraphXPath.isXPath(path)) {
            this.setShort(this.getType().getProperty(path), value);
        } else {
            PathEndpoint endpoint = this.findEndpoint(path);
            if (endpoint != null) {
                endpoint.getSource().setShort(endpoint.getProperty(), value);
            }
        }
    }

    public void setShort(int propertyIndex, short value) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.setShort(property, value);
    }

    public void setShort(Property property, short value) {
        this.set(property, (Object)value);
    }

    public void setString(String path, String value) {
        if (!DataGraphXPath.isXPath(path)) {
            this.setString(this.getType().getProperty(path), value);
        } else {
            PathEndpoint endpoint = this.findEndpoint(path);
            if (endpoint != null) {
                endpoint.getSource().setString(endpoint.getProperty(), value);
            }
        }
    }

    public void setString(int propertyIndex, String value) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        this.setString(property, value);
    }

    public void setString(Property property, String value) {
        this.set(property, (Object)value);
    }

    private PathEndpoint findEndpoint(String path) {
        try {
            DataGraphXPath xpath = new DataGraphXPath(path);
            XPathDataProperty adapter = xpath.findDataProperty(this);
            if (adapter == null) {
                return null;
            }
            return new PathEndpoint(adapter.getProperty(), adapter.getSource());
        }
        catch (JaxenException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidEndpointException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
    }

    private DataObject findDataObject(String path) {
        try {
            DataGraphXPath xpath = new DataGraphXPath(path);
            XPathDataObject adapter = xpath.findDataObject(this);
            if (adapter == null) {
                return null;
            }
            return adapter.getDataObject();
        }
        catch (JaxenException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidEndpointException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
    }

    public DataObject getContainer() {
        return this.container;
    }

    public Property getContainmentProperty() {
        return this.containmentProperty;
    }

    public DataObject getDataObject(String path) {
        if (!DataGraphXPath.isXPath(path)) {
            return this.getDataObject(this.getType().getProperty(path));
        }
        return this.findDataObject(path);
    }

    public DataObject getDataObject(int propertyIndex) {
        Property property = (Property)this.getType().getProperties().get(propertyIndex);
        return (DataObject)this.get(property);
    }

    public DataObject getDataObject(Property property) {
        return (DataObject)this.get(property);
    }

    public List getInstanceProperties() {
        List result = this.getType().getProperties();
        return result;
    }

    public Property getInstanceProperty(String propertyName) {
        return null;
    }

    public Sequence getSequence(String path) {
        DataObject dataObject = this.getDataObject(path);
        if (dataObject != null) {
            if (dataObject.getType().isSequenced()) {
                return dataObject.getSequence();
            }
            throw new UnsupportedOperationException(dataObject.getType().getURI() + "#" + dataObject.getType().getName() + " is not a sequenced type");
        }
        return null;
    }

    public Sequence getSequence(int propertyIndex) {
        DataObject dataObject = this.getDataObject(propertyIndex);
        if (dataObject != null) {
            if (dataObject.getType().isSequenced()) {
                return dataObject.getSequence();
            }
            throw new UnsupportedOperationException(dataObject.getType().getURI() + "#" + dataObject.getType().getName() + " is not a sequenced type");
        }
        return null;
    }

    public Sequence getSequence(Property property) {
        if (!property.getType().isDataType()) {
            throw new UnsupportedOperationException(this.getType().getURI() + "#" + this.getType().getName() + "." + property.getName() + " is a data type property");
        }
        DataObject dataObject = this.getDataObject(property);
        if (dataObject != null) {
            if (dataObject.getType().isSequenced()) {
                return dataObject.getSequence();
            }
            throw new UnsupportedOperationException(dataObject.getType().getURI() + "#" + dataObject.getType().getName() + " is not a sequenced type");
        }
        return null;
    }

    public Sequence getSequence() {
        throw new UnsupportedOperationException(this.getType().getURI() + "#" + this.getType().getName() + " is not a sequenced type");
    }

    @Override
    public void reset(SnapshotMap idMap, String username) {
        if (this.getDataGraph().getChangeSummary().isCreated((DataObject)this)) {
            this.valueObject.put("snapshotTimestamp", idMap.getSnapshotDate());
            List<PropertyPair> pairs = idMap.get(this.getUUID());
            if (pairs != null) {
                for (PropertyPair pair : pairs) {
                    this.valueObject.put(pair.getProp().getName(), pair.getValue());
                }
            }
        } else if (this.getDataGraph().getChangeSummary().isModified((DataObject)this)) {
            this.valueObject.put("snapshotTimestamp", idMap.getSnapshotDate());
            List<PropertyPair> pairs = idMap.get(this.getUUID());
            if (pairs != null) {
                for (PropertyPair pair : pairs) {
                    this.valueObject.put(pair.getProp().getName(), pair.getValue());
                }
            }
        } else if (this.getDataGraph().getChangeSummary().isDeleted((DataObject)this)) {
            this.valueObject.put("snapshotTimestamp", idMap.getSnapshotDate());
        }
    }

    private Property findCachedProperty(PlasmaType type, Property instanceProp) {
        List<Object> result = type.search(instanceProp);
        if (result != null && result.size() > 0) {
            Object obj;
            if (result.size() > 1) {
                log.warn((Object)("expected single value for instance property '" + instanceProp.getName() + "' withing type '" + type.getURI() + "#" + type.getName() + "' and all its base types"));
            }
            if ((obj = result.get(0)) instanceof Property) {
                return (Property)obj;
            }
            log.warn((Object)("expected value for instance property '" + instanceProp.getName() + "' for type '" + type.getURI() + "#" + type.getName() + "' or one of its base types to be a instnace of class, " + Property.class.getName()));
        }
        return null;
    }

    @Override
    public void remove() {
        String thisKey = this.getUUIDAsString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing " + thisKey));
        }
        List properties = this.getType().getProperties();
        for (Property property : properties) {
            if (!property.getType().isDataType()) {
                Property targetProperty = property.getOpposite();
                if (!targetProperty.isMany()) {
                    DataObject target = this.getDataObject(targetProperty);
                    if (target != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("removing " + this.getUUIDAsString() + " from " + property.getName() + "->" + ((PlasmaNode)target).getUUIDAsString()));
                        }
                        target.unset(targetProperty);
                    }
                } else {
                    List list = this.getList(targetProperty);
                    if (list == null) continue;
                    int toRemove = -1;
                    DataObject target = null;
                    for (int i = 0; i < list.size(); ++i) {
                        DataObject targetDataObject = (DataObject)list.get(i);
                        PlasmaNode targetNode = (PlasmaNode)targetDataObject;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("checking source " + this.getUUIDAsString() + " against node " + targetNode.getUUIDAsString()));
                        }
                        if (!targetNode.getUUIDAsString().equals(thisKey)) continue;
                        toRemove = i;
                        target = targetDataObject;
                    }
                    if (toRemove > 0) {
                        log.info((Object)("removing " + this.getUUIDAsString() + " from list " + property.getName() + "->" + ((PlasmaNode)target).getUUIDAsString()));
                        list.remove(toRemove);
                        target.set(targetProperty, (Object)list);
                    } else {
                        log.warn((Object)("could not remove " + this.getUUIDAsString() + " from list " + property.getName() + "->" + ((PlasmaNode)target).getUUIDAsString()));
                    }
                }
                this.unset(property);
                continue;
            }
            if (property.isReadOnly()) continue;
            this.unset(property);
        }
    }

    @Override
    public void accept(PlasmaDataGraphVisitor visitor) {
        this.accept(visitor, this, null, null, this, false, 0, -1, new HashMap<CoreDataObject, HashSet<CoreDataObject>>());
    }

    @Override
    public void accept(PlasmaDataGraphVisitor visitor, int maxLevel) {
        this.accept(visitor, this, null, null, this, false, 0, maxLevel, new HashMap<CoreDataObject, HashSet<CoreDataObject>>());
    }

    @Override
    public void acceptDepthFirst(PlasmaDataGraphVisitor visitor) {
        this.accept(visitor, this, null, null, this, true, 0, -1, new HashMap<CoreDataObject, HashSet<CoreDataObject>>());
    }

    private void accept(PlasmaDataGraphVisitor visitor, CoreDataObject target, CoreDataObject source, String sourceKey, PlasmaDataObject root, boolean depthFirst, int level, int maxLevel, HashMap<CoreDataObject, HashSet<CoreDataObject>> visitedObjects) {
        if (source != null) {
            HashSet<CoreDataObject> visitedChildren;
            if (!visitedObjects.containsKey(source)) {
                visitedObjects.put(source, new HashSet());
            }
            if (!(visitedChildren = visitedObjects.get(source)).contains(target)) {
                visitedChildren.add(target);
            } else {
                return;
            }
        }
        if (!(depthFirst || maxLevel != -1 && level > maxLevel)) {
            visitor.visit(target, source, sourceKey, level);
        }
        List properties = target.getType().getProperties();
        for (Property property : properties) {
            if (property.getType().isDataType()) continue;
            if (!property.isMany()) {
                PlasmaNode node;
                CoreDataObject child;
                PlasmaEdge edge = (PlasmaEdge)target.getValue(property.getName());
                if (edge == null || !edge.canTraverse(target) || (child = (CoreDataObject)(node = edge.getRight()).getDataObject()).equals(root)) continue;
                child.accept(visitor, child, target, property.getName(), root, depthFirst, level + 1, maxLevel, visitedObjects);
                continue;
            }
            List edgeList = (List)target.getValue(property.getName());
            if (edgeList == null) continue;
            PlasmaEdge[] edgeArray = new PlasmaEdge[edgeList.size()];
            edgeList.toArray(edgeArray);
            for (int i = 0; i < edgeArray.length; ++i) {
                PlasmaNode node;
                CoreDataObject child;
                PlasmaEdge edge = edgeArray[i];
                if (!edge.canTraverse(target) || (child = (CoreDataObject)(node = edge.getRight()).getDataObject()).equals(root)) continue;
                child.accept(visitor, child, target, property.getName(), root, depthFirst, level + 1, maxLevel, visitedObjects);
            }
        }
        if (depthFirst && (maxLevel == -1 || level <= maxLevel)) {
            visitor.visit(target, source, sourceKey, level);
        }
    }

    @Override
    public void accept(PlasmaDataGraphEventVisitor visitor) {
        this.accept(visitor, this, null, null, this, 0, new HashMap<CoreDataObject, HashSet<CoreDataObject>>(), 0);
    }

    private void accept(PlasmaDataGraphEventVisitor visitor, CoreDataObject target, CoreDataObject source, String sourceKey, CoreDataObject root, int level, HashMap<CoreDataObject, HashSet<CoreDataObject>> visitedObjects, int visitedCount) {
        if (log.isDebugEnabled()) {
            if (source == null) {
                log.debug((Object)(String.valueOf(level) + "node: " + target.getType().getName() + "(" + target.getUUIDAsString() + ")"));
            } else {
                log.debug((Object)(String.valueOf(level) + "node: " + target.getType().getName() + "( " + target.getUUIDAsString() + ") \tSRC: " + source.getType().getName() + "." + sourceKey + "(" + source.getUUIDAsString() + ")"));
            }
        }
        int currentVisitedCount = visitedCount;
        if (source != null) {
            HashSet<CoreDataObject> visitedChildren;
            if (!visitedObjects.containsKey(source)) {
                visitedObjects.put(source, new HashSet());
            }
            if (!(visitedChildren = visitedObjects.get(source)).contains(target)) {
                visitedChildren.add(target);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("already visited child - parent object: " + source + " - child Object - " + target + "  - skipping duplicate accept."));
                }
                if (++currentVisitedCount >= 1000) {
                    throw new IllegalStateException("data graph contains a circularity: " + source.getType().getName() + "(" + source.getUUIDAsString() + ")." + sourceKey + "->" + target.getType().getName() + "(" + target.getUUIDAsString() + ")");
                }
                return;
            }
        }
        visitor.start(target, source, sourceKey, level);
        List list = target.getType().getProperties();
        PlasmaProperty[] properties = new PlasmaProperty[list.size()];
        list.toArray(properties);
        Arrays.sort(properties, new Comparator<PlasmaProperty>(){

            @Override
            public int compare(PlasmaProperty p1, PlasmaProperty p2) {
                if (p1.getSort() != null && p2.getSort() != null) {
                    if (p1.getSort().getKey() != null && p2.getSort().getKey() != null) {
                        return p1.getSort().getKey().compareTo(p2.getSort().getKey());
                    }
                    return p1.getName().compareTo(p2.getName());
                }
                return p1.getName().compareTo(p2.getName());
            }
        });
        for (PlasmaProperty property : properties) {
            if (property.getType().isDataType()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("property: " + property.getName()));
            }
            if (!property.isMany()) {
                PlasmaNode node;
                CoreDataObject child;
                PlasmaEdge edge = (PlasmaEdge)target.getValue(property.getName());
                if (edge == null || !edge.canTraverse(target) || (child = (CoreDataObject)(node = edge.getRight()).getDataObject()).equals(root)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("accept: " + property.getName()));
                }
                child.accept(visitor, child, target, property.getName(), root, level + 1, visitedObjects, currentVisitedCount);
                continue;
            }
            List edgeList = (List)target.getValue(property.getName());
            if (edgeList == null) continue;
            PlasmaEdge[] edgeArray = new PlasmaEdge[edgeList.size()];
            edgeList.toArray(edgeArray);
            for (int i = 0; i < edgeArray.length; ++i) {
                PlasmaNode node;
                CoreDataObject child;
                PlasmaEdge edge = edgeArray[i];
                if (!edge.canTraverse(target) || (child = (CoreDataObject)(node = edge.getRight()).getDataObject()).equals(root)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("accept: " + property.getName()));
                }
                child.accept(visitor, child, target, property.getName(), root, level + 1, visitedObjects, currentVisitedCount);
            }
        }
        visitor.end(target, source, sourceKey, level);
    }

    @Override
    public DataObject find(String key) {
        Finder finder = new Finder(key);
        this.accept(finder);
        return finder.getResult();
    }

    public String toString() {
        return this.type.toString() + "/" + this.getUUIDAsString();
    }

    @Override
    public String dump() {
        return this.dump(false);
    }

    @Override
    public String dumpDepthFirst() {
        return this.dump(true);
    }

    private String dump(boolean depthFirst) {
        final StringBuilder buf = new StringBuilder();
        PlasmaDataGraphVisitor visitor = new PlasmaDataGraphVisitor(){

            @Override
            public void visit(DataObject target, DataObject source, String sourceKey, int level) {
                buf.append("\r\n");
                for (int i = 0; i < level + 1; ++i) {
                    buf.append("  ");
                }
                if (sourceKey != null) {
                    buf.append("(" + String.valueOf(level) + ")" + sourceKey + ":" + target.getType().getURI() + "#" + target.getType().getName() + "[");
                } else {
                    buf.append("(" + String.valueOf(level) + ")" + target.getType().getURI() + "#" + target.getType().getName() + "[");
                }
                String uuid = ((CoreDataObject)target).getUUIDAsString();
                if (uuid != null) {
                    buf.append("<__UUID__:" + uuid + ">");
                }
                PlasmaType targetType = (PlasmaType)target.getType();
                CoreNode targetNode = (CoreNode)target;
                for (String key : targetNode.getValueObject().getKeys()) {
                    Property definedProperty = targetType.findProperty(key);
                    if (definedProperty != null) continue;
                    Object value = targetNode.getValueObject().get(key);
                    buf.append("<" + key + ":" + value + ">");
                }
                List properties = target.getType().getProperties();
                for (Property property : properties) {
                    Object value;
                    if (!property.getType().isDataType() || (value = target.get(property)) == null) continue;
                    buf.append("<" + property.getName() + ":" + String.valueOf(value) + ">");
                }
                buf.append("]");
            }
        };
        if (!depthFirst) {
            this.accept(visitor);
        } else {
            this.acceptDepthFirst(visitor);
        }
        return buf.toString();
    }

    @Override
    public PlasmaValue[] values() {
        String[] keys = this.valueObject.getKeys();
        PlasmaType type = (PlasmaType)this.getType();
        ArrayList<CoreValue> list = new ArrayList<CoreValue>();
        for (int i = 0; i < keys.length; ++i) {
            PlasmaProperty property = (PlasmaProperty)type.findProperty(keys[i]);
            if (property != null) {
                list.add(new CoreValue(property, this.valueObject.get(keys[i])));
                continue;
            }
            String[] tokens = Key.parse((String)keys[i]);
            if (tokens.length != 2 || !FunctionName.hasName(tokens[0])) continue;
            property = (PlasmaProperty)type.getProperty(tokens[1]);
            Object value = this.valueObject.get(keys[i]);
            FunctionIdentifier func = new FunctionIdentifier(tokens[0]);
            list.add(new CoreValue(property, value, func));
        }
        PlasmaValue[] result = new PlasmaValue[list.size()];
        list.toArray(result);
        return result;
    }

    @Override
    public Object get(FunctionName func, Property property) {
        Key key = new Key((Object[])new String[]{func.name(), property.getName()});
        return this.valueObject.get(key.toString());
    }

    @Override
    public void set(FunctionName func, Property property, Object value) {
        Key key = new Key((Object[])new String[]{func.name(), property.getName()});
        this.valueObject.put(key.toString(), value);
    }

    class Finder
    implements PlasmaDataGraphVisitor {
        private DataObject result;
        private String key;

        private Finder() {
        }

        public Finder(String key) {
            this.key = key;
        }

        @Override
        public void visit(DataObject target, DataObject source, String sourceKey, int level) {
            if (((PlasmaNode)target).getUUIDAsString().equals(this.key)) {
                this.result = target;
            }
        }

        public DataObject getResult() {
            return this.result;
        }
    }
}

