/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.TypeHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ext.com.google.common.cache.CacheBuilder;
import org.apache.jena.ext.com.google.common.cache.CacheLoader;
import org.apache.jena.ext.com.google.common.cache.LoadingCache;
import org.apache.jena.ext.com.google.common.cache.RemovalListener;
import org.apache.jena.ext.com.google.common.cache.RemovalNotification;
import org.plasma.runtime.ConfigurationException;
import org.plasma.runtime.PlasmaRuntime;
import org.plasma.sdo.PlasmaDataObjectConstants;
import org.plasma.sdo.PlasmaDataObjectException;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.core.CoreType;
import org.plasma.sdo.repository.Classifier;
import org.plasma.sdo.repository.PlasmaRepository;
import org.plasma.sdo.repository.Stereotype;

public class PlasmaTypeHelper
implements TypeHelper {
    private static Log log = LogFactory.getLog(PlasmaTypeHelper.class);
    public static volatile PlasmaTypeHelper INSTANCE = PlasmaTypeHelper.initializeInstance();
    private LoadingCache<String, Type> namespaceQualifiedNameToTypeCache;
    private LoadingCache<String, List<Type>> namespaceToTypesCache;
    private Map<String, String> qualifiedAliasToLogicalNameMap = new HashMap<String, String>();

    private PlasmaTypeHelper() {
        int max = 3000;
        int timeout = 30;
        List configProps = PlasmaRuntime.getInstance().getSDO().getProperties();
        if (configProps != null) {
            for (org.plasma.runtime.Property prop : configProps) {
                if (prop.getName().equals("org.plasma.sdo.type.cache.max")) {
                    try {
                        max = Integer.parseInt(prop.getValue());
                    }
                    catch (NumberFormatException e) {
                        throw new ConfigurationException((Throwable)e);
                    }
                }
                if (!prop.getName().equals("org.plasma.sdo.type.cache.timeout")) continue;
                try {
                    timeout = Integer.parseInt(prop.getValue());
                }
                catch (NumberFormatException e) {
                    throw new ConfigurationException((Throwable)e);
                }
            }
        }
        this.namespaceQualifiedNameToTypeCache = CacheBuilder.newBuilder().maximumSize((long)max).removalListener((RemovalListener)new RemovalListener<String, Type>(){

            public void onRemoval(RemovalNotification<String, Type> notification) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("removed: " + (String)notification.getKey() + " reason: " + notification.getCause()));
                }
            }
        }).expireAfterAccess((long)timeout, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Type>(){

            public Type load(String namespaceQualifiedName) throws Exception {
                String qualifiedPhysicalName;
                String[] tokens;
                CoreType result;
                String qualifiedLogicalName = namespaceQualifiedName;
                if (PlasmaTypeHelper.this.qualifiedAliasToLogicalNameMap.containsKey(qualifiedLogicalName)) {
                    qualifiedLogicalName = (String)PlasmaTypeHelper.this.qualifiedAliasToLogicalNameMap.get(qualifiedLogicalName);
                }
                if (!(result = new CoreType((tokens = qualifiedLogicalName.split("#"))[0], tokens[1])).getName().equals(tokens[1])) {
                    String aliasQualifiedName = tokens[0] + "#" + result.getName();
                    PlasmaTypeHelper.this.qualifiedAliasToLogicalNameMap.put(aliasQualifiedName, qualifiedLogicalName);
                }
                if ((qualifiedPhysicalName = PlasmaTypeHelper.this.findQualifiedPhysicalName(result)) != null) {
                    PlasmaTypeHelper.this.qualifiedAliasToLogicalNameMap.put(qualifiedPhysicalName, qualifiedLogicalName);
                }
                return result;
            }
        });
        this.namespaceToTypesCache = CacheBuilder.newBuilder().maximumSize((long)max).removalListener((RemovalListener)new RemovalListener<String, List<Type>>(){

            public void onRemoval(RemovalNotification<String, List<Type>> notification) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("removed: " + (String)notification.getKey() + " reason: " + notification.getCause()));
                }
            }
        }).expireAfterAccess((long)timeout, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, List<Type>>(){

            public List<Type> load(String uri) throws Exception {
                ArrayList<Type> result = new ArrayList<Type>();
                List<Classifier> list = PlasmaRepository.getInstance().getClassifiers(uri);
                for (Classifier classifier : list) {
                    if (classifier instanceof Stereotype) {
                        log.warn((Object)("ignoring stereotype: " + classifier.getName()));
                        continue;
                    }
                    Type type = PlasmaTypeHelper.this.getType(uri, classifier.getName());
                    result.add(type);
                }
                return result;
            }
        });
    }

    private static synchronized PlasmaTypeHelper initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlasmaTypeHelper();
        }
        return INSTANCE;
    }

    public Type define(DataObject type) {
        throw new RuntimeException("not yet supported");
    }

    public List define(List types) {
        throw new RuntimeException("not yet supported");
    }

    public Property defineOpenContentProperty(String uri, DataObject property) {
        throw new RuntimeException("not yet supported");
    }

    public Property getOpenContentProperty(String uri, String propertyName) {
        throw new RuntimeException("not yet supported");
    }

    public Type getType(String uri, String typeName) {
        String qualifiedName = uri + "#" + typeName;
        try {
            return (Type)this.namespaceQualifiedNameToTypeCache.get((Object)qualifiedName);
        }
        catch (ExecutionException e) {
            throw new PlasmaDataObjectException(e);
        }
    }

    public Type findTypeByPhysicalName(String uriPhisicalName, String typePhysicalName) {
        String qualifiedPhysicalName = uriPhisicalName + "#" + typePhysicalName;
        try {
            return (Type)this.namespaceQualifiedNameToTypeCache.get((Object)qualifiedPhysicalName);
        }
        catch (ExecutionException e) {
            throw new PlasmaDataObjectException(e);
        }
    }

    public void releaseType(Type type) {
        this.releaseType(type.getURI(), type.getName());
    }

    public void releaseType(String uri, String typeName) {
        String qualifiedName = uri + "#" + typeName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("releasing type: " + qualifiedName));
        }
        this.namespaceQualifiedNameToTypeCache.invalidate((Object)qualifiedName);
    }

    public Type getType(Class interfaceClass) {
        String uri = null;
        try {
            Field uriField = interfaceClass.getDeclaredField(PlasmaDataObjectConstants.NAMESPACE_URI_FIELD_NAME);
            uri = (String)uriField.get(null);
        }
        catch (SecurityException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (NoSuchFieldException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (IllegalArgumentException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (IllegalAccessException e) {
            throw new PlasmaDataObjectException(e);
        }
        return this.getType(uri, interfaceClass.getSimpleName());
    }

    public List<Type> getTypes(String uri) {
        try {
            return (List)this.namespaceToTypesCache.get((Object)uri);
        }
        catch (ExecutionException e) {
            throw new PlasmaDataObjectException(e);
        }
    }

    private String getQualifiedName(PlasmaType type) {
        return type.getURI() + "#" + type.getName();
    }

    private String findQualifiedPhysicalName(PlasmaType type) {
        String uriPhysicalName = type.getURIPhysicalName();
        if (uriPhysicalName == null) {
            return null;
        }
        String physicalName = type.getPhysicalName();
        if (physicalName == null) {
            return null;
        }
        return uriPhysicalName + "#" + physicalName;
    }
}

