/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning;

import commonj.sdo.Property;
import commonj.sdo.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.common.exception.ProvisioningException;
import org.plasma.metamodel.Body;
import org.plasma.metamodel.Class;
import org.plasma.metamodel.ClassRef;
import org.plasma.metamodel.ConcurentDataFlavor;
import org.plasma.metamodel.ConcurrencyType;
import org.plasma.metamodel.DataTypeRef;
import org.plasma.metamodel.Derivation;
import org.plasma.metamodel.Documentation;
import org.plasma.metamodel.DocumentationType;
import org.plasma.metamodel.EnumerationConstraint;
import org.plasma.metamodel.EnumerationRef;
import org.plasma.metamodel.Increment;
import org.plasma.metamodel.KeyType;
import org.plasma.metamodel.Model;
import org.plasma.metamodel.Package;
import org.plasma.metamodel.PackageRef;
import org.plasma.metamodel.Sort;
import org.plasma.metamodel.TypeRef;
import org.plasma.metamodel.VisibilityType;
import org.plasma.metamodel.XmlNodeType;
import org.plasma.metamodel.XmlProperty;
import org.plasma.query.Query;
import org.plasma.query.collector.PropertySelection;
import org.plasma.query.collector.PropertySelectionCollector;
import org.plasma.query.model.Select;
import org.plasma.runtime.DataAccessProviderName;
import org.plasma.runtime.NonExistantNamespaceException;
import org.plasma.runtime.PlasmaRuntime;
import org.plasma.sdo.Alias;
import org.plasma.sdo.Concurrent;
import org.plasma.sdo.DataType;
import org.plasma.sdo.Key;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.ValueConstraint;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.plasma.sdo.repository.Comment;
import org.plasma.sdo.repository.Enumeration;
import org.plasma.sdo.repository.EnumerationLiteral;
import org.plasma.sdo.repository.Namespace;
import org.plasma.sdo.repository.PlasmaRepository;

public class MetamodelAssembler {
    private static final String DERIVED_ARTIFACT_URI_PREFIX = "http://derived-artifact/";
    private static Log log = LogFactory.getLog(MetamodelAssembler.class);
    private Model model;
    private List<Namespace> namespaces;
    private Map<String, Package> packageMap = new HashMap<String, Package>();
    private Map<String, Class> classMap = new HashMap<String, Class>();
    private Map<String, org.plasma.metamodel.Enumeration> enumerationMap = new HashMap<String, org.plasma.metamodel.Enumeration>();
    private String destNamespaceURI;
    private DataAccessProviderName serviceName;

    public MetamodelAssembler() {
        this(PlasmaRepository.getInstance().getAllNamespaces());
    }

    public MetamodelAssembler(DataAccessProviderName serviceName) {
        this.serviceName = serviceName;
        this.construct(PlasmaRepository.getInstance().getAllNamespaces());
    }

    public MetamodelAssembler(List<Namespace> namespaces) {
        this.construct(PlasmaRepository.getInstance().getAllNamespaces());
    }

    public MetamodelAssembler(Query query, String destNamespaceURI, String destNamespacePrefix) {
        this.construct(query, destNamespaceURI, destNamespacePrefix);
    }

    private void construct(List<Namespace> namespaces) {
        this.namespaces = namespaces;
        ArrayList<Namespace> namespacesToProcess = new ArrayList<Namespace>();
        for (Namespace namespace : this.namespaces) {
            if (this.serviceName != null) {
                try {
                    PlasmaRuntime.getInstance().getProvisioningByNamespaceURI(this.serviceName, namespace.getUri());
                }
                catch (NonExistantNamespaceException e) {
                    log.debug((Object)("ignoring non " + this.serviceName.name() + " namespace: " + namespace.getUri()));
                    continue;
                }
            }
            namespacesToProcess.add(namespace);
        }
        if (namespacesToProcess.size() == 0) {
            throw new ProvisioningException("no namespaces to process");
        }
        if (namespacesToProcess.size() > 1) {
            this.model = new Model();
            this.model.setId(UUID.randomUUID().toString());
            this.model.setName("derived model");
            this.model.setUri(DERIVED_ARTIFACT_URI_PREFIX + UUID.randomUUID().toString());
            Documentation documentation = new Documentation();
            documentation.setType(DocumentationType.DEFINITION);
            Body body = new Body();
            body.setValue("derived model");
            documentation.setBody(body);
            this.model.getDocumentations().add(documentation);
        }
        for (Namespace namespace : namespacesToProcess) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("processing namespace: " + namespace.getUri()));
            }
            List<Type> types = PlasmaTypeHelper.INSTANCE.getTypes(namespace.getUri());
            for (Type type : types) {
                String qualifiedName;
                Class clss;
                PlasmaType plasmaType = (PlasmaType)type;
                Package pkg = this.packageMap.get(plasmaType.getURI());
                if (pkg == null) {
                    if (namespacesToProcess.size() > 1) {
                        pkg = this.createPackage(namespace, plasmaType, false);
                        this.model.getPackages().add(pkg);
                    } else {
                        pkg = this.createPackage(namespace, plasmaType, true);
                        this.model = (Model)pkg;
                    }
                    this.packageMap.put(plasmaType.getURI(), pkg);
                }
                if ((clss = this.classMap.get(qualifiedName = String.valueOf(plasmaType.getURI()) + "#" + plasmaType.getName())) != null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("processing type: " + qualifiedName));
                }
                clss = this.createClass(pkg, plasmaType);
                assert (clss.getUri().equals(pkg.getUri()));
                this.classMap.put(qualifiedName, clss);
                this.createEnumerations(pkg, clss, plasmaType);
            }
        }
        for (Class clss : this.classMap.values()) {
            PlasmaType sdoType = (PlasmaType)PlasmaTypeHelper.INSTANCE.getType(clss.getUri(), clss.getName());
            Package pkg = this.packageMap.get(sdoType.getURI());
            List properties = sdoType.getDeclaredProperties();
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding " + properties.size() + " properties class: " + clss.getUri() + "#" + clss.getName()));
            }
            this.createFields(pkg, clss, properties);
        }
    }

    public Model getModel() {
        return this.model;
    }

    private void createFields(Package pkg, Class clss, List<Property> properties) {
        for (Property prop : properties) {
            PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
            if (plasmaProperty.getPhysicalName() == null && !plasmaProperty.isMany()) {
                log.warn((Object)("no physical name found for singular property, " + plasmaProperty.getContainingType().getURI() + "#" + plasmaProperty.getContainingType().getName() + "." + plasmaProperty.getName()));
            }
            org.plasma.metamodel.Property field = null;
            if (plasmaProperty.getType().isDataType()) {
                field = this.createDataProperty(pkg, clss, plasmaProperty);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding data property " + clss.getUri() + "#" + clss.getName() + "." + field.getName()));
                }
            } else {
                PlasmaProperty oppositeProperty = (PlasmaProperty)plasmaProperty.getOpposite();
                field = this.createReferenceProperty(pkg, clss, plasmaProperty, oppositeProperty);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding reference property " + clss.getUri() + "#" + clss.getName() + "." + field.getName()));
                }
            }
            clss.getProperties().add(field);
        }
    }

    private void createEnumerations(Package pkg, Class clss, PlasmaType sdoType) {
        List properties = sdoType.getDeclaredProperties();
        for (Property prop : properties) {
            PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
            if (plasmaProperty.getPhysicalName() == null) {
                if (plasmaProperty.isMany()) continue;
                log.warn((Object)("no physical name found for singular property, " + plasmaProperty.getContainingType().getURI() + "#" + plasmaProperty.getContainingType().getName() + "." + plasmaProperty.getName()));
                continue;
            }
            if (!plasmaProperty.getType().isDataType() || plasmaProperty.getRestriction() == null) continue;
            Enumeration sdoEnumeration = plasmaProperty.getRestriction();
            String enumKey = String.valueOf(clss.getUri()) + "#" + sdoEnumeration.getName();
            org.plasma.metamodel.Enumeration enumeration = this.enumerationMap.get(enumKey);
            if (enumeration != null) continue;
            enumeration = this.createEnumeration(clss, sdoEnumeration);
            pkg.getEnumerations().add(enumeration);
            this.enumerationMap.put(enumKey, enumeration);
        }
    }

    private org.plasma.metamodel.Enumeration createEnumeration(Class clss, Enumeration sdoEnum) {
        org.plasma.metamodel.Enumeration enumeration = new org.plasma.metamodel.Enumeration();
        enumeration.setName(sdoEnum.getName());
        enumeration.setUri(clss.getUri());
        enumeration.setId(UUID.randomUUID().toString());
        if (sdoEnum.findAlias() != null) {
            Alias sdoAlias = sdoEnum.findAlias();
            org.plasma.metamodel.Alias alias = new org.plasma.metamodel.Alias();
            enumeration.setAlias(alias);
            alias.setPhysicalName(sdoAlias.getPhysicalName());
            alias.setLocalName(sdoAlias.getLocalName());
            alias.setBusinessName(sdoAlias.getBusinessName());
        }
        for (EnumerationLiteral lit : sdoEnum.getOwnedLiteral()) {
            org.plasma.metamodel.EnumerationLiteral literal = new org.plasma.metamodel.EnumerationLiteral();
            literal.setName(lit.getName());
            literal.setValue(lit.getName());
            if (lit.findAlias() != null) {
                Alias sdoAlias = lit.findAlias();
                org.plasma.metamodel.Alias alias = new org.plasma.metamodel.Alias();
                literal.setAlias(alias);
                alias.setPhysicalName(sdoAlias.getPhysicalName());
                alias.setLocalName(sdoAlias.getLocalName());
                alias.setBusinessName(sdoAlias.getBusinessName());
            }
            if (lit.getComments() != null && lit.getComments().size() > 0) {
                for (Comment comment : lit.getComments()) {
                    Documentation documentation = new Documentation();
                    documentation.setType(DocumentationType.DEFINITION);
                    Body body = new Body();
                    body.setValue(comment.getBody());
                    documentation.setBody(body);
                    literal.getDocumentations().add(documentation);
                }
            }
            enumeration.getEnumerationLiterals().add(literal);
        }
        return enumeration;
    }

    private org.plasma.metamodel.Property createDataProperty(Package pkg, Class clss, PlasmaProperty sourceProperty) {
        Enumeration sdoEnum;
        org.plasma.metamodel.Property property = this.createProperty(pkg, clss, sourceProperty);
        if (!sourceProperty.getType().isDataType()) {
            throw new IllegalArgumentException("given property is not a data property, " + clss.getUri() + "#" + clss.getName() + "." + sourceProperty.getName());
        }
        DataType sdoType = DataType.valueOf((String)sourceProperty.getType().getName());
        DataTypeRef type = this.createDatatype(sdoType.name());
        property.setType((TypeRef)type);
        if (sourceProperty.getKey() != null) {
            Key sdoKey = sourceProperty.getKey();
            org.plasma.metamodel.Key key = new org.plasma.metamodel.Key();
            key.setType(KeyType.valueOf((String)sdoKey.getType().name().toUpperCase()));
            property.setKey(key);
        }
        if (sourceProperty.getConcurrent() != null) {
            Concurrent sdoConcurrent = sourceProperty.getConcurrent();
            org.plasma.metamodel.Concurrent conc = new org.plasma.metamodel.Concurrent();
            conc.setType(ConcurrencyType.valueOf((String)sdoConcurrent.getType().name().toUpperCase()));
            conc.setDataFlavor(ConcurentDataFlavor.valueOf((String)sdoConcurrent.getDataFlavor().name().toUpperCase()));
            property.setConcurrent(conc);
        }
        if (sourceProperty.getXmlProperty() != null) {
            org.plasma.sdo.XmlProperty sdoXmlProperty = sourceProperty.getXmlProperty();
            XmlProperty xmlProp = new XmlProperty();
            xmlProp.setNodeType(XmlNodeType.valueOf((String)sdoXmlProperty.getNodeType().name().toUpperCase()));
            property.setXmlProperty(xmlProp);
        }
        if (sourceProperty.getIncrement() != null) {
            Increment increment = new Increment();
            property.setIncrement(increment);
        }
        if (sourceProperty.getValueConstraint() != null) {
            ValueConstraint sdoValConst = sourceProperty.getValueConstraint();
            org.plasma.metamodel.ValueConstraint valueConstraint = new org.plasma.metamodel.ValueConstraint();
            if (sdoValConst.getFractionDigits() != null) {
                valueConstraint.setFractionDigits(sdoValConst.getFractionDigits());
            }
            if (sdoValConst.getMaxExclusive() != null) {
                valueConstraint.setMaxExclusive(sdoValConst.getMaxExclusive());
            }
            if (sdoValConst.getMaxInclusive() != null) {
                valueConstraint.setMaxInclusive(sdoValConst.getMaxInclusive());
            }
            if (sdoValConst.getMaxLength() != null) {
                valueConstraint.setMaxLength(sdoValConst.getMaxLength());
            }
            if (sdoValConst.getMinExclusive() != null) {
                valueConstraint.setMinExclusive(sdoValConst.getMinExclusive());
            }
            if (sdoValConst.getMinInclusive() != null) {
                valueConstraint.setMinInclusive(sdoValConst.getMinInclusive());
            }
            if (sdoValConst.getMinLength() != null) {
                valueConstraint.setMinLength(sdoValConst.getMinLength());
            }
            if (sdoValConst.getPattern() != null) {
                valueConstraint.setPattern(sdoValConst.getPattern());
            }
            property.setValueConstraint(valueConstraint);
        }
        if ((sdoEnum = sourceProperty.getRestriction()) != null) {
            String enumKey = String.valueOf(clss.getUri()) + "#" + sdoEnum.getName();
            org.plasma.metamodel.Enumeration enumeration = this.enumerationMap.get(enumKey);
            if (enumeration == null) {
                enumeration = this.createEnumeration(clss, sdoEnum);
                pkg.getEnumerations().add(enumeration);
                this.enumerationMap.put(enumKey, enumeration);
            }
            EnumerationConstraint enumConstraint = new EnumerationConstraint();
            EnumerationRef enumRef = new EnumerationRef();
            enumRef.setName(enumeration.getName());
            enumRef.setUri(enumeration.getUri());
            enumConstraint.setValue(enumRef);
            property.setEnumerationConstraint(enumConstraint);
        }
        return property;
    }

    private org.plasma.metamodel.Property createReferenceProperty(Package pkg, Class clss, PlasmaProperty sourceProperty, PlasmaProperty oppositeProperty) {
        org.plasma.metamodel.Property property = this.createProperty(pkg, clss, sourceProperty);
        if (!sourceProperty.getType().isDataType()) {
            String qualifiedName = null;
            qualifiedName = this.destNamespaceURI != null ? String.valueOf(this.destNamespaceURI) + "#" + sourceProperty.getType().getName() : String.valueOf(sourceProperty.getType().getURI()) + "#" + sourceProperty.getType().getName();
            Class propertyClass = this.classMap.get(qualifiedName);
            if (propertyClass == null) {
                throw new ProvisioningException("could not find class, " + qualifiedName);
            }
            ClassRef ref = new ClassRef();
            ref.setName(propertyClass.getName());
            ref.setUri(propertyClass.getUri());
            property.setType((TypeRef)ref);
            if (oppositeProperty != null) {
                property.setOpposite(oppositeProperty.getName());
            }
        } else {
            throw new IllegalArgumentException("given property is not a reference property, " + clss.getUri() + "#" + clss.getName() + "." + sourceProperty.getName());
        }
        return property;
    }

    private org.plasma.metamodel.Property createProperty(Package pkg, Class clss, PlasmaProperty sourceProperty) {
        org.plasma.metamodel.Property property = new org.plasma.metamodel.Property();
        property.setId(UUID.randomUUID().toString());
        property.setName(sourceProperty.getName());
        property.setNullable(sourceProperty.isNullable());
        property.setReadOnly(Boolean.valueOf(sourceProperty.isReadOnly()));
        property.setMany(sourceProperty.isMany());
        property.setVisibility(VisibilityType.PUBLIC);
        if (sourceProperty.getAlias() != null) {
            Alias sdoAlias = sourceProperty.getAlias();
            org.plasma.metamodel.Alias alias = new org.plasma.metamodel.Alias();
            property.setAlias(alias);
            alias.setPhysicalName(sdoAlias.getPhysicalName());
            alias.setLocalName(sdoAlias.getLocalName());
            alias.setBusinessName(sdoAlias.getBusinessName());
        }
        if (sourceProperty.getSort() != null) {
            org.plasma.sdo.Sort sdoSort = sourceProperty.getSort();
            Sort sort = new Sort();
            sort.setKey(sdoSort.getKey());
            property.setSort(sort);
        }
        if (sourceProperty.getDescription() != null && sourceProperty.getDescription().size() > 0) {
            for (Comment comment : sourceProperty.getDescription()) {
                Documentation documentation = new Documentation();
                documentation.setType(DocumentationType.DEFINITION);
                Body body = new Body();
                body.setValue(comment.getBody());
                documentation.setBody(body);
                property.getDocumentations().add(documentation);
            }
        }
        return property;
    }

    private DataTypeRef createDatatype(String name) {
        DataTypeRef dataTypeRef = new DataTypeRef();
        dataTypeRef.setName(name);
        dataTypeRef.setUri(PlasmaRuntime.getInstance().getSDODataTypesNamespace().getUri());
        return dataTypeRef;
    }

    private Package createPackage(Namespace namespace, PlasmaType type, boolean modelPackage) {
        Object pkg = null;
        pkg = !modelPackage ? new Package() : new Model();
        pkg.setName(namespace.getName());
        pkg.setId(UUID.randomUUID().toString());
        if (namespace.findAlias() != null) {
            Alias sdoAlias = namespace.findAlias();
            org.plasma.metamodel.Alias alias = new org.plasma.metamodel.Alias();
            pkg.setAlias(alias);
            alias.setPhysicalName(sdoAlias.getPhysicalName());
            alias.setLocalName(sdoAlias.getLocalName());
            alias.setBusinessName(sdoAlias.getBusinessName());
        }
        for (Comment cmt : namespace.getComments()) {
            Documentation doc = new Documentation();
            doc.setType(DocumentationType.DEFINITION);
            Body body = new Body();
            body.setValue(cmt.getBody());
            doc.setBody(body);
            pkg.getDocumentations().add(doc);
        }
        pkg.setUri(type.getURI());
        return pkg;
    }

    private Class createClass(Package pkg, PlasmaType plasmaType) {
        Class clss = new Class();
        pkg.getClazzs().add(clss);
        clss.setId(UUID.randomUUID().toString());
        clss.setName(plasmaType.getName());
        clss.setUri(plasmaType.getURI());
        clss.setAbstract(Boolean.valueOf(plasmaType.isAbstract()));
        if (plasmaType.getPhysicalName() != null) {
            org.plasma.metamodel.Alias alias = new org.plasma.metamodel.Alias();
            clss.setAlias(alias);
            alias.setPhysicalName(plasmaType.getPhysicalName());
        }
        if (plasmaType.getAlias() != null) {
            Alias sdoAlias = plasmaType.getAlias();
            org.plasma.metamodel.Alias alias = new org.plasma.metamodel.Alias();
            clss.setAlias(alias);
            alias.setPhysicalName(sdoAlias.getPhysicalName());
            alias.setLocalName(sdoAlias.getLocalName());
            alias.setBusinessName(sdoAlias.getBusinessName());
        }
        for (Type baseType : plasmaType.getBaseTypes()) {
            ClassRef ref = new ClassRef();
            ref.setName(baseType.getName());
            ref.setUri(baseType.getURI());
            clss.getSuperClasses().add(ref);
        }
        if (plasmaType.getDescription() != null && plasmaType.getDescription().size() > 0) {
            for (Comment comment : plasmaType.getDescription()) {
                Documentation documentation = new Documentation();
                documentation.setType(DocumentationType.DEFINITION);
                Body body = new Body();
                body.setValue(comment.getBody());
                documentation.setBody(body);
                clss.getDocumentations().add(documentation);
            }
        }
        return clss;
    }

    private void construct(Query query, String destNamespaceURI, String destNamespacePrefix) {
        if (destNamespaceURI == null || destNamespaceURI.trim().length() == 0) {
            throw new IllegalArgumentException("expected argument 'destNamespaceURI'");
        }
        this.destNamespaceURI = destNamespaceURI;
        this.model = new Model();
        this.model.setId(UUID.randomUUID().toString());
        this.model.setUri(destNamespaceURI);
        this.model.setName(query.getName());
        Derivation derivation = new Derivation();
        PackageRef packageRef = new PackageRef();
        packageRef.setName(query.getName());
        packageRef.setUri(query.getFromClause().getUri());
        derivation.setPackageSupplier(packageRef);
        this.model.setDerivation(derivation);
        Documentation documentation = new Documentation();
        documentation.setType(DocumentationType.DEFINITION);
        Body body = new Body();
        body.setValue("derived model");
        documentation.setBody(body);
        this.model.getDocumentations().add(documentation);
        PlasmaType rootType = (PlasmaType)PlasmaTypeHelper.INSTANCE.getType(query.getFromClause().getUri(), query.getFromClause().getName());
        ClassRef rootClass = new ClassRef();
        rootClass.setName(rootType.getName());
        rootClass.setUri(rootType.getURI());
        this.model.setRootClass(rootClass);
        PropertySelectionCollector collector = new PropertySelectionCollector((Select)query.getSelectClause(), rootType);
        Map<Type, List<String>> queryPropertyMap = collector.getResult();
        for (PlasmaType plasmaType : queryPropertyMap.keySet()) {
            Class clazz = this.createClass((Package)this.model, plasmaType);
            this.classMap.put(String.valueOf(destNamespaceURI) + "#" + clazz.getName(), clazz);
        }
        for (PlasmaType plasmaType : queryPropertyMap.keySet()) {
            this.constructBaseTypes(query, plasmaType, collector, queryPropertyMap);
        }
        for (PlasmaType plasmaType : queryPropertyMap.keySet()) {
            PlasmaProperty plasmaProperty;
            List<String> list = queryPropertyMap.get(plasmaType);
            Class clss = this.classMap.get(String.valueOf(destNamespaceURI) + "#" + plasmaType.getName());
            for (Property p : plasmaType.getDeclaredProperties()) {
                plasmaProperty = (PlasmaProperty)p;
                if (!plasmaProperty.getType().isDataType() || !list.contains(plasmaProperty.getName())) continue;
                org.plasma.metamodel.Property field = this.createDataProperty((Package)this.model, clss, plasmaProperty);
                Sort sort = new Sort();
                sort.setKey(String.valueOf(list.indexOf(plasmaProperty.getName())));
                field.setSort(sort);
                clss.getProperties().add(field);
            }
            for (Property p2 : plasmaType.getDeclaredProperties()) {
                PlasmaType oppositeType;
                plasmaProperty = (PlasmaProperty)p2;
                if (plasmaProperty.getType().isDataType() || !list.contains(plasmaProperty.getName())) continue;
                PlasmaProperty oppositeProperty = (PlasmaProperty)plasmaProperty.getOpposite();
                org.plasma.metamodel.Property field = null;
                field = oppositeProperty != null ? (collector.hasProperty(oppositeType = (PlasmaType)plasmaProperty.getType(), oppositeProperty) ? this.createReferenceProperty((Package)this.model, clss, plasmaProperty, oppositeProperty) : (plasmaProperty.isMany() ? this.createReferenceProperty((Package)this.model, clss, plasmaProperty, oppositeProperty) : this.createReferenceProperty((Package)this.model, clss, plasmaProperty, null))) : this.createReferenceProperty((Package)this.model, clss, plasmaProperty, null);
                Sort sequence = new Sort();
                sequence.setKey(String.valueOf(list.indexOf(plasmaProperty.getName())));
                field.setSort(sequence);
                clss.getProperties().add(field);
            }
            this.constructImplicitDatatypeProperties(query, plasmaType, clss, list);
            this.constructImplicitReferenceProperties(query, plasmaType, clss, collector, list);
        }
    }

    private void constructBaseTypes(Query query, Type sdoType, PropertySelection collector, Map<Type, List<String>> queryPropertyMap) {
        for (Type base : sdoType.getBaseTypes()) {
            PlasmaType sdoBaseType = (PlasmaType)PlasmaTypeHelper.INSTANCE.getType(base.getURI(), base.getName());
            Class existing = this.classMap.get(String.valueOf(this.destNamespaceURI) + "#" + base.getName());
            if (existing == null) {
                Class baseClss = this.createClass((Package)this.model, (PlasmaType)base);
                this.classMap.put(String.valueOf(this.destNamespaceURI) + "#" + baseClss.getName(), baseClss);
                List<String> baseList = queryPropertyMap.get(String.valueOf(base.getURI()) + "#" + base.getName());
                this.constructImplicitDatatypeProperties(query, sdoBaseType, baseClss, baseList);
                this.constructImplicitReferenceProperties(query, sdoBaseType, baseClss, collector, baseList);
            }
            this.constructBaseTypes(query, sdoBaseType, collector, queryPropertyMap);
        }
    }

    private void constructImplicitDatatypeProperties(Query query, PlasmaType sdoType, Class clss, List<String> list) {
        for (Property p : sdoType.getDeclaredProperties()) {
            PlasmaProperty plasmaProperty = (PlasmaProperty)p;
            if (!plasmaProperty.getType().isDataType() || list != null && list.contains(plasmaProperty.getName()) || plasmaProperty.getKey() == null && plasmaProperty.getConcurrent() == null) continue;
            org.plasma.metamodel.Property field = this.createDataProperty((Package)this.model, clss, plasmaProperty);
            field.setVisibility(VisibilityType.PRIVATE);
            field.setNullable(true);
            Sort sequence = new Sort();
            sequence.setKey(String.valueOf(clss.getProperties().size()));
            field.setSort(sequence);
            clss.getProperties().add(field);
        }
    }

    private void constructImplicitReferenceProperties(Query query, PlasmaType sdoType, Class clss, PropertySelection collector, List<String> list) {
        for (Property p2 : sdoType.getDeclaredProperties()) {
            PlasmaType oppositeType;
            PlasmaProperty oppositeProperty;
            PlasmaProperty plasmaProperty = (PlasmaProperty)p2;
            if (plasmaProperty.getType().isDataType() || list != null && list.contains(plasmaProperty.getName()) || (oppositeProperty = (PlasmaProperty)plasmaProperty.getOpposite()) == null || plasmaProperty.isMany() || !collector.hasProperty(oppositeType = (PlasmaType)plasmaProperty.getType(), oppositeProperty)) continue;
            String oppositeQualName = String.valueOf(this.destNamespaceURI) + "#" + oppositeType.getName();
            Class oppositeClass = this.classMap.get(oppositeQualName);
            if (oppositeClass == null) {
                throw new IllegalStateException("could not find class, " + oppositeQualName);
            }
            org.plasma.metamodel.Property property = this.createReferenceProperty((Package)this.model, clss, plasmaProperty, oppositeProperty);
            property.setVisibility(VisibilityType.PRIVATE);
            Sort sequence = new Sort();
            sequence.setKey(String.valueOf(clss.getProperties().size()));
            property.setSort(sequence);
            clss.getProperties().add(property);
        }
    }
}

